/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class XmlString {
    public static String encode(String string) {
        return XmlString.encode(string.toCharArray());
    }

    public static String encode(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (XmlString.needToChange(cArray[i])) {
                stringBuffer.append(XmlString.encode(cArray[i], false));
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String encode(char c) {
        return XmlString.encode(c, true);
    }

    public static String convertToXmlString(char c) {
        return XmlString.encode(c);
    }

    public static void encode(char[] cArray, Writer writer) throws IOException {
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (XmlString.needToChange(cArray[i])) {
                printWriter.write(XmlString.encode(cArray[i], false));
                continue;
            }
            printWriter.write(cArray[i]);
        }
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '&') {
                stringBuffer.append(c);
                continue;
            }
            if (string.charAt(i + 1) == 'l' && string.charAt(i + 2) == 't' && string.charAt(i + 3) == ';') {
                stringBuffer.append('<');
                i += 3;
                continue;
            }
            if (string.charAt(i + 1) == 'g' && string.charAt(i + 2) == 't' && string.charAt(i + 3) == ';') {
                stringBuffer.append('>');
                i += 3;
                continue;
            }
            if (string.charAt(i + 1) == 'a' && string.charAt(i + 2) == 'm' && string.charAt(i + 3) == 'p' && string.charAt(i + 4) == ';') {
                stringBuffer.append('&');
                i += 4;
                continue;
            }
            if (string.charAt(i + 1) == 'q' && string.charAt(i + 2) == 'u' && string.charAt(i + 3) == 'o' && string.charAt(i + 4) == 't' && string.charAt(i + 5) == ';') {
                stringBuffer.append('\"');
                i += 5;
                continue;
            }
            if (string.charAt(i + 1) == 'a' && string.charAt(i + 2) == 'p' && string.charAt(i + 3) == 'o' && string.charAt(i + 4) == 's' && string.charAt(i + 5) == ';') {
                stringBuffer.append('\'');
                i += 5;
                continue;
            }
            if (string.charAt(i + 1) == '#') {
                int n2 = string.indexOf(59, i + 1);
                if (n2 < 0) {
                    stringBuffer.append(string.charAt(i));
                    continue;
                }
                if (string.charAt(i + 2) == 'x' || string.charAt(i + 2) == 'X') {
                    i = n2;
                    continue;
                }
                String string2 = string.substring(i + 2, n2);
                if (string2.equals("9")) {
                    stringBuffer.append('\t');
                } else if (string2.equals("32")) {
                    stringBuffer.append(' ');
                } else if (string2.equals("13")) {
                    stringBuffer.append('\r');
                } else if (string2.equals("10")) {
                    stringBuffer.append('\n');
                }
                i = n2;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static String encode(char c, boolean bl) {
        if (bl && !XmlString.needToChange(c)) {
            return String.valueOf(c);
        }
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case ' ': {
                return "&#32;";
            }
            case '\t': {
                return "&#9;";
            }
            case '\r': {
                return "&#13;";
            }
            case '\n': {
                return "&#10;";
            }
        }
        return String.valueOf(c);
    }

    private static boolean needToChange(char c) {
        if (c > '>') {
            return false;
        }
        return c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'' || c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }
}

