/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;

public class HangulProperties
extends Properties {
    public HangulProperties() {
    }

    public HangulProperties(Properties properties) {
        super(properties);
    }

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
        if (this.hasInvalidHangulProperties()) {
            this.convert();
        }
    }

    private void convert() {
        Enumeration<Object> enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getProperty(string);
            this.remove(string);
            String string3 = this.latinToEucKr(string);
            String string4 = this.latinToEucKr(string2);
            this.setProperty(string3, string4);
        }
    }

    private boolean hasInvalidHangulProperties() {
        Enumeration<Object> enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getProperty(string);
            if (!this.hasInvalidHangul(string) && !this.hasInvalidHangul(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInvalidHangul(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                if (!this.isHangul(c)) continue;
                return false;
            }
            String string2 = this.latinToEucKr(string);
            if (!this.hasHangul(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasHangul(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!this.isHangul(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isHangul(char c) {
        return Character.UnicodeBlock.of(c) == Character.UnicodeBlock.HANGUL_SYLLABLES;
    }

    private String latinToEucKr(String string) {
        try {
            return new String(string.getBytes("ISO8859_1"), "EUC_KR");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }
}

