/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.util;

import com.tobesoft.platform.Platform;
import com.tobesoft.platform.util.NullOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Codepage {
    static Log log;
    private static Map codepage;
    private static Map charset;
    private static String defaultCharset;
    static /* synthetic */ Class class$com$tobesoft$platform$util$Codepage;

    private Codepage() {
    }

    public static String getDefaultCharset() {
        return defaultCharset;
    }

    public static int getDefaultCodepage() {
        return Codepage.charsetToCodepage(Codepage.getDefaultCharset());
    }

    public static int charsetToCodepage(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (string.equalsIgnoreCase("euc-kr") || string.equalsIgnoreCase("euc_kr") || string.equalsIgnoreCase("euckr") || string.equalsIgnoreCase("ms949") || string.equalsIgnoreCase("cp949")) {
            return 949;
        }
        if (string.equalsIgnoreCase("utf-8") || string.equalsIgnoreCase("utf_8") || string.equalsIgnoreCase("utf8")) {
            return 65001;
        }
        Integer n = (Integer)charset.get(string.toLowerCase());
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static String codepageToCharset(int n) {
        if (n == 949) {
            return "euc-kr";
        }
        if (n == 65001) {
            return "utf-8";
        }
        return (String)codepage.get(new Integer(n));
    }

    public static boolean isSupportedCharset(String string) {
        return Codepage.charsetToCodepage(string) > 0;
    }

    public static boolean isSupportedCodepage(int n) {
        return Codepage.codepageToCharset(n) != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        block5: {
            log = LogFactory.getLog((Class)(class$com$tobesoft$platform$util$Codepage == null ? (class$com$tobesoft$platform$util$Codepage = Codepage.class$("com.tobesoft.platform.util.Codepage")) : class$com$tobesoft$platform$util$Codepage));
            codepage = new HashMap();
            charset = new HashMap();
            charset.put("ansi_x3.4-1986", new Integer(1252));
            charset.put("arabic", new Integer(28596));
            charset.put("ascii", new Integer(1252));
            charset.put("asmo-708", new Integer(28596));
            charset.put("big5", new Integer(950));
            charset.put("chiness", new Integer(936));
            charset.put("cn-gb", new Integer(936));
            charset.put("cp1250", new Integer(1250));
            charset.put("cp1251", new Integer(1251));
            charset.put("cp1252", new Integer(1252));
            charset.put("cp1253", new Integer(1253));
            charset.put("cp1254", new Integer(1254));
            charset.put("cp1255", new Integer(1255));
            charset.put("cp1256", new Integer(1256));
            charset.put("cp1257", new Integer(1257));
            charset.put("cp1258", new Integer(1258));
            charset.put("cp367", new Integer(1252));
            charset.put("cp720", new Integer(720));
            charset.put("cp819", new Integer(1252));
            charset.put("cp850", new Integer(850));
            charset.put("cp852", new Integer(852));
            charset.put("cp862", new Integer(862));
            charset.put("cp866", new Integer(866));
            charset.put("cp874", new Integer(874));
            charset.put("cp932", new Integer(932));
            charset.put("cp949", new Integer(949));
            charset.put("ms1250", new Integer(1250));
            charset.put("ms1251", new Integer(1251));
            charset.put("ms1252", new Integer(1252));
            charset.put("ms1253", new Integer(1253));
            charset.put("ms1254", new Integer(1254));
            charset.put("ms1255", new Integer(1255));
            charset.put("ms1256", new Integer(1256));
            charset.put("ms1257", new Integer(1257));
            charset.put("ms1258", new Integer(1258));
            charset.put("ms367", new Integer(1252));
            charset.put("ms720", new Integer(720));
            charset.put("ms819", new Integer(1252));
            charset.put("ms850", new Integer(850));
            charset.put("ms852", new Integer(852));
            charset.put("ms862", new Integer(862));
            charset.put("ms866", new Integer(866));
            charset.put("ms874", new Integer(874));
            charset.put("ms932", new Integer(932));
            charset.put("ms949", new Integer(949));
            charset.put("cyrillic", new Integer(28595));
            charset.put("dos-720", new Integer(720));
            charset.put("dos-862", new Integer(862));
            charset.put("dos-874", new Integer(874));
            charset.put("ecma-114", new Integer(28596));
            charset.put("ecma-118", new Integer(28597));
            charset.put("elot_928", new Integer(28597));
            charset.put("euc-jp", new Integer(51932));
            charset.put("euc-kr", new Integer(949));
            charset.put("euc_jp", new Integer(932));
            charset.put("euc_kr", new Integer(949));
            charset.put("eucjp", new Integer(51932));
            charset.put("euckr", new Integer(949));
            charset.put("euctw", new Integer(874));
            charset.put("gb2312", new Integer(936));
            charset.put("gb_2312-80", new Integer(936));
            charset.put("gbk", new Integer(936));
            charset.put("greek", new Integer(28597));
            charset.put("greek8", new Integer(28597));
            charset.put("hebrew", new Integer(28598));
            charset.put("hz-gb-2312", new Integer(52936));
            charset.put("ibm367", new Integer(1252));
            charset.put("ibm819", new Integer(1252));
            charset.put("ibm850", new Integer(850));
            charset.put("ibm852", new Integer(852));
            charset.put("ibm866", new Integer(866));
            charset.put("iso-2022-cn", new Integer(936));
            charset.put("iso-2022-jp", new Integer(50220));
            charset.put("iso-5022-kr", new Integer(50225));
            charset.put("iso-8859-1", new Integer(1252));
            charset.put("iso-8859-11", new Integer(874));
            charset.put("iso-8859-2", new Integer(28592));
            charset.put("iso-8859-3", new Integer(28593));
            charset.put("iso-8859-4", new Integer(28594));
            charset.put("iso-8859-5", new Integer(28595));
            charset.put("iso-8859-6", new Integer(28596));
            charset.put("iso-8859-7", new Integer(28597));
            charset.put("iso-8859-8", new Integer(28598));
            charset.put("iso-8859-8-i", new Integer(38598));
            charset.put("iso-8859-9", new Integer(1254));
            charset.put("iso-ir-100", new Integer(1252));
            charset.put("iso-ir-101", new Integer(28592));
            charset.put("iso-ir-109", new Integer(28593));
            charset.put("iso-ir-110", new Integer(28594));
            charset.put("iso-ir-111", new Integer(28594));
            charset.put("iso-ir-126", new Integer(28597));
            charset.put("iso-ir-127", new Integer(28596));
            charset.put("iso-ir-138", new Integer(28598));
            charset.put("iso-ir-144", new Integer(28595));
            charset.put("iso-ir-148", new Integer(1254));
            charset.put("iso-ir-149", new Integer(949));
            charset.put("iso-ir-159", new Integer(932));
            charset.put("iso-ir-58", new Integer(936));
            charset.put("iso-ir-6", new Integer(1252));
            charset.put("iso_646.irv:1991", new Integer(1252));
            charset.put("iso_8859-1", new Integer(1252));
            charset.put("iso_8859-2", new Integer(28592));
            charset.put("iso_8859-3", new Integer(28593));
            charset.put("iso_8859-4", new Integer(28594));
            charset.put("iso_8859-5", new Integer(28595));
            charset.put("iso_8859-6", new Integer(28596));
            charset.put("iso_8859-7", new Integer(28597));
            charset.put("iso_8859-8", new Integer(28598));
            charset.put("iso_8859-9", new Integer(1254));
            charset.put("iso2022jp", new Integer(932));
            charset.put("iso2022kr", new Integer(949));
            charset.put("iso646-us", new Integer(1252));
            charset.put("iso8859-1", new Integer(1252));
            charset.put("iso8859-2", new Integer(28592));
            charset.put("iso8859-3", new Integer(28593));
            charset.put("iso8859-4", new Integer(28594));
            charset.put("iso8859-5", new Integer(28595));
            charset.put("iso8859-6", new Integer(28596));
            charset.put("iso8859-7", new Integer(28597));
            charset.put("iso8859-8", new Integer(28598));
            charset.put("iso8859-9", new Integer(1254));
            charset.put("iso8859_1", new Integer(1252));
            charset.put("iso8859_2", new Integer(28592));
            charset.put("iso8859_3", new Integer(28593));
            charset.put("iso8859_4", new Integer(28594));
            charset.put("iso8859_5", new Integer(28595));
            charset.put("iso8859_6", new Integer(28596));
            charset.put("iso8859_7", new Integer(28597));
            charset.put("iso8859_8", new Integer(28598));
            charset.put("iso8859_9", new Integer(1254));
            charset.put("koi", new Integer(20866));
            charset.put("koi8-r", new Integer(20866));
            charset.put("koi8-ru", new Integer(21866));
            charset.put("koi8-u", new Integer(21866));
            charset.put("koi8r", new Integer(20866));
            charset.put("koi8u", new Integer(21866));
            charset.put("korean", new Integer(949));
            charset.put("ks_c_5601", new Integer(949));
            charset.put("ks_c_5601-1987", new Integer(949));
            charset.put("ks_c_5601-1989", new Integer(949));
            charset.put("ksc5601", new Integer(949));
            charset.put("ksc_5601", new Integer(949));
            charset.put("l1", new Integer(1252));
            charset.put("l2", new Integer(28592));
            charset.put("l3", new Integer(28593));
            charset.put("l4", new Integer(28594));
            charset.put("l5", new Integer(1254));
            charset.put("latin1", new Integer(1252));
            charset.put("latin2", new Integer(28592));
            charset.put("latin3", new Integer(28593));
            charset.put("latin4", new Integer(28594));
            charset.put("latin5", new Integer(1254));
            charset.put("logical", new Integer(1255));
            charset.put("ms_kanji", new Integer(932));
            charset.put("shift-jis", new Integer(932));
            charset.put("shift_jis", new Integer(932));
            charset.put("sjis", new Integer(932));
            charset.put("tis-620", new Integer(874));
            charset.put("tis620", new Integer(874));
            charset.put("unicode", new Integer(1200));
            charset.put("us", new Integer(1252));
            charset.put("us-ascii", new Integer(1252));
            charset.put("utf-16", new Integer(1200));
            charset.put("utf-8", new Integer(65001));
            charset.put("utf_16", new Integer(1200));
            charset.put("utf_8", new Integer(65001));
            charset.put("utf16", new Integer(1200));
            charset.put("utf8", new Integer(65001));
            charset.put("visual", new Integer(28598));
            charset.put("windows-1250", new Integer(1250));
            charset.put("windows-1251", new Integer(1251));
            charset.put("windows-1252", new Integer(1252));
            charset.put("windows-1253", new Integer(1253));
            charset.put("windows-1254", new Integer(1254));
            charset.put("windows-1255", new Integer(1255));
            charset.put("windows-1256", new Integer(1256));
            charset.put("windows-1257", new Integer(1257));
            charset.put("windows-1258", new Integer(1258));
            charset.put("windows-31j", new Integer(932));
            charset.put("windows-874", new Integer(874));
            charset.put("x0201", new Integer(932));
            charset.put("x0208", new Integer(932));
            charset.put("x0212", new Integer(932));
            codepage.put(new Integer(65001), "utf-8");
            codepage.put(new Integer(52936), "hz-gb-2312");
            codepage.put(new Integer(51932), "euc-jp");
            codepage.put(new Integer(50225), "iso-5022-kr");
            codepage.put(new Integer(50220), "iso-2022-jp");
            codepage.put(new Integer(38598), "iso-8859-8-i");
            codepage.put(new Integer(28598), "hebrew");
            codepage.put(new Integer(28597), "greek");
            codepage.put(new Integer(28596), "arabic");
            codepage.put(new Integer(28595), "cyrillic");
            codepage.put(new Integer(28594), "iso-8859-4");
            codepage.put(new Integer(28593), "iso-8859-3");
            codepage.put(new Integer(28592), "iso-8859-2");
            codepage.put(new Integer(21866), "koi8-ru");
            codepage.put(new Integer(20866), "koi");
            codepage.put(new Integer(1258), "cp1258");
            codepage.put(new Integer(1257), "cp1257");
            codepage.put(new Integer(1256), "cp1256");
            codepage.put(new Integer(1255), "cp1255");
            codepage.put(new Integer(1254), "cp1254");
            codepage.put(new Integer(1253), "cp1253");
            codepage.put(new Integer(1252), "ascii");
            codepage.put(new Integer(1251), "cp1251");
            codepage.put(new Integer(1250), "cp1250");
            codepage.put(new Integer(1200), "utf-16");
            codepage.put(new Integer(950), "big5");
            codepage.put(new Integer(949), "euc-kr");
            codepage.put(new Integer(936), "gb2312");
            codepage.put(new Integer(932), "shift-jis");
            codepage.put(new Integer(874), "cp874");
            codepage.put(new Integer(866), "cp866");
            codepage.put(new Integer(862), "cp862");
            codepage.put(new Integer(852), "cp852");
            codepage.put(new Integer(850), "cp850");
            codepage.put(new Integer(720), "cp720");
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new NullOutputStream());
                String string = outputStreamWriter.getEncoding();
                int n = Codepage.charsetToCodepage(string);
                defaultCharset = Codepage.codepageToCharset(n);
                if (Platform.isDebug()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("charset=" + string + ", codepage=" + n));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("defaultCharset=" + defaultCharset));
                    }
                }
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)"\uae30\ubcf8 \ubb38\uc790\uc14b \uc124\uc815 \uc624\ub958", (Throwable)iOException);
            }
        }
    }
}

