/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.util;

import com.tobesoft.platform.Platform;
import com.tobesoft.platform.util.XmlString;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Base64Converter {
    static Log log;
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;
    static /* synthetic */ Class class$com$tobesoft$platform$util$Base64Converter;

    public static String encode(byte[] byArray) {
        return Base64Converter.encode(byArray, true);
    }

    public static String encode(byte[] byArray, boolean bl) {
        char[] cArray = Base64Converter.encodeChar(byArray, bl);
        return cArray == null ? null : new String(cArray);
    }

    public static char[] encodeChar(byte[] byArray) {
        return Base64Converter.encodeChar(byArray, true);
    }

    public static char[] encodeChar(byte[] byArray, boolean bl) {
        byte by;
        byte by2;
        byte by3;
        if (byArray == null) {
            return null;
        }
        int n = byArray.length * 8;
        if (n == 0) {
            return new char[0];
        }
        int n2 = n % 24;
        int n3 = n / 24;
        int n4 = n2 != 0 ? n3 + 1 : n3;
        int n5 = (n4 - 1) / 19 + 1;
        if (Platform.isDebug() && log.isDebugEnabled()) {
            log.debug((Object)("fewerThan24bits=" + n2 + ", numberTriplets=" + n3 + ", numberQuartet=" + n4 + ", numberLines=" + n5));
        }
        char[] cArray = null;
        cArray = bl ? new char[n4 * 4 + n5] : new char[n4 * 4];
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n5 - 1; ++i) {
            for (int j = 0; j < 19; ++j) {
                by6 = byArray[n7++];
                by7 = byArray[n7++];
                by8 = byArray[n7++];
                by5 = (byte)(by7 & 0xF);
                by4 = (byte)(by6 & 3);
                by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
                by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 4) : (byte)(by7 >> 4 ^ 0xF0);
                by = (by8 & 0xFFFFFF80) == 0 ? (byte)(by8 >> 6) : (byte)(by8 >> 6 ^ 0xFC);
                cArray[n6++] = lookUpBase64Alphabet[by3];
                cArray[n6++] = lookUpBase64Alphabet[by2 | by4 << 4];
                cArray[n6++] = lookUpBase64Alphabet[by5 << 2 | by];
                cArray[n6++] = lookUpBase64Alphabet[by8 & 0x3F];
                ++n8;
            }
            if (!bl) continue;
            cArray[n6++] = 10;
        }
        while (n8 < n3) {
            by6 = byArray[n7++];
            by7 = byArray[n7++];
            by8 = byArray[n7++];
            by5 = (byte)(by7 & 0xF);
            by4 = (byte)(by6 & 3);
            by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
            by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 4) : (byte)(by7 >> 4 ^ 0xF0);
            by = (by8 & 0xFFFFFF80) == 0 ? (byte)(by8 >> 6) : (byte)(by8 >> 6 ^ 0xFC);
            cArray[n6++] = lookUpBase64Alphabet[by3];
            cArray[n6++] = lookUpBase64Alphabet[by2 | by4 << 4];
            cArray[n6++] = lookUpBase64Alphabet[by5 << 2 | by];
            cArray[n6++] = lookUpBase64Alphabet[by8 & 0x3F];
            ++n8;
        }
        if (n2 == 8) {
            by6 = byArray[n7];
            by4 = (byte)(by6 & 3);
            by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
            cArray[n6++] = lookUpBase64Alphabet[by3];
            cArray[n6++] = lookUpBase64Alphabet[by4 << 4];
            cArray[n6++] = 61;
            cArray[n6++] = 61;
        } else if (n2 == 16) {
            by6 = byArray[n7];
            by7 = byArray[n7 + 1];
            by5 = (byte)(by7 & 0xF);
            by4 = (byte)(by6 & 3);
            by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
            by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 4) : (byte)(by7 >> 4 ^ 0xF0);
            cArray[n6++] = lookUpBase64Alphabet[by3];
            cArray[n6++] = lookUpBase64Alphabet[by2 | by4 << 4];
            cArray[n6++] = lookUpBase64Alphabet[by5 << 2];
            cArray[n6++] = 61;
        }
        if (bl) {
            cArray[n6] = 10;
        }
        return cArray;
    }

    public static void encodeAndWrite(byte[] byArray, PrintWriter printWriter) {
        Base64Converter.encodeAndWrite(byArray, printWriter, true);
    }

    public static void encodeAndWrite(byte[] byArray, PrintWriter printWriter, boolean bl) {
        byte by;
        byte by2;
        byte by3;
        if (Platform.isDebug() && log.isTraceEnabled()) {
            log.trace((Object)("bin=" + (byArray == null ? "null" : String.valueOf(byArray.length))));
        }
        if (byArray == null) {
            return;
        }
        int n = byArray.length * 8;
        if (Platform.isDebug() && log.isDebugEnabled()) {
            log.debug((Object)("lengthDataBits=" + n));
        }
        if (n == 0) {
            return;
        }
        int n2 = n % 24;
        int n3 = n / 24;
        int n4 = n2 != 0 ? n3 + 1 : n3;
        int n5 = (n4 - 1) / 19 + 1;
        if (Platform.isDebug() && log.isDebugEnabled()) {
            log.debug((Object)("fewerThan24bits=" + n2 + ", numberTriplets=" + n3 + ", numberQuartet=" + n4 + ", numberLines=" + n5));
        }
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n5 - 1; ++i) {
            for (int j = 0; j < 19; ++j) {
                by6 = byArray[n6++];
                by7 = byArray[n6++];
                by8 = byArray[n6++];
                by5 = (byte)(by7 & 0xF);
                by4 = (byte)(by6 & 3);
                by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
                by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 4) : (byte)(by7 >> 4 ^ 0xF0);
                by = (by8 & 0xFFFFFF80) == 0 ? (byte)(by8 >> 6) : (byte)(by8 >> 6 ^ 0xFC);
                printWriter.write(XmlString.encode(lookUpBase64Alphabet[by3]));
                printWriter.write(XmlString.encode(lookUpBase64Alphabet[by2 | by4 << 4]));
                printWriter.write(XmlString.encode(lookUpBase64Alphabet[by5 << 2 | by]));
                printWriter.write(XmlString.encode(lookUpBase64Alphabet[by8 & 0x3F]));
                ++n7;
            }
            if (!bl) continue;
            printWriter.write(XmlString.encode('\n'));
        }
        while (n7 < n3) {
            by6 = byArray[n6++];
            by7 = byArray[n6++];
            by8 = byArray[n6++];
            by5 = (byte)(by7 & 0xF);
            by4 = (byte)(by6 & 3);
            by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
            by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 4) : (byte)(by7 >> 4 ^ 0xF0);
            by = (by8 & 0xFFFFFF80) == 0 ? (byte)(by8 >> 6) : (byte)(by8 >> 6 ^ 0xFC);
            printWriter.write(XmlString.encode(lookUpBase64Alphabet[by3]));
            printWriter.write(XmlString.encode(lookUpBase64Alphabet[by2 | by4 << 4]));
            printWriter.write(XmlString.encode(lookUpBase64Alphabet[by5 << 2 | by]));
            printWriter.write(XmlString.encode(lookUpBase64Alphabet[by8 & 0x3F]));
            ++n7;
        }
        if (n2 == 8) {
            by6 = byArray[n6];
            by4 = (byte)(by6 & 3);
            by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
            printWriter.write(XmlString.encode(lookUpBase64Alphabet[by3]));
            printWriter.write(XmlString.encode(lookUpBase64Alphabet[by4 << 4]));
            printWriter.write(XmlString.encode('='));
            printWriter.write(XmlString.encode('='));
        } else if (n2 == 16) {
            by6 = byArray[n6];
            by7 = byArray[n6 + 1];
            by5 = (byte)(by7 & 0xF);
            by4 = (byte)(by6 & 3);
            by3 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 2) : (byte)(by6 >> 2 ^ 0xC0);
            by2 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 4) : (byte)(by7 >> 4 ^ 0xF0);
            printWriter.write(XmlString.encode(lookUpBase64Alphabet[by3]));
            printWriter.write(XmlString.encode(lookUpBase64Alphabet[by2 | by4 << 4]));
            printWriter.write(XmlString.encode(lookUpBase64Alphabet[by5 << 2]));
            printWriter.write(XmlString.encode('='));
        }
        if (bl) {
            printWriter.write(XmlString.encode('\n'));
        }
    }

    public static byte[] decode(String string) {
        int n;
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n2 = Base64Converter.removeWhiteSpace(cArray);
        if (n2 % 4 != 0) {
            return null;
        }
        int n3 = n2 / 4;
        if (n3 == 0) {
            return new byte[0];
        }
        byte[] byArray = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        int n4 = 0;
        int n5 = 0;
        byArray = new byte[n3 * 3];
        for (n = 0; n < n3 - 1; ++n) {
            if (!(Base64Converter.isData(c = cArray[n5++]) && Base64Converter.isData(c2 = cArray[n5++]) && Base64Converter.isData(c3 = cArray[n5++]) && Base64Converter.isData(c4 = cArray[n5++]))) {
                return null;
            }
            by = base64Alphabet[c];
            by2 = base64Alphabet[c2];
            by3 = base64Alphabet[c3];
            by4 = base64Alphabet[c4];
            byArray[n4++] = (byte)(by << 2 | by2 >> 4);
            byArray[n4++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray[n4++] = (byte)(by3 << 6 | by4);
        }
        if (!Base64Converter.isData(c = cArray[n5++]) || !Base64Converter.isData(c2 = cArray[n5++])) {
            return null;
        }
        by = base64Alphabet[c];
        by2 = base64Alphabet[c2];
        c3 = cArray[n5++];
        c4 = cArray[n5++];
        if (!Base64Converter.isData(c3) || !Base64Converter.isData(c4)) {
            if (Base64Converter.isPad(c3) && Base64Converter.isPad(c4)) {
                if ((by2 & 0xF) != 0) {
                    return null;
                }
                byte[] byArray2 = new byte[n * 3 + 1];
                System.arraycopy(byArray, 0, byArray2, 0, n * 3);
                byArray2[n4] = (byte)(by << 2 | by2 >> 4);
                return byArray2;
            }
            if (!Base64Converter.isPad(c3) && Base64Converter.isPad(c4)) {
                by3 = base64Alphabet[c3];
                if ((by3 & 3) != 0) {
                    return null;
                }
                byte[] byArray3 = new byte[n * 3 + 2];
                System.arraycopy(byArray, 0, byArray3, 0, n * 3);
                byArray3[n4++] = (byte)(by << 2 | by2 >> 4);
                byArray3[n4] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
                return byArray3;
            }
            return null;
        }
        by3 = base64Alphabet[c3];
        by4 = base64Alphabet[c4];
        byArray[n4++] = (byte)(by << 2 | by2 >> 4);
        byArray[n4++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
        byArray[n4++] = (byte)(by3 << 6 | by4);
        return byArray;
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\t';
    }

    private static boolean isPad(char c) {
        return c == '=';
    }

    private static boolean isData(char c) {
        return base64Alphabet[c] != -1;
    }

    private static int removeWhiteSpace(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            if (Base64Converter.isWhiteSpace(cArray[i])) continue;
            cArray[n++] = cArray[i];
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        log = LogFactory.getLog((Class)(class$com$tobesoft$platform$util$Base64Converter == null ? (class$com$tobesoft$platform$util$Base64Converter = Base64Converter.class$("com.tobesoft.platform.util.Base64Converter")) : class$com$tobesoft$platform$util$Base64Converter));
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new char[64];
        for (n = 0; n < 255; ++n) {
            Base64Converter.base64Alphabet[n] = -1;
        }
        for (n = 90; n >= 65; --n) {
            Base64Converter.base64Alphabet[n] = (byte)(n - 65);
        }
        for (n = 122; n >= 97; --n) {
            Base64Converter.base64Alphabet[n] = (byte)(n - 97 + 26);
        }
        for (n = 57; n >= 48; --n) {
            Base64Converter.base64Alphabet[n] = (byte)(n - 48 + 52);
        }
        Base64Converter.base64Alphabet[43] = 62;
        Base64Converter.base64Alphabet[47] = 63;
        for (n = 0; n <= 25; ++n) {
            Base64Converter.lookUpBase64Alphabet[n] = (char)(65 + n);
        }
        n = 26;
        int n2 = 0;
        while (n <= 51) {
            Base64Converter.lookUpBase64Alphabet[n] = (char)(97 + n2);
            ++n;
            ++n2;
        }
        n = 52;
        n2 = 0;
        while (n <= 61) {
            Base64Converter.lookUpBase64Alphabet[n] = (char)(48 + n2);
            ++n;
            ++n2;
        }
        Base64Converter.lookUpBase64Alphabet[62] = 43;
        Base64Converter.lookUpBase64Alphabet[63] = 47;
    }
}

