/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.data.Currency;
import com.tobesoft.platform.util.Base64Converter;
import com.tobesoft.platform.util.DateConverter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Variant
implements Serializable {
    public static final short VT_EMPTY = 0;
    public static final short VT_I4 = 3;
    public static final short VT_R8 = 5;
    public static final short VT_CURRENCY = 6;
    public static final short VT_DATE = 7;
    public static final short VT_STR = 8;
    public static final short VT_BINARY = 13;
    public static final short VT_OBJECT = 16384;
    static final int BUFFER_SIZE = 8192;
    private short type;
    private Object value;
    private SimpleDateFormat defaultDateFormat = null;
    private SimpleDateFormat defaultShortDateFormat = null;
    private DecimalFormat defaultDecimalFormat = null;

    public Variant() {
        this.type = 0;
    }

    public Variant(String string) {
        this.setString(string);
    }

    public Variant(int n) {
        this.setInteger(n);
    }

    public Variant(Integer n) {
        this.setInteger(n);
    }

    public Variant(double d) {
        this.setDouble(d);
    }

    public Variant(Double d) {
        this.setDouble(d);
    }

    public Variant(Currency currency) {
        this.setCurrency(currency);
    }

    public Variant(Date date) {
        this.setDate(date);
    }

    public Variant(byte[] byArray) {
        this.setBinary(byArray);
    }

    public Variant(Object object) {
        this.setObject(object);
    }

    public static int toType(String string) {
        if (string.equalsIgnoreCase("null")) {
            return 0;
        }
        if (string.equalsIgnoreCase("EMPTY")) {
            return 0;
        }
        if (string.equalsIgnoreCase("INTEGER")) {
            return 3;
        }
        if (string.equalsIgnoreCase("DECIMAL")) {
            return 5;
        }
        if (string.equalsIgnoreCase("STRING")) {
            return 8;
        }
        if (string.equalsIgnoreCase("BINARY")) {
            return 13;
        }
        if (string.equalsIgnoreCase("DATE")) {
            return 7;
        }
        if (string.equalsIgnoreCase("CURRENCY")) {
            return 6;
        }
        if (string.equalsIgnoreCase("OBJECT")) {
            return 16384;
        }
        return 0;
    }

    public static int getTypeNo(String string) {
        return Variant.toType(string);
    }

    public int getType() {
        return this.type;
    }

    public void setType(short s) {
        this.type = s;
    }

    public String getTypeName() {
        if (this.type == 0) {
            return "EMPTY";
        }
        if (this.type == 3) {
            return "INTEGER";
        }
        if (this.type == 5) {
            return "DECIMAL";
        }
        if (this.type == 8) {
            return "STRING";
        }
        if (this.type == 13) {
            return "BINARY";
        }
        if (this.type == 7) {
            return "DATE";
        }
        if (this.type == 6) {
            return "CURRENCY";
        }
        if (this.type == 16384) {
            return "OBJECT";
        }
        return "UNKNOWN";
    }

    public String getString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return null;
    }

    public Integer getInteger() {
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return null;
    }

    public Double getDouble() {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        return null;
    }

    public Currency getCurrency() {
        if (this.value instanceof Currency) {
            return (Currency)this.value;
        }
        return null;
    }

    public Date getDate() {
        if (this.value instanceof Date) {
            return (Date)this.value;
        }
        return null;
    }

    public byte[] getBinary() {
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        return null;
    }

    public Object getObject() {
        return this.value;
    }

    public void setEmpty() {
        this.type = 0;
        this.value = null;
    }

    public void setString(String string) {
        if (string == null) {
            this.setEmpty();
            return;
        }
        this.type = (short)8;
        this.value = string;
    }

    public void setInteger(int n) {
        this.setInteger(new Integer(n));
    }

    public void setInteger(Integer n) {
        if (n == null) {
            this.setEmpty();
            return;
        }
        this.type = (short)3;
        this.value = n;
    }

    public void setDouble(double d) {
        this.setDouble(new Double(d));
    }

    public void setDouble(Double d) {
        if (d == null) {
            this.setEmpty();
            return;
        }
        this.type = (short)5;
        this.value = d;
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            this.setEmpty();
            return;
        }
        this.type = (short)6;
        this.value = currency;
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setEmpty();
            return;
        }
        this.type = (short)7;
        this.value = date;
    }

    public void setDate(long l) {
        this.setDate(new Date(l));
    }

    public void setBinary(byte[] byArray) {
        if (byArray == null) {
            this.setEmpty();
            return;
        }
        this.type = (short)13;
        this.value = byArray;
    }

    public void setObject(Object object) {
        if (object == null) {
            this.setEmpty();
            return;
        }
        if (object instanceof String) {
            this.setString((String)object);
        } else if (object instanceof Integer) {
            this.setInteger((Integer)object);
        } else if (object instanceof Double) {
            this.setDouble((Double)object);
        } else if (object instanceof Currency) {
            this.setCurrency((Currency)object);
        } else if (object instanceof Date) {
            this.setDate((Date)object);
        } else if (object instanceof byte[]) {
            this.setBinary((byte[])object);
        } else if (object instanceof Variant) {
            this.copy((Variant)object);
        } else {
            this.type = (short)16384;
            this.value = object;
        }
    }

    public boolean isEmpty() {
        return this.type == 0;
    }

    public boolean isString() {
        return this.type == 8;
    }

    public boolean isInteger() {
        return this.type == 3;
    }

    public boolean isDouble() {
        return this.type == 5;
    }

    public boolean isCurrency() {
        return this.type == 6;
    }

    public boolean isDate() {
        return this.type == 7;
    }

    public boolean isBinary() {
        return this.type == 13;
    }

    public boolean isObject() {
        return this.type == 16384;
    }

    public void copy(Variant variant) {
        this.type = variant.type;
        this.value = variant.value;
    }

    public String asString() {
        Format[] formatArray = new Format[]{new DecimalFormat("0.#####"), new SimpleDateFormat("yyyyMMddHHmmss")};
        return this.asString(formatArray);
    }

    public String asString(Format[] formatArray) {
        switch (this.type) {
            case 0: {
                return "";
            }
            case 8: {
                if (this.value instanceof String) {
                    return (String)this.value;
                }
                return this.value.toString();
            }
            case 3: 
            case 6: 
            case 16384: {
                if (this.value instanceof String) {
                    return (String)this.value;
                }
                return this.value.toString();
            }
            case 5: {
                if (this.value instanceof Double) {
                    return formatArray[0].format((Double)this.value);
                }
                return this.value.toString();
            }
            case 7: {
                if (this.value instanceof Date) {
                    return formatArray[1].format((Date)this.value);
                }
                if (this.value instanceof String) {
                    return (String)this.value;
                }
                return this.value.toString();
            }
            case 13: {
                if (this.value instanceof byte[]) {
                    return Base64Converter.encode((byte[])this.value);
                }
                if (this.value instanceof String) {
                    return (String)this.value;
                }
                return this.value.toString();
            }
        }
        return String.valueOf(this.value);
    }

    public String toString() {
        return this.toString(true);
    }

    String toString(boolean bl) {
        return this.asString();
    }

    public void dump() {
        System.out.print("Type=[" + this.getTypeName() + "], ");
        if (this.type != 0) {
            System.out.println("Value=[" + this.asString() + "]");
        } else {
            System.out.println("Value=[null]");
        }
    }

    public boolean equals(Object object) {
        Variant variant = (Variant)object;
        if (this.type != variant.getType()) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return true;
            }
            case 3: {
                return this.getInteger() == variant.getInteger();
            }
            case 5: {
                return this.getDouble() == variant.getDouble();
            }
            case 8: {
                return this.getString().compareTo(variant.getString()) == 0;
            }
            case 13: {
                if (this.getBinary().length != variant.getBinary().length) {
                    return false;
                }
                return this.getBinary().equals(variant.getBinary());
            }
            case 7: {
                return this.getDate().getTime() == variant.getDate().getTime();
            }
            case 6: {
                return this.getCurrency().equals(variant.getCurrency());
            }
            case 16384: {
                return this.getObject().equals(object);
            }
        }
        return false;
    }

    public void convertToType(short s) {
        if (this.isEmpty()) {
            return;
        }
        if (this.type == s) {
            return;
        }
        block4 : switch (this.type) {
            case 0: {
                break;
            }
            case 3: {
                switch (s) {
                    case 0: {
                        this.setEmpty();
                        break block4;
                    }
                    case 3: {
                        break block4;
                    }
                    case 5: {
                        this.setDouble(((Integer)this.value).doubleValue());
                        break block4;
                    }
                    case 8: {
                        this.setString(((Integer)this.value).toString());
                        break block4;
                    }
                    case 13: {
                        int n = (Integer)this.value;
                        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
                        this.setBinary(byArray);
                        break block4;
                    }
                    case 7: {
                        this.setDate(((Integer)this.value).longValue());
                        break block4;
                    }
                    case 6: {
                        this.setCurrency(new Currency(((Integer)this.value).doubleValue()));
                        break block4;
                    }
                    case 16384: {
                        this.type = (short)16384;
                        break block4;
                    }
                }
                break;
            }
            case 5: {
                switch (s) {
                    case 0: {
                        this.setEmpty();
                        break block4;
                    }
                    case 3: {
                        this.setInteger(((Double)this.value).intValue());
                        break block4;
                    }
                    case 5: {
                        break block4;
                    }
                    case 8: {
                        this.setString(((Double)this.value).toString());
                        break block4;
                    }
                    case 13: {
                        long l = ((Double)this.value).longValue();
                        byte[] byArray = new byte[]{(byte)(l >>> 56 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l & 0xFFL)};
                        this.setBinary(byArray);
                        break block4;
                    }
                    case 7: {
                        this.setDate(((Double)this.value).longValue());
                        break block4;
                    }
                    case 6: {
                        this.setCurrency(new Currency((Double)this.value));
                        break block4;
                    }
                    case 16384: {
                        this.type = (short)16384;
                        break block4;
                    }
                }
                break;
            }
            case 8: {
                switch (s) {
                    case 0: {
                        this.setEmpty();
                        break block4;
                    }
                    case 3: {
                        try {
                            this.setInteger(Integer.parseInt((String)this.value));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.setEmpty();
                        }
                        break block4;
                    }
                    case 5: {
                        try {
                            this.setDouble(Double.parseDouble((String)this.value));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.setEmpty();
                        }
                        break block4;
                    }
                    case 8: {
                        break block4;
                    }
                    case 13: {
                        this.setBinary(((String)this.value).getBytes());
                        break block4;
                    }
                    case 7: {
                        try {
                            if (((String)this.value).length() == 8) {
                                if (this.defaultShortDateFormat == null) {
                                    this.defaultShortDateFormat = new SimpleDateFormat("yyyyMMdd");
                                }
                                this.setDate(this.defaultShortDateFormat.parse((String)this.value));
                                break block4;
                            }
                            if (this.defaultDateFormat == null) {
                                this.defaultDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                            }
                            this.setDate(this.defaultDateFormat.parse((String)this.value));
                        }
                        catch (ParseException parseException) {
                            this.setEmpty();
                        }
                        break block4;
                    }
                    case 6: {
                        try {
                            this.setCurrency(new Currency(Double.parseDouble((String)this.value)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.setEmpty();
                        }
                        break block4;
                    }
                    case 16384: {
                        this.type = (short)16384;
                        break block4;
                    }
                }
                break;
            }
            case 13: {
                this.setString(new String((byte[])this.value));
                this.convertToType(s);
                break;
            }
            case 7: {
                this.setString(this.asString());
                this.convertToType(s);
                break;
            }
            case 6: {
                this.setString(this.asString());
                this.convertToType(s);
                break;
            }
            case 16384: {
                this.setString(this.asString());
                this.convertToType(s);
                break;
            }
            default: {
                this.setString(this.asString());
                this.convertToType(s);
            }
        }
    }

    public void readFrom(InputStream inputStream, String string) throws IOException {
        this.readFrom(new DataInputStream(inputStream), string);
    }

    public void readFrom(DataInputStream dataInputStream, String string) throws IOException {
        this.readFrom(dataInputStream, string, (short)3100);
    }

    void readFrom(DataInputStream dataInputStream, String string, File file) throws IOException {
        this.readFrom(dataInputStream, string, (short)3100);
    }

    void readFrom(DataInputStream dataInputStream, String string, short s) throws IOException {
        this.setType(dataInputStream.readShort());
        if (this.getType() == 3) {
            this.setInteger(dataInputStream.readInt());
        } else if (this.getType() == 5) {
            this.setDouble(dataInputStream.readDouble());
        } else if (this.getType() == 7) {
            this.setDate(DateConverter.toDate(dataInputStream.readDouble()));
        } else if (this.getType() == 6) {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            this.setCurrency(Currency.fromInt64(n, n2));
        } else if (this.getType() == 8) {
            int n;
            int n3;
            int n4 = 0;
            if (s >= 4000) {
                byte by = dataInputStream.readByte();
                if ((by & 0x80) != 0) {
                    n4 = by << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                    n4 &= Integer.MAX_VALUE;
                } else {
                    n4 = by << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                }
            } else {
                n4 = dataInputStream.readUnsignedShort();
            }
            byte[] byArray = new byte[n4];
            for (n = 0; n < n4 && (n3 = dataInputStream.read(byArray, n, byArray.length - n)) > 0; n += n3) {
            }
            if (n != n4) {
                throw new IOException("Variant\uc758 \ubb38\uc790\uc5f4 \uac12 \uc77d\uae30 \uc624\ub958, length=" + n4 + ", count=" + n);
            }
            if (s >= 4000) {
                this.setString(new String(byArray, "utf-8"));
            } else if (string == null) {
                this.setString(new String(byArray));
            } else {
                this.setString(new String(byArray, string));
            }
        } else if (this.getType() == 13) {
            long l;
            long l2 = 0L;
            if (s >= 4000) {
                byte by = dataInputStream.readByte();
                if ((by & 0x80) != 0) {
                    l2 = by << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                    l2 &= Integer.MAX_VALUE;
                } else {
                    l2 = by << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                }
            } else {
                l2 = 0xFFFFFFFF & dataInputStream.readInt();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
            byte[] byArray = new byte[8192];
            int n = 0;
            for (l = 0L; l < l2 && (n = 8192L > l2 - l ? dataInputStream.read(byArray, 0, (int)(l2 - l)) : dataInputStream.read(byArray, 0, 8192)) > 0; l += (long)n) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            if (l != l2) {
                throw new IOException("Variant\uc758 byte \ubc30\uc5f4 \uac12 \uc77d\uae30 \uc624\ub958, length=" + l2 + ", count=" + l);
            }
            this.setBinary(byteArrayOutputStream.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void readFrom(DataInputStream dataInputStream, String string, short s, File file) throws IOException {
        short s2 = dataInputStream.readShort();
        if (s2 == 3) {
            this.setType((short)0);
            return;
        }
        if (s2 == 5) {
            this.setType((short)0);
            return;
        }
        if (s2 == 7) {
            this.setType((short)0);
            return;
        }
        if (s2 == 6) {
            this.setType((short)0);
            return;
        }
        if (s2 == 8) {
            this.setType((short)0);
            return;
        }
        if (s2 == 13) {
            long l = 0L;
            if (s >= 4000) {
                byte by = dataInputStream.readByte();
                if ((by & 0x80) != 0) {
                    l = by << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                    l &= Integer.MAX_VALUE;
                } else {
                    l = by << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                }
            } else {
                l = 0xFFFFFFFF & dataInputStream.readInt();
            }
            FileOutputStream fileOutputStream = null;
            try {
                long l2;
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[8192];
                int n = 0;
                for (l2 = 0L; l2 < l && (n = 8192L > l - l2 ? dataInputStream.read(byArray, 0, (int)(l - l2)) : dataInputStream.read(byArray, 0, 8192)) > 0; l2 += (long)n) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)fileOutputStream).close();
                if (l2 != l) {
                    throw new IOException("Variant\uc758 byte \ubc30\uc5f4 \uac12 \uc77d\uae30 \uc624\ub958, length=" + l + ", count=" + l2);
                }
                this.setType((short)8);
                this.setString(file.getAbsolutePath());
                Object var14_12 = null;
                if (fileOutputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                if (fileOutputStream == null) throw throwable;
                try {
                    ((OutputStream)fileOutputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((OutputStream)fileOutputStream).close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        this.setType((short)0);
    }

    public void readFrom2(InputStream inputStream) throws IOException {
        this.readFrom2(new DataInputStream(inputStream));
    }

    public void readFrom2(DataInputStream dataInputStream) throws IOException {
        this.setType(dataInputStream.readShort());
        switch (this.getType()) {
            case 3: {
                this.setInteger(dataInputStream.readInt());
                break;
            }
            case 5: {
                this.setDouble(dataInputStream.readDouble());
                break;
            }
            case 7: {
                this.setDate(DateConverter.toDate(dataInputStream.readDouble()));
                break;
            }
            case 6: {
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                this.setCurrency(Currency.fromInt64(n, n2));
                break;
            }
            case 8: {
                int n;
                int n3;
                int n4 = 0;
                byte by = dataInputStream.readByte();
                if ((by & 0x80) != 0) {
                    n4 = by << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                    n4 &= Integer.MAX_VALUE;
                } else {
                    n4 = by << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                }
                byte[] byArray = new byte[n4];
                for (n = 0; n < n4 && (n3 = dataInputStream.read(byArray, n, byArray.length - n)) > 0; n += n3) {
                }
                if (n != n4) {
                    throw new IOException("Variant\uc758 \ubb38\uc790\uc5f4 \uac12 \uc77d\uae30 \uc624\ub958, length=" + n4 + ", count=" + n);
                }
                this.setString(new String(byArray, "utf-8"));
                break;
            }
            case 13: {
                long l;
                long l2 = 0L;
                byte by = dataInputStream.readByte();
                if ((by & 0x80) != 0) {
                    l2 = by << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                    l2 &= Integer.MAX_VALUE;
                } else {
                    l2 = by << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
                byte[] byArray = new byte[8192];
                int n = 0;
                for (l = 0L; l < l2 && (n = 8192L > l2 - l ? dataInputStream.read(byArray, 0, (int)(l2 - l)) : dataInputStream.read(byArray, 0, 8192)) > 0; l += (long)n) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                if (l != l2) {
                    throw new IOException("Variant\uc758 byte \ubc30\uc5f4 \uac12 \uc77d\uae30 \uc624\ub958, length=" + l2 + ", count=" + l);
                }
                this.setBinary(byteArrayOutputStream.toByteArray());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readFrom2(DataInputStream dataInputStream, File file) throws IOException {
        short s = dataInputStream.readShort();
        switch (s) {
            case 3: {
                this.setType((short)0);
                break;
            }
            case 5: {
                this.setType((short)0);
                break;
            }
            case 7: {
                this.setType((short)0);
                break;
            }
            case 6: {
                this.setType((short)0);
                break;
            }
            case 8: {
                this.setType((short)0);
                break;
            }
            case 13: {
                long l = 0L;
                byte by = dataInputStream.readByte();
                if ((by & 0x80) != 0) {
                    l = by << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                    l &= Integer.MAX_VALUE;
                } else {
                    l = by << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                }
                FileOutputStream fileOutputStream = null;
                try {
                    long l2;
                    fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    for (l2 = 0L; l2 < l && (n = 8192L > l - l2 ? dataInputStream.read(byArray, 0, (int)(l - l2)) : dataInputStream.read(byArray, 0, 8192)) > 0; l2 += (long)n) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                    if (l2 != l) {
                        throw new IOException("Variant\uc758 byte \ubc30\uc5f4 \uac12 \uc77d\uae30 \uc624\ub958, length=" + l + ", count=" + l2);
                    }
                    this.setType((short)8);
                    this.setString(file.getAbsolutePath());
                    Object var13_10 = null;
                    if (fileOutputStream == null) break;
                }
                catch (Throwable throwable) {
                    Object var13_11 = null;
                    if (fileOutputStream != null) {
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
                break;
            }
            default: {
                this.setType((short)0);
            }
        }
    }

    public void writeTo(OutputStream outputStream, String string) throws IOException {
        this.writeTo(new DataOutputStream(outputStream), string);
    }

    public void writeTo(DataOutputStream dataOutputStream, String string) throws IOException {
        this.writeTo(dataOutputStream, string, (short)3100);
    }

    void writeFileTo(DataOutputStream dataOutputStream, String string) throws IOException {
        this.writeFileTo(dataOutputStream, string, (short)3100);
    }

    void writeTo(DataOutputStream dataOutputStream, String string, short s) throws IOException {
        dataOutputStream.writeShort(this.getType());
        if (this.getType() == 3) {
            dataOutputStream.writeInt(this.getInteger());
        } else if (this.getType() == 5) {
            dataOutputStream.writeDouble(this.getDouble());
        } else if (this.getType() == 8) {
            byte[] byArray = null;
            if (s >= 4000) {
                byArray = this.getString().getBytes("utf-8");
                if (byArray.length < 32768) {
                    dataOutputStream.writeShort(byArray.length);
                } else {
                    dataOutputStream.writeInt(byArray.length | Integer.MIN_VALUE);
                }
            } else {
                byArray = string == null ? this.getString().getBytes() : this.getString().getBytes(string);
                dataOutputStream.writeShort(byArray.length);
            }
            dataOutputStream.write(byArray);
        } else if (this.getType() == 13) {
            if (s >= 4000) {
                int n = this.getBinary().length;
                if (n < 32768) {
                    dataOutputStream.writeShort(n);
                } else {
                    dataOutputStream.writeInt(n | Integer.MIN_VALUE);
                }
            } else {
                dataOutputStream.writeInt(this.getBinary().length);
            }
            dataOutputStream.write(this.getBinary());
        } else if (this.getType() == 7) {
            dataOutputStream.writeDouble(DateConverter.toDouble(this.getDate()));
        } else if (this.getType() == 6) {
            int[] nArray = Currency.toInt64(this.getCurrency());
            dataOutputStream.writeInt(nArray[0]);
            dataOutputStream.writeInt(nArray[1]);
        }
    }

    int getWriteLength(String string, short s) throws IOException {
        int n = 0;
        n += 2;
        if (this.getType() == 3) {
            n += 4;
        } else if (this.getType() == 5) {
            n += 8;
        } else if (this.getType() == 8) {
            byte[] byArray = null;
            if (s >= 4000) {
                byArray = this.getString().getBytes("utf-8");
                n = byArray.length < 32768 ? (n += 2) : (n += 4);
            } else {
                byArray = string == null ? this.getString().getBytes() : this.getString().getBytes(string);
                n += 2;
            }
            n += byArray.length;
        } else if (this.getType() == 13) {
            n = s >= 4000 ? (this.getBinary().length < 32768 ? (n += 2) : (n += 4)) : (n += 4);
            n += this.getBinary().length;
        } else if (this.getType() == 7) {
            n += 8;
        } else if (this.getType() == 6) {
            n += 8;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeFileTo(DataOutputStream dataOutputStream, String string, short s) throws IOException {
        if (this.getType() == 3) {
            dataOutputStream.writeShort(0);
            return;
        }
        if (this.getType() == 5) {
            dataOutputStream.writeShort(0);
            return;
        }
        if (this.getType() == 8) {
            File file = new File(this.getString());
            if (file.exists()) {
                dataOutputStream.writeShort(13);
                int n = (int)file.length();
                if (s >= 4000) {
                    if (n < 32768) {
                        dataOutputStream.writeShort(n);
                    } else {
                        dataOutputStream.writeInt(n | Integer.MIN_VALUE);
                    }
                } else {
                    dataOutputStream.writeInt(n);
                }
                FileInputStream fileInputStream = null;
                try {
                    int n2;
                    fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[8192];
                    int n3 = 0;
                    while ((n2 = n - n3) > 0) {
                        int n4;
                        if (n2 > 8192) {
                            n2 = 8192;
                        }
                        if ((n4 = ((InputStream)fileInputStream).read(byArray, 0, n2)) <= 0) break;
                        dataOutputStream.write(byArray, 0, n4);
                        n3 += n4;
                    }
                    if (n3 != n) {
                        throw new IOException("\ud30c\uc77c \uc77d\uae30 \uc624\ub958");
                    }
                    Object var12_11 = null;
                    if (fileInputStream == null) return;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        ((InputStream)fileInputStream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)fileInputStream).close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            dataOutputStream.writeShort(0);
            return;
        }
        if (this.getType() == 13) {
            dataOutputStream.writeShort(0);
            return;
        } else if (this.getType() == 7) {
            dataOutputStream.writeShort(0);
            return;
        } else if (this.getType() == 6) {
            dataOutputStream.writeShort(0);
            return;
        } else {
            dataOutputStream.writeShort(0);
        }
    }

    int getWriteFileLength(String string, short s) {
        if (this.getType() == 3) {
            return 2;
        }
        if (this.getType() == 5) {
            return 2;
        }
        if (this.getType() == 8) {
            File file = new File(this.getString());
            if (file.exists()) {
                int n = 0;
                n += 2;
                int n2 = (int)file.length();
                n = s >= 4000 ? (n2 < 32768 ? (n += 2) : (n += 4)) : (n += 4);
                return n += n2;
            }
            return 2;
        }
        if (this.getType() == 13) {
            return 2;
        }
        if (this.getType() == 7) {
            return 2;
        }
        if (this.getType() == 6) {
            return 2;
        }
        return 2;
    }

    public void writeTo2(OutputStream outputStream) throws IOException {
        this.writeTo2(new DataOutputStream(outputStream));
    }

    public void writeTo2(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.getType());
        switch (this.getType()) {
            case 3: {
                dataOutputStream.writeInt(this.getInteger());
                break;
            }
            case 5: {
                dataOutputStream.writeDouble(this.getDouble());
                break;
            }
            case 8: {
                byte[] byArray = this.getString().getBytes("utf-8");
                int n = byArray.length;
                if (n < 32768) {
                    dataOutputStream.writeShort(n);
                } else {
                    dataOutputStream.writeInt(n | Integer.MIN_VALUE);
                }
                if (n <= 0) break;
                dataOutputStream.write(byArray);
                break;
            }
            case 13: {
                byte[] byArray = this.getBinary();
                int n = 0;
                if (byArray != null) {
                    n = byArray.length;
                }
                if (n < 32768) {
                    dataOutputStream.writeShort(n);
                } else {
                    dataOutputStream.writeInt(n | Integer.MIN_VALUE);
                }
                if (n <= 0) break;
                dataOutputStream.write(byArray);
                break;
            }
            case 7: {
                dataOutputStream.writeDouble(DateConverter.toDouble(this.getDate()));
                break;
            }
            case 6: {
                int[] nArray = Currency.toInt64(this.getCurrency());
                dataOutputStream.writeInt(nArray[0]);
                dataOutputStream.writeInt(nArray[1]);
                break;
            }
        }
    }

    int getWrite2Length() throws IOException {
        int n = 0;
        n += 2;
        switch (this.getType()) {
            case 3: {
                n += 4;
                break;
            }
            case 5: {
                n += 8;
                break;
            }
            case 8: {
                byte[] byArray = this.getString().getBytes("utf-8");
                int n2 = byArray.length;
                n = n2 < 32768 ? (n += 2) : (n += 4);
                n += n2;
                break;
            }
            case 13: {
                byte[] byArray = this.getBinary();
                int n3 = 0;
                if (byArray != null) {
                    n3 = byArray.length;
                }
                n = n3 < 32768 ? (n += 2) : (n += 4);
                if (n3 <= 0) break;
                n += n3;
                break;
            }
            case 7: {
                n += 8;
                break;
            }
            case 6: {
                n += 8;
                break;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFileTo2(DataOutputStream dataOutputStream) throws IOException {
        switch (this.getType()) {
            case 3: {
                dataOutputStream.writeShort(0);
                break;
            }
            case 5: {
                dataOutputStream.writeShort(0);
                break;
            }
            case 8: {
                File file = new File(this.getString());
                if (file.exists()) {
                    dataOutputStream.writeShort(13);
                    int n = (int)file.length();
                    if (n < 32768) {
                        dataOutputStream.writeShort(n);
                    } else {
                        dataOutputStream.writeInt(n | Integer.MIN_VALUE);
                    }
                    FileInputStream fileInputStream = null;
                    try {
                        int n2;
                        fileInputStream = new FileInputStream(file);
                        byte[] byArray = new byte[8192];
                        int n3 = 0;
                        while ((n2 = n - n3) > 0) {
                            int n4;
                            if (n2 > 8192) {
                                n2 = 8192;
                            }
                            if ((n4 = ((InputStream)fileInputStream).read(byArray, 0, n2)) <= 0) break;
                            dataOutputStream.write(byArray, 0, n4);
                            n3 += n4;
                        }
                        if (n3 != n) {
                            throw new IOException("\ud30c\uc77c \uc77d\uae30 \uc624\ub958");
                        }
                        Object var10_9 = null;
                        if (fileInputStream == null) break;
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        if (fileInputStream != null) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                dataOutputStream.writeShort(0);
                break;
            }
            case 13: {
                dataOutputStream.writeShort(0);
                break;
            }
            case 7: {
                dataOutputStream.writeShort(0);
                break;
            }
            case 6: {
                dataOutputStream.writeShort(0);
                break;
            }
            default: {
                dataOutputStream.writeShort(0);
            }
        }
    }

    int getWriteFile2Length() throws IOException {
        int n = 0;
        switch (this.getType()) {
            case 3: {
                n += 2;
                break;
            }
            case 5: {
                n += 2;
                break;
            }
            case 8: {
                File file = new File(this.getString());
                if (file.exists()) {
                    n += 2;
                    int n2 = (int)file.length();
                    n = n2 < 32768 ? (n += 2) : (n += 4);
                    n += n2;
                    break;
                }
                n += 2;
                break;
            }
            case 13: {
                n += 2;
                break;
            }
            case 7: {
                n += 2;
                break;
            }
            case 6: {
                n += 2;
                break;
            }
            default: {
                n += 2;
            }
        }
        return n;
    }
}

