/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.data.Currency;
import com.tobesoft.platform.data.Variable;
import com.tobesoft.platform.data.Variant;
import com.tobesoft.platform.util.Base64Converter;
import com.tobesoft.platform.util.Codepage;
import com.tobesoft.platform.util.XmlString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class VariableList
implements Serializable {
    static final short MARK_310_VARIABLE_LIST = -240;
    static final short MARK_400_VARIABLE_LIST = -496;
    static final short VERSION_VARIABLE_LIST = 2000;
    private Map variableMap = new HashMap();
    private short version = 0;
    private String charset;
    private SimpleDateFormat defaultDateFormat = null;

    public Variable get(String string) {
        Variable variable = new Variable();
        variable.setId(string);
        variable.setValue((Variant)this.variableMap.get(string));
        return variable;
    }

    public Variable getVariable(String string) {
        return this.get(string);
    }

    public Variable get(int n) {
        if (n >= this.size()) {
            return null;
        }
        Set set = this.variableMap.keySet();
        if (set == null) {
            return null;
        }
        Iterator iterator = set.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (n2 == n) {
                String string = (String)k;
                Variant variant = (Variant)this.variableMap.get(string);
                return new Variable(string, variant);
            }
            ++n2;
        }
        return null;
    }

    public Variable getVariable(int n) {
        return this.get(n);
    }

    public void add(Variable variable) {
        if (variable == null) {
            return;
        }
        this.variableMap.put(variable.getId(), variable.getValue());
    }

    public void addVariable(Variable variable) {
        this.add(variable);
    }

    public void add(String string, Variant variant) {
        if (string == null || variant == null) {
            return;
        }
        this.variableMap.put(string, variant);
    }

    public void add(String string, String string2) {
        this.add(string, new Variant(string2));
    }

    public void add(String string, int n) {
        this.add(string, new Variant(n));
    }

    public void add(String string, Integer n) {
        this.add(string, new Variant(n));
    }

    public void add(String string, double d) {
        this.add(string, new Variant(d));
    }

    public void add(String string, Double d) {
        this.add(string, new Variant(d));
    }

    public void add(String string, Currency currency) {
        this.add(string, new Variant(currency));
    }

    public void add(String string, Date date) {
        this.add(string, new Variant(date));
    }

    public void add(String string, byte[] byArray) {
        this.add(string, new Variant(byArray));
    }

    public void add(String string, Object object) {
        this.add(string, new Variant(object));
    }

    public void addVariable(String string, Variant variant) {
        this.add(string, variant);
    }

    public void addVariable(String string, String string2) {
        this.add(string, string2);
    }

    public void addVariable(String string, int n) {
        this.add(string, n);
    }

    public void addVariable(String string, Integer n) {
        this.add(string, n);
    }

    public void addVariable(String string, double d) {
        this.add(string, d);
    }

    public void addVariable(String string, Double d) {
        this.add(string, d);
    }

    public void addVariable(String string, Currency currency) {
        this.add(string, currency);
    }

    public void addVariable(String string, Date date) {
        this.add(string, date);
    }

    public void addVariable(String string, byte[] byArray) {
        this.add(string, byArray);
    }

    public void addVariable(String string, Object object) {
        this.add(string, object);
    }

    public void addStr(String string, String string2) {
        this.add(string, string2);
    }

    public Variant getValue(String string) {
        return (Variant)this.variableMap.get(string);
    }

    public Variant getValue(int n) {
        if (n >= this.size()) {
            return null;
        }
        Collection collection = this.variableMap.values();
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (n2 == n) {
                return (Variant)v;
            }
            ++n2;
        }
        return null;
    }

    public String getValueAsString(String string) {
        Variant variant = this.getValue(string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() == 8) {
            return String.copyValueOf(variant.getString().toCharArray());
        }
        Variant variant2 = new Variant();
        variant2.copy(variant);
        variant2.convertToType((short)8);
        return variant2.getString();
    }

    public Integer getValueAsInteger(String string) {
        Variant variant = this.getValue(string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() == 3) {
            return new Integer(variant.getInteger());
        }
        Variant variant2 = new Variant();
        variant2.copy(variant);
        variant2.convertToType((short)3);
        return variant2.getInteger();
    }

    public Double getValueAsDouble(String string) {
        Variant variant = this.getValue(string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() == 5) {
            return new Double(variant.getDouble());
        }
        Variant variant2 = new Variant();
        variant2.copy(variant);
        variant2.convertToType((short)5);
        return variant2.getDouble();
    }

    public Currency getValueAsCurrency(String string) {
        Variant variant = this.getValue(string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        Variant variant2 = new Variant();
        variant2.copy(variant);
        if (variant2.getType() != 6) {
            variant2.convertToType((short)6);
        }
        return variant2.getCurrency();
    }

    public Date getValueAsDate(String string) {
        Variant variant = this.getValue(string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() == 7) {
            return new Date(variant.getDate().getTime());
        }
        Variant variant2 = new Variant();
        variant2.copy(variant);
        variant2.convertToType((short)7);
        return variant2.getDate();
    }

    public byte[] getValueAsByteArray(String string) {
        Variant variant = this.getValue(string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() == 13) {
            return variant.getBinary();
        }
        Variant variant2 = new Variant();
        variant2.copy(variant);
        variant2.convertToType((short)13);
        return variant2.getBinary();
    }

    public Object getValueAsObject(String string) {
        Variant variant = this.getValue(string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() == 16384) {
            return variant.getObject();
        }
        Variant variant2 = new Variant();
        variant2.copy(variant);
        variant2.convertToType((short)16384);
        return variant2.getObject();
    }

    public short getStreamVersion() {
        return this.version;
    }

    public void setStreamVersion(short s) {
        this.version = s;
    }

    public short getPlatformVersion() {
        return this.getStreamVersion();
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public Iterator idIterator() {
        return this.variableMap.keySet().iterator();
    }

    public Iterator getMapIter() {
        return this.variableMap.entrySet().iterator();
    }

    public Map getVariableMap() {
        return this.variableMap;
    }

    public int size() {
        return this.variableMap.size();
    }

    public void clear() {
        this.variableMap.clear();
    }

    public void readFrom(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = (BufferedReader)reader;
        while (!(string = bufferedReader.readLine().trim()).equalsIgnoreCase("</param>") && !string.equalsIgnoreCase("<param/>")) {
            Object object;
            int n = string.indexOf("id=");
            if (n == -1) {
                return;
            }
            n = string.indexOf(34, n) + 1;
            int n2 = string.indexOf(34, n);
            String string2 = string.substring(n, n2);
            n = string.indexOf("type=");
            if (n == -1) {
                return;
            }
            n = string.indexOf(34, n) + 1;
            n2 = string.indexOf(34, n);
            String string3 = string.substring(n, n2);
            String string4 = null;
            n = string.indexOf(62, n2) + 1;
            if (string.charAt(n - 2) == '/') {
                string4 = "";
            } else {
                n2 = string.indexOf(60, n);
                object = string.substring(n, n2);
                string4 = XmlString.decode((String)object);
            }
            object = null;
            if (string4 != null) {
                switch (Variant.toType(string3)) {
                    case 3: {
                        try {
                            object = new Variant(Integer.parseInt(string4));
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = new Variant(string4);
                            ((Variant)object).setType((short)3);
                        }
                        break;
                    }
                    case 5: {
                        try {
                            object = new Variant(Double.parseDouble(string4));
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = new Variant(string4);
                            ((Variant)object).setType((short)5);
                        }
                        break;
                    }
                    case 8: {
                        object = new Variant(string4);
                        break;
                    }
                    case 13: {
                        byte[] byArray = Base64Converter.decode(string4);
                        if (byArray != null) {
                            object = new Variant(Base64Converter.decode(string4));
                            break;
                        }
                        object = new Variant(string4);
                        ((Variant)object).setType((short)13);
                        break;
                    }
                    case 7: {
                        try {
                            if (string4.length() <= 8) {
                                string4 = string4 + "000000";
                            }
                            if (this.defaultDateFormat == null) {
                                this.defaultDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                            }
                            object = new Variant(this.defaultDateFormat.parse(string4));
                        }
                        catch (ParseException parseException) {
                            object = new Variant(string4);
                            ((Variant)object).setType((short)7);
                        }
                        break;
                    }
                    case 6: {
                        try {
                            object = new Variant(new Currency(string4));
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = new Variant(string4);
                            ((Variant)object).setType((short)6);
                        }
                        break;
                    }
                    case 0: {
                        object = new Variant();
                        break;
                    }
                    default: {
                        object = new Variant(string4);
                        break;
                    }
                }
            } else {
                object = new Variant();
            }
            this.add(new Variable(string2, (Variant)object));
        }
    }

    public void readFrom(InputStream inputStream, String string) throws IOException {
        this.readFrom(new DataInputStream(inputStream), string);
    }

    public void readFrom(DataInputStream dataInputStream, String string) throws IOException {
        int n;
        short s = dataInputStream.readShort();
        this.version = dataInputStream.readShort();
        this.setCharset(string);
        if (this.version >= 4000) {
            if (s != -496) {
                throw new IOException("VariableList\uc758 \ud45c\uc2dc \uc624\ub958, mark=0x" + Integer.toHexString(s));
            }
            n = dataInputStream.readByte();
            if ((n & 0x80) != 0) {
                int n2 = n << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                n2 &= Integer.MAX_VALUE;
            } else {
                dataInputStream.readByte();
            }
        } else if (this.version >= 3100) {
            if (s != -240) {
                throw new IOException("VariableList\uc758 \ud45c\uc2dc \uc624\ub958, mark=0x" + Integer.toHexString(s));
            }
            n = dataInputStream.readUnsignedShort();
            String string2 = Codepage.codepageToCharset(n);
            if (Codepage.isSupportedCharset(string2)) {
                string = string2;
                this.setCharset(string);
            }
        }
        n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5 = dataInputStream.readShort();
            if (n5 == 0) continue;
            byte[] byArray = new byte[n5];
            for (n3 = 0; n3 < n5 && (n4 = dataInputStream.read(byArray, n3, byArray.length - n3)) > 0; n3 += n4) {
            }
            if (n3 != n5) {
                throw new IOException("Variable\uc758 \uc2dd\ubcc4\uc790 \uc77d\uae30 \uc624\ub958, length=" + n5 + ", count=" + n3);
            }
            String string3 = new String(byArray);
            Variant variant = new Variant();
            variant.readFrom(dataInputStream, string, this.version);
            this.add(string3, variant);
        }
    }

    public void writeTo(Writer writer) {
        this.writeTo(writer, true);
    }

    public void writeTo(Writer writer, boolean bl) {
        PrintWriter printWriter = (PrintWriter)writer;
        printWriter.print("\t");
        printWriter.println("<params>");
        Iterator iterator = this.idIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Variant variant = (Variant)this.variableMap.get(string);
            printWriter.print("\t");
            printWriter.print("\t");
            printWriter.print("<param");
            printWriter.print(" id=\"" + string + '\"');
            printWriter.print(" type=\"" + variant.getTypeName() + "\">");
            String string2 = null;
            string2 = variant.getTypeName().equalsIgnoreCase("BINARY") ? Base64Converter.encode(variant.getBinary(), bl) : variant.asString();
            String string3 = null;
            string3 = string2 != null ? XmlString.encode(string2) : "";
            printWriter.print(string3);
            printWriter.println("</param>");
        }
        printWriter.print("\t");
        printWriter.println("</params>");
    }

    public void writeTo(DataOutputStream dataOutputStream, String string) throws IOException {
        this.writeTo(dataOutputStream, string, (short)2000);
    }

    public void writeTo(DataOutputStream dataOutputStream, String string, short s) throws IOException {
        Object object;
        if (s >= 4000) {
            dataOutputStream.writeShort(-496);
            dataOutputStream.writeShort(s);
        } else if (s >= 3100) {
            dataOutputStream.writeShort(-240);
            dataOutputStream.writeShort(s);
            dataOutputStream.writeShort(Codepage.charsetToCodepage(string));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeShort(this.variableMap.size());
        Iterator iterator = this.idIterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Variant variant = (Variant)this.variableMap.get(object);
            byte[] byArray = null;
            byArray = s >= 4000 ? ((String)object).getBytes("utf-8") : (string == null ? ((String)object).getBytes() : ((String)object).getBytes(string));
            dataOutputStream2.writeShort(byArray.length);
            if (byArray.length == 0) continue;
            dataOutputStream2.write(byArray);
            variant.writeTo(dataOutputStream2, string, s);
        }
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        object = byteArrayOutputStream.toByteArray();
        if (s >= 4000) {
            int n = ((Object)object).length;
            if (n < 32768) {
                dataOutputStream.writeShort(n);
            } else {
                dataOutputStream.writeInt(n | Integer.MIN_VALUE);
            }
        }
        dataOutputStream.write((byte[])object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.size();
        stringBuffer.append("VariableList");
        stringBuffer.append('[');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.get(i).toString(false));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void printVariables() throws IOException {
        this.printVariables(true);
    }

    public void printVariables(boolean bl) throws IOException {
        VariableList.printVariables(this, bl);
    }

    public static void printVariables(VariableList variableList, boolean bl) throws IOException {
        VariableList.printVariables(new BufferedWriter(new OutputStreamWriter(System.out)), variableList, bl);
    }

    public static void printVariables(OutputStream outputStream, VariableList variableList, boolean bl) throws IOException {
        VariableList.printVariables(new BufferedWriter(new OutputStreamWriter(outputStream)), variableList, bl);
    }

    public static void printVariables(Writer writer, VariableList variableList, boolean bl) throws IOException {
        if (variableList == null) {
            writer.write("### Variable list : null\n");
            writer.flush();
            return;
        }
        writer.write("### Variable list : size = [" + variableList.size() + "]\n");
        Iterator iterator = variableList.getVariableMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Variant variant = (Variant)entry.getValue();
            Variable.printVariable(writer, new Variable(string, variant), bl, 1);
        }
        writer.flush();
    }
}

