/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.data.Variant;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;

public class Variable
implements Serializable {
    private String id;
    private Variant value;

    public Variable() {
    }

    public Variable(String string, Variant variant) {
        this.id = string;
        this.value = variant;
    }

    public String getId() {
        return this.id;
    }

    public String getID() {
        return this.getId();
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setID(String string) {
        this.setId(string);
    }

    public Variant getValue() {
        return this.value;
    }

    public void setValue(Variant variant) {
        this.value = variant;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        String string;
        String string2 = string = bl ? "Variable" : "";
        if (this.getValue() == null) {
            return string + "[id=" + this.getId() + ", value=null]";
        }
        return string + "[id=" + this.getId() + ", type=" + this.getValue().getTypeName() + ", value=" + this.getValue().asString() + "]";
    }

    public void dump() {
        System.out.print("Variable ID=[" + this.id + "], ");
        System.out.print("Type=[" + this.getValue().getTypeName() + "], ");
        System.out.println("Value=[" + this.getValue().toString() + "]");
    }

    public void printVariable() throws IOException {
        this.printVariable(true);
    }

    public void printVariable(boolean bl) throws IOException {
        Variable.printVariable(this, bl);
    }

    public static void printVariable(Variable variable, boolean bl) throws IOException {
        Variable.printVariable(new BufferedWriter(new OutputStreamWriter(System.out)), variable, bl, 0);
    }

    public static void printVariable(OutputStream outputStream, Variable variable, boolean bl, int n) throws IOException {
        outputStream.write((variable + System.getProperty("line.separator")).getBytes());
    }

    public static void printVariable(Writer writer, Variable variable, boolean bl, int n) throws IOException {
        String string = "";
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                string = string + "\t";
            }
        }
        if (variable == null) {
            writer.write(string + "@@@ Variable : null\n");
            writer.flush();
            return;
        }
        String string2 = variable.getId();
        Variant variant = variable.getValue();
        if (string2 != null && variant != null) {
            writer.write(string + "@@@ Variable : ID = \"" + string2 + "\", Type = <" + variant.getTypeName() + ">");
            if (bl) {
                writer.write(", Value = {" + variant.asString() + "}");
            }
            writer.write("\n");
        } else {
            writer.write(string + "@@@ Variable : null");
        }
        writer.flush();
    }
}

