/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.data.FileNameFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;

class TempFileNameFactory
implements FileNameFactory {
    private File dir;

    public TempFileNameFactory() {
        this(System.getProperty("java.io.tmpdir"));
    }

    public TempFileNameFactory(String string) {
        this(new File(string));
    }

    public TempFileNameFactory(File file) {
        this.dir = file;
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public String getFileName(String string, String string2, int n, short s, List list) throws IOException {
        String string3 = this.normalizeId(string) + '_' + this.toString(s) + String.valueOf(n) + '_';
        String string4 = ".tmp";
        return File.createTempFile(string3, string4, this.dir).getAbsolutePath();
    }

    private String normalizeId(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.isAlphabet(cArray[i]) && !this.isLatinDigit(cArray[i])) continue;
            cArray2[n2++] = cArray[i];
        }
        return n2 == 0 ? "dataset" : new String(cArray2, 0, n2);
    }

    private String toString(short s) {
        switch (s) {
            case 0: {
                return "e";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "i";
            }
            case 4: {
                return "u";
            }
            case 8: {
                return "d";
            }
        }
        return "f";
    }

    private boolean isAlphabet(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean isLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

