/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.Platform;
import com.tobesoft.platform.data.ColumnInfo;
import com.tobesoft.platform.data.ColumnInfoList;
import com.tobesoft.platform.data.Currency;
import com.tobesoft.platform.data.Dataset;
import com.tobesoft.platform.data.Variant;
import com.tobesoft.platform.util.Base64Converter;
import com.tobesoft.platform.util.PushbackLineReader;
import com.tobesoft.platform.util.XmlString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Record
implements Serializable {
    static Log log = LogFactory.getLog((Class)(class$com$tobesoft$platform$data$Record == null ? (class$com$tobesoft$platform$data$Record = Record.class$("com.tobesoft.platform.data.Record")) : class$com$tobesoft$platform$data$Record));
    private short rowType;
    private short originalIndex;
    private List varList;
    private String lastLine;
    private SimpleDateFormat defaultDateFormat = null;
    private SimpleDateFormat defaultShortDateFormat = null;
    static /* synthetic */ Class class$com$tobesoft$platform$data$Record;

    public Record() {
        this.rowType = 1;
        this.originalIndex = (short)-1;
        this.varList = new ArrayList();
    }

    public Record(ColumnInfoList columnInfoList) {
        this.rowType = 1;
        this.originalIndex = (short)-1;
        this.varList = new ArrayList();
        int n = columnInfoList.size();
        for (int i = 0; i < n; ++i) {
            this.varList.add(new Variant());
        }
    }

    public Record(Dataset dataset) {
        this.rowType = 1;
        this.originalIndex = (short)-1;
        this.varList = new ArrayList();
        int n = dataset.getColumnCount() - dataset.getConstColumnCount();
        for (int i = 0; i < n; ++i) {
            this.varList.add(new Variant());
        }
    }

    public Record(short s) {
        this.rowType = s;
        this.originalIndex = (short)-1;
        this.varList = new ArrayList();
    }

    public Record(ColumnInfoList columnInfoList, short s) {
        this.rowType = s;
        this.originalIndex = (short)-1;
        this.varList = new ArrayList();
        int n = columnInfoList.size();
        for (int i = 0; i < n; ++i) {
            this.varList.add(new Variant());
        }
    }

    public Record(Dataset dataset, short s) {
        this.rowType = s;
        this.originalIndex = (short)-1;
        this.varList = new ArrayList();
        int n = dataset.getColumnCount() - dataset.getConstColumnCount();
        for (int i = 0; i < n; ++i) {
            this.varList.add(new Variant());
        }
    }

    protected void addNewColumn(int n) {
        this.varList.add(n, new Variant());
    }

    public short getRowType() {
        return (short)(this.rowType & 0xFF);
    }

    public void setRowType(short s) {
        this.rowType = (short)(this.rowType & 0xFF00 | s);
    }

    public short getOriginalIndex() {
        return this.originalIndex;
    }

    public void setOriginalIndex(short s) {
        this.originalIndex = s;
    }

    public short getOrgIdx() {
        return this.originalIndex;
    }

    public void setOrgIdx(short s) {
        this.originalIndex = s;
    }

    public void increaseOriginalIndex() {
        this.originalIndex = (short)(this.originalIndex + 1);
    }

    public void decreaseOriginalIndex() {
        this.originalIndex = (short)(this.originalIndex - 1);
    }

    public Variant getColumn(int n) {
        return (Variant)this.varList.get(n);
    }

    public void setColumn(int n, Variant variant) {
        while (n >= this.varList.size()) {
            Variant variant2 = new Variant();
            this.varList.add(variant2);
        }
        this.varList.set(n, variant);
    }

    public int getColumnCount() {
        return this.varList.size();
    }

    public void clear() {
        this.rowType = 1;
        this.originalIndex = (short)-1;
        this.varList.clear();
    }

    public List getList() {
        return this.varList;
    }

    public void copyRecord(Record record) {
        if (record == null) {
            return;
        }
        this.clear();
        this.setRowType(record.getRowType());
        this.setOriginalIndex(record.getOriginalIndex());
        int n = record.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Variant variant = record.getColumn(i);
            Variant variant2 = new Variant();
            variant2.copy(variant);
            this.varList.add(i, variant2);
        }
    }

    public boolean equals(Object object) {
        Record record = (Record)object;
        int n = this.varList.size();
        if (n != record.varList.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Variant variant = (Variant)this.varList.get(i);
            Variant variant2 = (Variant)record.varList.get(i);
            if (variant == null && variant2 == null) continue;
            if (variant == null && variant2 != null || variant != null && variant2 == null) {
                return false;
            }
            if (variant.equals(variant2)) continue;
            return false;
        }
        return true;
    }

    public void readFrom(Reader reader, ColumnInfoList columnInfoList) throws IOException {
        this.lastLine = null;
        BufferedReader bufferedReader = (BufferedReader)reader;
        int n = columnInfoList.size();
        for (int i = 0; i < n; ++i) {
            String string = bufferedReader.readLine();
            if ("</record>".equals(string.trim()) || "</org_record>".equals(string.trim())) {
                if (bufferedReader instanceof PushbackLineReader) {
                    ((PushbackLineReader)bufferedReader).unreadLine(string);
                    break;
                }
                this.lastLine = string;
                break;
            }
            string = string.trim();
            int n2 = string.indexOf(60) + 1;
            int n3 = string.indexOf("/>", n2);
            boolean bl = false;
            if (n3 > 0) {
                bl = true;
            } else {
                n3 = string.indexOf(62, n2);
            }
            String string2 = string.substring(n2, n3);
            String string3 = string2.trim();
            if (string3.length() < n3 - n2) {
                throw new IllegalArgumentException("Invalid column id: '" + string2 + "'");
            }
            int n4 = columnInfoList.indexOf(string3);
            if (n4 == -1) {
                throw new IllegalArgumentException("Could not find column: id='" + string3 + "'");
            }
            ColumnInfo columnInfo = columnInfoList.get(n4);
            if (bl) {
                this.varList.set(n4, new Variant());
                continue;
            }
            n2 = n3 + 1;
            n3 = string.indexOf("</", n2);
            String string4 = null;
            String string5 = null;
            if (n3 > 0) {
                string4 = string.substring(n2, n3);
                string5 = XmlString.decode(string4);
            }
            Variant variant = null;
            if (string5 != null) {
                switch (columnInfo.getType()) {
                    case 2: {
                        try {
                            variant = new Variant(Integer.parseInt(string5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            variant = new Variant(string5);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            variant = new Variant(Double.parseDouble(string5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            variant = new Variant(string5);
                        }
                        break;
                    }
                    case 1: {
                        variant = new Variant(string5);
                        break;
                    }
                    case 9: {
                        variant = new Variant(Base64Converter.decode(string5));
                        break;
                    }
                    case 8: {
                        try {
                            if (string5.length() == 8) {
                                if (this.defaultShortDateFormat == null) {
                                    this.defaultShortDateFormat = new SimpleDateFormat("yyyyMMdd");
                                }
                                variant = new Variant(this.defaultShortDateFormat.parse(string5));
                                break;
                            }
                            if (this.defaultDateFormat == null) {
                                this.defaultDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                            }
                            variant = new Variant(this.defaultDateFormat.parse(string5));
                        }
                        catch (ParseException parseException) {
                            variant = new Variant(string5);
                        }
                        break;
                    }
                    case 5: {
                        try {
                            variant = new Variant(new Currency(string5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            variant = new Variant(string5);
                        }
                        break;
                    }
                    case 13: {
                        throw new IOException("XML \ud615\uc2dd\uc778 \uacbd\uc6b0 \ud30c\uc77c \uc1a1\uc218\uc2e0 \ubd88\uac00");
                    }
                    default: {
                        variant = new Variant(string5);
                        break;
                    }
                }
            } else {
                variant = new Variant();
            }
            this.varList.set(n4, variant);
        }
    }

    public void readFrom(InputStream inputStream, String string, Dataset dataset) throws IOException {
        this.readFrom(new DataInputStream(inputStream), string, dataset);
    }

    public void readFrom(DataInputStream dataInputStream, String string, Dataset dataset) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        short s = dataInputStream.readShort();
        this.setRowType(s);
        this.originalIndex = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            Variant variant = new Variant();
            if (dataset != null) {
                ColumnInfo columnInfo = dataset.getColumnInfo(i);
                if (columnInfo.getType() == 13) {
                    String string2 = dataset.getFileNameFactory().getFileName(dataset.getId(), columnInfo.getId(), 0, this.getRowType(), this.varList);
                    variant.readFrom(dataInputStream, string, (short)3100, new File(string2));
                } else {
                    variant.readFrom(dataInputStream, string, (short)3100);
                }
            } else {
                variant.readFrom(dataInputStream, string, (short)3100);
            }
            this.varList.set(i, variant);
        }
    }

    void readFrom(DataInputStream dataInputStream, String string, int n, Dataset dataset) throws IOException {
        int n2 = dataInputStream.readUnsignedShort();
        short s = dataInputStream.readShort();
        this.setRowType(s);
        this.originalIndex = dataInputStream.readShort();
        for (int i = 0; i < n2; ++i) {
            Variant variant = new Variant();
            if (dataset != null) {
                ColumnInfo columnInfo = dataset.getColumnInfo(i);
                if (columnInfo.getType() == 13) {
                    String string2 = dataset.getFileNameFactory().getFileName(dataset.getId(), columnInfo.getId(), n, this.getRowType(), this.varList);
                    variant.readFrom(dataInputStream, string, (short)3100, new File(string2));
                } else {
                    variant.readFrom(dataInputStream, string, (short)3100);
                }
            } else {
                variant.readFrom(dataInputStream, string, (short)3100);
            }
            this.varList.set(i, variant);
        }
    }

    void readFromStream400(DataInputStream dataInputStream, String string, int n, short s, int n2, Dataset dataset) throws IOException {
        this.setRowType(s);
        for (int i = 0; i < n; ++i) {
            Variant variant = new Variant();
            if (dataset != null) {
                ColumnInfo columnInfo = dataset.getColumnInfo(i);
                if (columnInfo == null) {
                    variant.readFrom(dataInputStream, string, (short)4000);
                    continue;
                }
                if (columnInfo.getType() == 13) {
                    String string2 = dataset.getFileNameFactory().getFileName(dataset.getId(), columnInfo.getId(), n2, this.getRowType(), this.varList);
                    variant.readFrom(dataInputStream, string, (short)4000, new File(string2));
                } else {
                    variant.readFrom(dataInputStream, string, (short)4000);
                }
            } else {
                variant.readFrom(dataInputStream, string, (short)4000);
            }
            this.varList.set(i, variant);
        }
    }

    public void readFrom2(InputStream inputStream, Dataset dataset) throws IOException {
        this.readFrom2(new DataInputStream(inputStream), dataset);
    }

    public void readFrom2(DataInputStream dataInputStream, Dataset dataset) throws IOException {
        long l;
        int n = 0;
        byte by = dataInputStream.readByte();
        if ((by & 0x80) != 0) {
            n = by << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
            n &= Integer.MAX_VALUE;
        } else {
            n = by << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
        byte[] byArray = new byte[8192];
        int n2 = 0;
        for (l = 0L; l < (long)n && (n2 = 8192L > (long)n - l ? dataInputStream.read(byArray, 0, (int)((long)n - l)) : dataInputStream.read(byArray, 0, 8192)) > 0; l += (long)n2) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        if (l != (long)n) {
            throw new IOException("Record \uc77d\uae30 \uc624\ub958, length=" + n + ", count=" + l);
        }
        byteArrayOutputStream.close();
        DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        int n3 = 0xFFFF & dataInputStream2.readShort();
        this.setRowType(dataInputStream2.readShort());
        this.originalIndex = dataInputStream2.readShort();
        for (int i = 0; i < n3; ++i) {
            Variant variant = new Variant();
            if (dataset != null) {
                ColumnInfo columnInfo = dataset.getColumnInfo(i);
                if (columnInfo.getType() == 13) {
                    String string = dataset.getFileNameFactory().getFileName(dataset.getId(), columnInfo.getId(), 0, this.getRowType(), this.varList);
                    variant.readFrom2(dataInputStream2, new File(string));
                } else {
                    variant.readFrom2(dataInputStream2);
                }
            } else {
                variant.readFrom2(dataInputStream2);
            }
            this.varList.set(i, variant);
        }
    }

    void readFrom2(DataInputStream dataInputStream, int n, Dataset dataset) throws IOException {
        long l;
        int n2 = 0;
        byte by = dataInputStream.readByte();
        if ((by & 0x80) != 0) {
            n2 = by << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
            n2 &= Integer.MAX_VALUE;
        } else {
            n2 = by << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
        byte[] byArray = new byte[8192];
        int n3 = 0;
        for (l = 0L; l < (long)n2 && (n3 = 8192L > (long)n2 - l ? dataInputStream.read(byArray, 0, (int)((long)n2 - l)) : dataInputStream.read(byArray, 0, 8192)) > 0; l += (long)n3) {
            byteArrayOutputStream.write(byArray, 0, n3);
        }
        if (l != (long)n2) {
            throw new IOException("Record \uc77d\uae30 \uc624\ub958, length=" + n2 + ", count=" + l);
        }
        byteArrayOutputStream.close();
        DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        int n4 = 0xFFFF & dataInputStream2.readShort();
        this.setRowType(dataInputStream2.readShort());
        this.originalIndex = dataInputStream2.readShort();
        for (int i = 0; i < n4; ++i) {
            Variant variant = new Variant();
            if (dataset != null) {
                ColumnInfo columnInfo = dataset.getColumnInfo(i);
                if (columnInfo.getType() == 13) {
                    String string = dataset.getFileNameFactory().getFileName(dataset.getId(), columnInfo.getId(), n, this.getRowType(), this.varList);
                    variant.readFrom2(dataInputStream2, new File(string));
                } else {
                    variant.readFrom2(dataInputStream2);
                }
            } else {
                variant.readFrom2(dataInputStream2);
            }
            this.varList.set(i, variant);
        }
    }

    public void writeTo(Writer writer, ColumnInfoList columnInfoList) throws IOException {
        this.writeTo(writer, columnInfoList, true);
    }

    public void writeTo(Writer writer, ColumnInfoList columnInfoList, boolean bl) throws IOException {
        Format[] formatArray = new Format[]{new DecimalFormat("0.#####"), new SimpleDateFormat("yyyyMMddHHmmss")};
        this.writeTo(writer, columnInfoList, bl, formatArray);
    }

    public void writeTo(Writer writer, ColumnInfoList columnInfoList, boolean bl, Format[] formatArray) throws IOException {
        PrintWriter printWriter = (PrintWriter)writer;
        int n = this.varList.size();
        for (int i = 0; i < n; ++i) {
            String string = null;
            byte[] byArray = null;
            ColumnInfo columnInfo = columnInfoList.get(i);
            Variant variant = (Variant)this.varList.get(i);
            if (variant.getType() == 0) {
                printWriter.print("\t");
                printWriter.print("\t");
                printWriter.print("\t");
                printWriter.println("<" + columnInfo.getId() + "/>");
                continue;
            }
            if (columnInfo.getType() == 13) {
                if (Platform.isDebug() && log.isErrorEnabled()) {
                    log.error((Object)("contentType=xml, info[" + columnInfo.getId() + "] type=COLUMN_TYPE_FILE"));
                }
                throw new IOException("XML \ud615\uc2dd\uc778 \uacbd\uc6b0 \ud30c\uc77c \uc1a1\uc218\uc2e0 \ubd88\uac00");
            }
            if (columnInfo.getType() == 9) {
                byArray = variant.getBinary();
            } else {
                string = variant.asString(formatArray);
            }
            if (string != null || byArray != null) {
                printWriter.print("\t");
                printWriter.print("\t");
                printWriter.print("\t");
                printWriter.print("<" + columnInfo.getId() + ">");
                if (byArray != null) {
                    if (Platform.isDebug() && log.isTraceEnabled()) {
                        log.trace((Object)("blob[" + columnInfo.getId() + "] length=" + byArray.length));
                    }
                    Base64Converter.encodeAndWrite(byArray, printWriter, bl);
                } else {
                    printWriter.print(XmlString.encode(string));
                }
                printWriter.println("</" + columnInfo.getId() + ">");
                continue;
            }
            printWriter.print("\t");
            printWriter.print("\t");
            printWriter.print("\t");
            printWriter.println("<" + columnInfo.getId() + "/>");
        }
    }

    public void writeTo(OutputStream outputStream, String string, Dataset dataset) throws IOException {
        this.writeTo(new DataOutputStream(outputStream), string, dataset);
    }

    public void writeTo(DataOutputStream dataOutputStream, String string, Dataset dataset) throws IOException {
        this.writeTo(dataOutputStream, string, (short)3100, dataset);
    }

    void writeTo(DataOutputStream dataOutputStream, String string, short s, Dataset dataset) throws IOException {
        int n;
        if (s >= 4000) {
            n = this.getWriteLength(string, s, dataset);
            if (n < 32768) {
                dataOutputStream.writeShort(n);
            } else {
                dataOutputStream.writeInt(n | Integer.MIN_VALUE);
            }
        }
        n = this.varList.size();
        if (s >= 4000) {
            dataOutputStream.writeShort(this.getRowType());
            dataOutputStream.writeShort(n);
        } else {
            dataOutputStream.writeShort(n);
            dataOutputStream.writeShort(this.getRowType());
            dataOutputStream.writeShort(this.originalIndex);
        }
        for (int i = 0; i < n; ++i) {
            if (dataset != null) {
                int n2 = dataset.getSortedColumnIndex(i);
                ColumnInfo columnInfo = dataset.getColumnInfo(n2);
                if (columnInfo.getType() == 13) {
                    ((Variant)this.varList.get(n2)).writeFileTo(dataOutputStream, string, s);
                    continue;
                }
                ((Variant)this.varList.get(n2)).writeTo(dataOutputStream, string, s);
                continue;
            }
            ((Variant)this.varList.get(i)).writeTo(dataOutputStream, string, s);
        }
    }

    int getWriteLength(String string, short s, Dataset dataset) throws IOException {
        int n = 0;
        int n2 = this.varList.size();
        if (s >= 4000) {
            n += 2;
            n += 2;
        } else {
            n += 2;
            n += 2;
            n += 2;
        }
        for (int i = 0; i < n2; ++i) {
            if (dataset != null) {
                ColumnInfo columnInfo = dataset.getColumnInfo(i);
                if (columnInfo.getType() == 13) {
                    n += ((Variant)this.varList.get(i)).getWriteFileLength(string, s);
                    continue;
                }
                n += ((Variant)this.varList.get(i)).getWriteLength(string, s);
                continue;
            }
            n += ((Variant)this.varList.get(i)).getWriteLength(string, s);
        }
        return n;
    }

    public void writeTo2(OutputStream outputStream, Dataset dataset) throws IOException {
        this.writeTo2(new DataOutputStream(outputStream), dataset);
    }

    public void writeTo2(DataOutputStream dataOutputStream, Dataset dataset) throws IOException {
        int n = this.getWrite2Length(dataset);
        if (n < 32768) {
            dataOutputStream.writeShort(n);
        } else {
            dataOutputStream.writeInt(n | Integer.MIN_VALUE);
        }
        int n2 = this.varList.size();
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(this.getRowType());
        dataOutputStream.writeShort(this.originalIndex);
        for (int i = 0; i < n2; ++i) {
            if (dataset != null) {
                ColumnInfo columnInfo = dataset.getColumnInfo(i);
                if (columnInfo.getType() == 13) {
                    ((Variant)this.varList.get(i)).writeFileTo2(dataOutputStream);
                    continue;
                }
                ((Variant)this.varList.get(i)).writeTo2(dataOutputStream);
                continue;
            }
            ((Variant)this.varList.get(i)).writeTo2(dataOutputStream);
        }
    }

    int getWrite2Length(Dataset dataset) throws IOException {
        int n = 0;
        int n2 = this.varList.size();
        n += 2;
        n += 2;
        n += 2;
        for (int i = 0; i < n2; ++i) {
            if (dataset != null) {
                ColumnInfo columnInfo = dataset.getColumnInfo(i);
                if (columnInfo.getType() == 13) {
                    n += ((Variant)this.varList.get(i)).getWriteFile2Length();
                    continue;
                }
                n += ((Variant)this.varList.get(i)).getWrite2Length();
                continue;
            }
            n += ((Variant)this.varList.get(i)).getWrite2Length();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Record");
        stringBuffer.append("[rowType=").append(this.getRowType());
        stringBuffer.append(", originalIndex=").append(this.getOriginalIndex());
        stringBuffer.append(", varList=").append(this.varList);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void dump() {
        System.out.println(this.toString());
    }

    String getLastLine() {
        return this.lastLine;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

