/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.PlatformResponse;
import com.tobesoft.platform.data.Dataset;
import com.tobesoft.platform.data.DatasetList;
import com.tobesoft.platform.data.Variable;
import com.tobesoft.platform.data.VariableList;
import com.tobesoft.platform.data.Variant;
import com.tobesoft.platform.util.Codepage;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;

public class PlatformData
implements Serializable {
    private VariableList vl;
    private DatasetList dl;
    private String charset;

    public PlatformData() {
        this(Codepage.getDefaultCharset());
    }

    public PlatformData(String string) {
        this.vl = new VariableList();
        this.dl = new DatasetList();
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
    }

    public PlatformData(VariableList variableList, DatasetList datasetList) {
        this(variableList, datasetList, Codepage.getDefaultCharset());
    }

    public PlatformData(VariableList variableList, DatasetList datasetList, String string) {
        this.vl = variableList;
        this.dl = datasetList;
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
    }

    public VariableList getVariableList() {
        return this.vl;
    }

    public void setVariableList(VariableList variableList) {
        this.vl = variableList;
    }

    public DatasetList getDatasetList() {
        return this.dl;
    }

    public void setDatasetList(DatasetList datasetList) {
        this.dl = datasetList;
    }

    public Variable getVariable(int n) {
        return this.vl == null ? null : this.vl.get(n);
    }

    public Variable getVariable(String string) {
        return this.vl == null ? null : this.vl.get(string);
    }

    public void addVariable(Variable variable) {
        if (this.vl == null) {
            this.vl = new VariableList();
        }
        this.vl.add(variable);
    }

    public void addVariable(String string, Variant variant) {
        if (this.vl == null) {
            this.vl = new VariableList();
        }
        this.vl.add(string, variant);
    }

    public Dataset getDataset(int n) {
        return this.dl == null ? null : this.dl.get(n);
    }

    public Dataset getDataset(String string) {
        return this.dl == null ? null : this.dl.get(string);
    }

    public void addDataset(Dataset dataset) {
        if (this.dl == null) {
            this.dl = new DatasetList();
        }
        this.dl.add(dataset);
    }

    public void addDataset(String string, Dataset dataset) {
        dataset.setId(string);
        this.addDataset(dataset);
    }

    public void clear() {
        this.vl.clear();
        this.dl.clear();
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String toXml() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PlatformResponse platformResponse = new PlatformResponse(charArrayWriter);
            platformResponse.setContentType(1);
            platformResponse.setCompressionType(0);
            platformResponse.setCharset(this.getCharset());
            platformResponse.sendData(this.vl, this.dl);
            ((Writer)charArrayWriter).close();
            return ((Object)charArrayWriter).toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String toString() {
        return this.toXml();
    }

    String toString(boolean bl, boolean bl2, boolean bl3) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PlatformData");
        stringBuffer.append('[');
        if (bl) {
            stringBuffer.append(string);
            stringBuffer.append("vl=").append(this.vl);
        }
        if (bl2 || bl3) {
            stringBuffer.append(string);
            String string2 = this.dl == null ? "null" : this.dl.toString(bl2, bl3);
            stringBuffer.append("dl=").append(string2);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void printData() throws IOException {
        this.printData(true, true, true, true);
    }

    public void printData(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        PlatformData.printData(this, bl, bl2, bl3, bl4);
    }

    public static void printData(PlatformData platformData, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        PlatformData.printData(new BufferedWriter(new OutputStreamWriter(System.out)), platformData, bl, bl2, bl3, bl4);
    }

    public static void printData(OutputStream outputStream, PlatformData platformData, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        PlatformData.printData(new BufferedWriter(new OutputStreamWriter(outputStream, platformData.getCharset())), platformData, bl, bl2, bl3, bl4);
    }

    public static void printData(Writer writer, PlatformData platformData, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        if (platformData == null) {
            writer.write("$$$ PlatformData : null\n");
            writer.flush();
            return;
        }
        writer.write("$$$ PlatformData : VariableList size = [" + platformData.getVariableList().size() + "]" + ", DatasetList size = [" + platformData.getDatasetList().size() + "]\n");
        VariableList.printVariables(writer, platformData.getVariableList(), bl);
        DatasetList.printDatasets(writer, platformData.getDatasetList(), bl2, bl3, bl4);
        writer.flush();
    }
}

