/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.Platform;
import com.tobesoft.platform.data.Dataset;
import com.tobesoft.platform.data.FileNameFactory;
import com.tobesoft.platform.data.TempFileNameFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasetList
implements Serializable {
    static Log log = LogFactory.getLog((Class)(class$com$tobesoft$platform$data$DatasetList == null ? (class$com$tobesoft$platform$data$DatasetList = DatasetList.class$("com.tobesoft.platform.data.DatasetList")) : class$com$tobesoft$platform$data$DatasetList));
    private Map datasetMap = new HashMap();
    private List datasetList = new ArrayList();
    private int lastOrder = -1;
    private transient String fileUploadDir;
    private transient FileNameFactory fileNameFactory;
    private transient List targetColumnInfoList;
    static /* synthetic */ Class class$com$tobesoft$platform$data$DatasetList;

    public Dataset get(int n) {
        if (n >= this.size()) {
            return null;
        }
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (n == n2) {
                return (Dataset)e;
            }
            ++n2;
        }
        return null;
    }

    public Dataset getDataset(int n) {
        return this.get(n);
    }

    public Dataset get(String string) {
        return (Dataset)this.datasetMap.get(string);
    }

    public Dataset getDataset(String string) {
        return this.get(string);
    }

    public Dataset getByOrder(int n) {
        if (n >= 0 && n < this.datasetList.size()) {
            return (Dataset)this.datasetList.get(n);
        }
        return null;
    }

    public Dataset getDatasetByOrder(int n) {
        return this.getByOrder(n);
    }

    public void add(Dataset dataset) {
        dataset.setOrder(++this.lastOrder);
        this.datasetMap.put(dataset.getId(), dataset);
        this.datasetList.add(dataset);
    }

    public void addDataset(Dataset dataset) {
        this.add(dataset);
    }

    public void add(String string, Dataset dataset) {
        dataset.setId(string);
        this.add(dataset);
    }

    public void addDataset(String string, Dataset dataset) {
        this.add(string, dataset);
    }

    public void remove(String string) {
        Dataset dataset = (Dataset)this.datasetMap.remove(string);
        if (dataset != null) {
            int n = this.datasetList.indexOf(dataset);
            this.datasetList.set(n, null);
        }
    }

    public void deleteDataset(String string) {
        this.remove(string);
    }

    public void clear() {
        this.datasetMap.clear();
        this.datasetList.clear();
    }

    public int size() {
        return this.datasetMap.size();
    }

    public int getLastOrder() {
        return this.lastOrder;
    }

    public Iterator iterator() {
        return this.datasetMap.values().iterator();
    }

    public Iterator getMapIter() {
        return this.datasetMap.entrySet().iterator();
    }

    public Map getDatasetMap() {
        return this.datasetMap;
    }

    public String getFileUploadDir() {
        return this.fileUploadDir == null ? System.getProperty("java.io.tmpdir") : this.fileUploadDir;
    }

    public void setFileUploadDir(String string) {
        this.fileUploadDir = string;
    }

    public FileNameFactory getFileNameFactory() {
        return this.fileNameFactory == null ? new TempFileNameFactory(this.getFileUploadDir()) : this.fileNameFactory;
    }

    public void setFileNameFactory(FileNameFactory fileNameFactory) {
        this.fileNameFactory = fileNameFactory;
    }

    public short getTargetColumnType(String string, String string2) {
        Object[] objectArray = this.getTargetColumnInfo(string, string2);
        return objectArray == null ? (short)0 : (Short)objectArray[2];
    }

    public void setTargetColumnType(String string, String string2, short s) {
        Object[] objectArray = this.getTargetColumnInfo(string, string2);
        if (objectArray == null) {
            this.addTargetColumnInfo(string, string2, s);
        } else {
            objectArray[2] = new Short(s);
        }
    }

    private Object[] getTargetColumnInfo(String string, String string2) {
        if (this.targetColumnInfoList == null) {
            return null;
        }
        Iterator iterator = this.targetColumnInfoList.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            if (!string.equals(objectArray[0]) || !string2.equals(objectArray[1])) continue;
            return objectArray;
        }
        return null;
    }

    private void addTargetColumnInfo(String string, String string2, short s) {
        if (this.targetColumnInfoList == null) {
            this.targetColumnInfoList = new ArrayList();
        }
        this.targetColumnInfoList.add(new Object[]{string, string2, new Short(s)});
    }

    public void readFrom(Reader reader, String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = (BufferedReader)reader;
        while ((string2 = bufferedReader.readLine()) != null && !(string2 = string2.trim()).equalsIgnoreCase("</root>") && string2.substring(0, 8).equalsIgnoreCase("<dataset")) {
            Dataset dataset = new Dataset();
            dataset.setFileNameFactory(this.fileNameFactory);
            dataset.setTargetColumnInfoList(this.targetColumnInfoList);
            dataset.setCharset(string);
            if (string2.indexOf("id") > 0) {
                dataset.setId(string2.substring(string2.indexOf(34) + 1, string2.lastIndexOf(34)));
            }
            if (string2.indexOf("</dataset>") < 0) {
                dataset.readFrom(bufferedReader);
            }
            this.add(dataset);
        }
    }

    public void readFrom(InputStream inputStream, String string, int n) throws IOException {
        this.readFrom(new DataInputStream(inputStream), string, n);
    }

    public void readFrom(DataInputStream dataInputStream, String string, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            Dataset dataset = new Dataset();
            dataset.setCharset(string);
            dataset.setFileNameFactory(this.fileNameFactory);
            dataset.setTargetColumnInfoList(this.targetColumnInfoList);
            dataset.readFrom(dataInputStream);
            this.add(dataset);
        }
    }

    public void readFrom(DataInputStream dataInputStream, String string, int n, Locale locale) throws IOException {
        for (int i = 0; i < n; ++i) {
            Dataset dataset = new Dataset();
            dataset.setCharset(string);
            dataset.setLocale(locale);
            dataset.setFileNameFactory(this.fileNameFactory);
            dataset.setTargetColumnInfoList(this.targetColumnInfoList);
            dataset.readFrom(dataInputStream);
            this.add(dataset);
        }
    }

    public void readFrom2(InputStream inputStream, int n) throws IOException {
        this.readFrom2(new DataInputStream(inputStream), n);
    }

    public void readFrom2(DataInputStream dataInputStream, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            Dataset dataset = new Dataset();
            dataset.setCharset("utf-8");
            dataset.setFileNameFactory(this.fileNameFactory);
            dataset.setTargetColumnInfoList(this.targetColumnInfoList);
            dataset.readFrom2(dataInputStream);
            this.add(dataset);
        }
    }

    public void writeTo(Writer writer, String string) throws IOException {
        this.writeTo(writer, string, (short)5);
    }

    public void writeTo(Writer writer, String string, short s) throws IOException {
        this.writeTo(writer, string, s, true);
    }

    public void writeTo(Writer writer, String string, short s, boolean bl) throws IOException {
        int n = this.size();
        int n2 = 0;
        int n3 = this.datasetList.size();
        for (int i = 0; n2 < n && i < n3; ++i) {
            Dataset dataset = this.getByOrder(i);
            if (dataset == null) {
                if (!Platform.isDebug() || !log.isDebugEnabled()) continue;
                log.debug((Object)("Dataset \ud1b5\uacfc, size=" + n + ", order=" + i));
                continue;
            }
            dataset.setCharset(string);
            dataset.writeTo(writer, s, bl);
            ++n2;
            if (!Platform.isDebug() || !log.isDebugEnabled()) continue;
            log.debug((Object)("Dataset \ucd9c\ub825, order=" + i));
        }
    }

    public void writeTo(DataOutputStream dataOutputStream, String string) throws IOException {
        this.writeTo(dataOutputStream, string, (short)3000, (short)5);
    }

    public void writeTo(DataOutputStream dataOutputStream, String string, short s) throws IOException {
        this.writeTo(dataOutputStream, string, (short)3000, s);
    }

    public void writeTo(DataOutputStream dataOutputStream, String string, short s, short s2) throws IOException {
        int n = this.size();
        int n2 = 0;
        int n3 = this.datasetList.size();
        for (int i = 0; n2 < n && i < n3; ++i) {
            Dataset dataset = this.getByOrder(i);
            if (dataset == null) {
                if (!Platform.isDebug() || !log.isDebugEnabled()) continue;
                log.debug((Object)("Dataset \ud1b5\uacfc, size=" + n + ", order=" + i));
                continue;
            }
            if (Platform.isDebug() && log.isDebugEnabled()) {
                log.debug((Object)("ds id=" + dataset.getId() + ", i=" + i + ", order=" + dataset.getOrder()));
            }
            dataset.setCharset(string);
            dataset.writeTo(dataOutputStream, s, s2);
            ++n2;
            if (!Platform.isDebug() || !log.isDebugEnabled()) continue;
            log.debug((Object)("Dataset \ucd9c\ub825, id=" + dataset.getId() + ", order=" + i));
        }
    }

    public void writeTo2(DataOutputStream dataOutputStream) throws IOException {
        this.writeTo2(dataOutputStream, (short)3000, (short)5);
    }

    public void writeTo2(DataOutputStream dataOutputStream, short s) throws IOException {
        this.writeTo2(dataOutputStream, (short)3000, s);
    }

    public void writeTo2(DataOutputStream dataOutputStream, short s, short s2) throws IOException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Dataset dataset = (Dataset)iterator.next();
            dataset.setCharset("utf-8");
            dataset.writeTo2(dataOutputStream, s, s2);
        }
    }

    public String toString() {
        return this.toString(true, true);
    }

    String toString(boolean bl, boolean bl2) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DatasetList");
        stringBuffer.append('[');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Dataset dataset = this.get(i);
            stringBuffer.append(string);
            String string2 = dataset.toString(bl, bl2);
            stringBuffer.append("ds[").append(i).append("]=").append(string2);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void printDatasets() throws IOException {
        this.printDatasets(true, true, true);
    }

    public void printDatasets(boolean bl, boolean bl2, boolean bl3) throws IOException {
        DatasetList.printDatasets(this, bl, bl2, bl3);
    }

    public static void printDatasets(DatasetList datasetList, boolean bl, boolean bl2, boolean bl3) throws IOException {
        DatasetList.printDatasets(new BufferedWriter(new OutputStreamWriter(System.out)), datasetList, bl, bl2, bl3);
    }

    public static void printDatasets(OutputStream outputStream, DatasetList datasetList, boolean bl, boolean bl2, boolean bl3) throws IOException {
        DatasetList.printDatasets(new BufferedWriter(new OutputStreamWriter(outputStream)), datasetList, bl, bl2, bl3);
    }

    public static void printDatasets(Writer writer, DatasetList datasetList, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (datasetList == null) {
            writer.write("### Dataset list : null\n");
            return;
        }
        writer.write("### Dataset list : size = [" + datasetList.size() + "]\n");
        Iterator iterator = datasetList.getDatasetMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Dataset dataset = (Dataset)entry.getValue();
            Dataset.printDataset(writer, dataset, bl, bl2, bl3, 1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

