/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.Platform;
import com.tobesoft.platform.data.ColumnInfo;
import com.tobesoft.platform.data.ColumnInfoList;
import com.tobesoft.platform.data.ConstColumnList;
import com.tobesoft.platform.data.Currency;
import com.tobesoft.platform.data.DatasetHasNoColumnException;
import com.tobesoft.platform.data.DuplicateColumnIdException;
import com.tobesoft.platform.data.FileNameFactory;
import com.tobesoft.platform.data.Record;
import com.tobesoft.platform.data.TempFileNameFactory;
import com.tobesoft.platform.data.Variable;
import com.tobesoft.platform.data.Variant;
import com.tobesoft.platform.util.Base64Converter;
import com.tobesoft.platform.util.Codepage;
import com.tobesoft.platform.util.XmlString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Dataset
implements Serializable {
    static Log log = LogFactory.getLog((Class)(class$com$tobesoft$platform$data$Dataset == null ? (class$com$tobesoft$platform$data$Dataset = Dataset.class$("com.tobesoft.platform.data.Dataset")) : class$com$tobesoft$platform$data$Dataset));
    public static final short DATASET_SAVE_NORMAL = 5;
    public static final short DATASET_SAVE_ALL = 6;
    public static final short DATASET_SAVE_UPDATE = 7;
    public static final short DATASET_SAVE_DELETE = 9;
    public static final int WRITE_ORDER_BY_ORDER = 0;
    public static final int WRITE_ORDER_BY_INDEX = 1;
    public static final short ROWTYPE_EMPTY = 0;
    public static final short ROWTYPE_NORMAL = 1;
    public static final short ROWTYPE_INSERT = 2;
    public static final short ROWTYPE_UPDATE = 4;
    public static final short ROWTYPE_DELETE = 8;
    public static final short ROWTYPE_LOGICAL = 16;
    public static final short ROWTYPE_FILTER = 256;
    public static final short ROWTYPE_SELECT = 4096;
    static final short MARK_310_DATASET = -255;
    static final short MARK_400_DATASET = -511;
    static final short MARK_OLD_DATASET = -511;
    static final short VERSION_DATASET = 3000;
    public static final short CY_ROWTYPE_EMPTY = 0;
    public static final short CY_ROWTYPE_NORMAL = 1;
    public static final short CY_ROWTYPE_INSERT = 2;
    public static final short CY_ROWTYPE_UPDATE = 4;
    public static final short CY_ROWTYPE_DELETE = 8;
    public static final short CY_ROWTYPE_LOGICAL = 16;
    public static final short CY_ROWTYPE_FILTER = 256;
    public static final short CY_ROWTYPE_SELECT = 4096;
    private String[] DECIMAL_FORMATS = new String[]{"0", "0.#", "0.##", "0.###", "0.####", "0.#####", "0.######", "0.#######", "0.########", "0.#########", "0.##########"};
    private ColumnInfoList columnInfoList;
    private ConstColumnList constColumnList;
    private List recordList;
    private List originalRecordList;
    private String id;
    private String charset;
    private int order;
    private int columnWriteOrder;
    private boolean isUpdating;
    private int insertedCount;
    private transient FileNameFactory fileNameFactory;
    private transient List targetColumnInfoList;
    private boolean ignoreColumnCase;
    private int decimalPlace = 5;
    private SimpleDateFormat defaultDateFormat = null;
    private SimpleDateFormat defaultShortDateFormat = null;
    static /* synthetic */ Class class$com$tobesoft$platform$data$Dataset;

    public Dataset() {
        this(null, null, true, true);
    }

    public Dataset(String string) {
        this(string, null, true, true);
    }

    public Dataset(String string, String string2) {
        this(string, string2, true, true);
    }

    public Dataset(String string, String string2, boolean bl, boolean bl2) {
        this.init(string, string2, bl, bl2);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getDataSetID() {
        return this.getId();
    }

    public void setDataSetID(String string) {
        this.setId(string);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        if (Codepage.isSupportedCharset(string)) {
            this.charset = string;
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public int getColumnWriteOrder() {
        return this.columnWriteOrder;
    }

    public void setColumnWriteOrder(int n) {
        this.columnWriteOrder = n;
    }

    public int getDecimalPlace() {
        return this.decimalPlace;
    }

    public void setDecimalPlace(int n) {
        this.decimalPlace = n < 0 ? 0 : (n > 10 ? 10 : n);
    }

    void setLocale(Locale locale) {
        this.columnInfoList.setLocale(locale);
        this.constColumnList.setLocale(locale);
    }

    Locale getLocale() {
        return this.columnInfoList.getLocale();
    }

    public int addColumn(String string, short s, int n) {
        return this.addColumn(string, s, n, (short)1);
    }

    public int addColumn(String string, short s, int n, short s2) {
        return this.addColumn(new ColumnInfo(string, s, n, s2));
    }

    public int addColumn(String string, short s, int n, short s2, short s3) {
        return this.addColumn(new ColumnInfo(string, s, n, s2, s3));
    }

    public int addColumn(String string, short s, int n, String string2) {
        return this.addColumn(new ColumnInfo(string, s, n, string2));
    }

    public int addColumn(String string, short s, int n, short s2, String string2) {
        return this.addColumn(new ColumnInfo(string, s, n, s2, string2));
    }

    public int addStringColumn(String string) {
        return this.addStringColumn(string, 256);
    }

    public int addStringColumn(String string, int n) {
        return this.addColumn(string, (short)1, n);
    }

    public int addIntegerColumn(String string) {
        return this.addIntegerColumn(string, 256);
    }

    public int addIntegerColumn(String string, int n) {
        return this.addColumn(string, (short)2, n);
    }

    public int addDecimalColumn(String string) {
        return this.addDecimalColumn(string, 256);
    }

    public int addDecimalColumn(String string, int n) {
        return this.addColumn(string, (short)4, n);
    }

    public int addCurrencyColumn(String string) {
        return this.addCurrencyColumn(string, 256);
    }

    public int addCurrencyColumn(String string, int n) {
        return this.addColumn(string, (short)5, n);
    }

    public int addDateColumn(String string) {
        return this.addDateColumn(string, 256);
    }

    public int addDateColumn(String string, int n) {
        return this.addColumn(string, (short)8, n);
    }

    public int addBlobColumn(String string) {
        return this.addBlobColumn(string, 256);
    }

    public int addBlobColumn(String string, int n) {
        return this.addColumn(string, (short)9, n);
    }

    public int addFileColumn(String string) {
        return this.addFileColumn(string, 256);
    }

    public int addFileColumn(String string, int n) {
        return this.addColumn(string, (short)13, n);
    }

    public int addConstColumn(String string, Variant variant) {
        return this.constColumnList.add(new Variable(string, variant));
    }

    public int addConstColumn(String string, String string2) {
        return this.addConstColumn(string, new Variant(string2));
    }

    public int addConstColumn(String string, int n) {
        return this.addConstColumn(string, new Variant(n));
    }

    public int addConstColumn(String string, Integer n) {
        return this.addConstColumn(string, new Variant(n));
    }

    public int addConstColumn(String string, double d) {
        return this.addConstColumn(string, new Variant(d));
    }

    public int addConstColumn(String string, Double d) {
        return this.addConstColumn(string, new Variant(d));
    }

    public int addConstColumn(String string, Currency currency) {
        return this.addConstColumn(string, new Variant(currency));
    }

    public int addConstColumn(String string, Date date) {
        return this.addConstColumn(string, new Variant(date));
    }

    private int addColumn(ColumnInfo columnInfo) {
        if (this.columnInfoList.containColumnIdByIgnoreCase(columnInfo.getColumnID())) {
            if (Platform.checkDuplicatedColumnId()) {
                throw new DuplicateColumnIdException(this.getId(), columnInfo.getColumnID());
            }
            return -1;
        }
        if (this.columnInfoList.containColumnId(columnInfo.getColumnID())) {
            if (Platform.checkDuplicatedColumnId()) {
                throw new DuplicateColumnIdException(this.getId(), columnInfo.getColumnID());
            }
            return -1;
        }
        int n = this.columnInfoList.addColumnInfo(columnInfo);
        if (this.originalRecordList.size() > 0 || this.recordList.size() > 0) {
            return this.addColumnForRecord(n);
        }
        return n;
    }

    private int addColumnForRecord(int n) {
        if (this.recordList == null) {
            return -1;
        }
        for (int i = 0; i < this.recordList.size(); ++i) {
            Record record = (Record)this.recordList.get(i);
            Record record2 = new Record();
            int n2 = record.getColumnCount();
            for (int j = 0; j < n2; ++j) {
                if (j == n) {
                    record2.addNewColumn(n);
                    record2.setColumn(n + 1, record.getColumn(n));
                    continue;
                }
                if (j > n) {
                    record2.setColumn(j + 1, record.getColumn(j));
                    continue;
                }
                if (j >= n) continue;
                record2.setColumn(j, record.getColumn(j));
            }
            this.recordList.set(i, record2);
        }
        return this.recordList.size() - 1;
    }

    public int appendRow() {
        return this.appendRow(true);
    }

    public int appendRow(boolean bl) {
        if (this.columnInfoList.isEmptyColumn()) {
            throw new DatasetHasNoColumnException(this.getId());
        }
        Record record = new Record(this);
        if (bl && this.isUpdating) {
            record.setRowType((short)2);
            ++this.insertedCount;
        } else {
            record.setRowType((short)1);
        }
        this.recordList.add(record);
        return this.recordList.size() - 1;
    }

    public int insertRow(int n) {
        return this.insertRow(n, true);
    }

    public int insertRow(int n, boolean bl) {
        int n2 = n < 0 ? 0 : (n >= this.recordList.size() ? this.recordList.size() : n);
        Record record = new Record(this);
        if (bl && this.isUpdating) {
            record.setRowType((short)2);
            ++this.insertedCount;
        }
        this.recordList.add(n2, record);
        return n2;
    }

    public int deleteRow(int n) {
        Record record = (Record)this.recordList.get(n);
        if (record == null) {
            return -1;
        }
        if (this.isUpdating) {
            short s = record.getRowType();
            if (s == 2) {
                --this.insertedCount;
            } else if (s == 1) {
                record.setRowType((short)8);
                record.setOriginalIndex((short)n);
                this.originalRecordList.add(record);
            } else if (s == 2) {
                record.setRowType((short)8);
                record.setOriginalIndex((short)n);
                this.originalRecordList.add(record);
            } else if (s == 4) {
                Record record2 = (Record)this.originalRecordList.get(record.getOriginalIndex());
                if (record2 != null) {
                    record2.setRowType((short)8);
                    record2.setOriginalIndex((short)n);
                } else {
                    record.setRowType((short)8);
                    record.setOriginalIndex((short)n);
                    this.originalRecordList.add(record);
                }
            }
        }
        this.recordList.remove(n);
        return 0;
    }

    public Variant getColumn(int n, String string) {
        int n2 = this.getColumnIndex(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 >= this.columnInfoList.size()) {
            Variable variable = this.constColumnList.get(n2 - this.columnInfoList.size());
            return variable.getValue();
        }
        if (n < 0 || n >= this.recordList.size()) {
            return null;
        }
        return ((Record)this.recordList.get(n)).getColumn(n2);
    }

    public Variant getColumn(int n, int n2) {
        return this.getColumn(n, this.getColumnId(n2));
    }

    public Variant getColumnByOrder(int n, int n2) {
        return this.getColumn(n, this.getColumnIdByOrder(n2));
    }

    public String getColumnAsString(int n, String string) {
        Variant variant = this.getColumn(n, string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() != 8) {
            Variant variant2 = new Variant();
            variant2.copy(variant);
            variant2.convertToType((short)8);
            return variant2.getString();
        }
        return String.valueOf(variant.getString().toCharArray());
    }

    public Integer getColumnAsInteger(int n, String string) {
        Variant variant = this.getColumn(n, string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() != 3) {
            Variant variant2 = new Variant();
            variant2.copy(variant);
            variant2.convertToType((short)3);
            return variant2.getInteger();
        }
        return new Integer(variant.getInteger());
    }

    public Double getColumnAsDouble(int n, String string) {
        Variant variant = this.getColumn(n, string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() != 5) {
            Variant variant2 = new Variant();
            variant2.copy(variant);
            variant2.convertToType((short)5);
            return variant2.getDouble();
        }
        return new Double(variant.getDouble());
    }

    public Currency getColumnAsCurrency(int n, String string) {
        Variant variant = this.getColumn(n, string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        Variant variant2 = new Variant();
        variant2.copy(variant);
        if (variant2.getType() != 6) {
            variant2.convertToType((short)6);
        }
        return variant2.getCurrency();
    }

    public Date getColumnAsDate(int n, String string) {
        Variant variant = this.getColumn(n, string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() != 7) {
            Variant variant2 = new Variant();
            variant2.copy(variant);
            variant2.convertToType((short)7);
            return variant2.getDate();
        }
        return new Date(variant.getDate().getTime());
    }

    public byte[] getColumnAsByteArray(int n, String string) {
        Variant variant = this.getColumn(n, string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() != 13) {
            Variant variant2 = new Variant();
            variant2.copy(variant);
            variant2.convertToType((short)13);
            return variant2.getBinary();
        }
        return variant.getBinary();
    }

    public Object getColumnAsObject(int n, String string) {
        Variant variant = this.getColumn(n, string);
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        if (variant.getType() != 16384) {
            Variant variant2 = new Variant();
            variant2.copy(variant);
            variant2.convertToType((short)16384);
            return variant2.getObject();
        }
        return variant.getObject();
    }

    public String getColumnAsString(int n, int n2) {
        return this.getColumnAsString(n, this.getColumnId(n2));
    }

    public Integer getColumnAsInteger(int n, int n2) {
        return this.getColumnAsInteger(n, this.getColumnId(n2));
    }

    public Double getColumnAsDouble(int n, int n2) {
        return this.getColumnAsDouble(n, this.getColumnId(n2));
    }

    public Currency getColumnAsCurrency(int n, int n2) {
        return this.getColumnAsCurrency(n, this.getColumnId(n2));
    }

    public Date getColumnAsDate(int n, int n2) {
        return this.getColumnAsDate(n, this.getColumnId(n2));
    }

    public byte[] getColumnAsByteArray(int n, int n2) {
        return this.getColumnAsByteArray(n, this.getColumnId(n2));
    }

    public Object getColumnAsObject(int n, int n2) {
        return this.getColumnAsObject(n, this.getColumnId(n2));
    }

    public Variant getConstColumn(String string) {
        return this.constColumnList.getVar(string);
    }

    public Variant getConstColumn(int n) {
        return this.constColumnList.getVar(n);
    }

    public boolean setColumn(int n, int n2, Variant variant) {
        return this.setColumn(n, this.getColumnId(n2), variant);
    }

    public boolean setColumn(int n, String string, Variant variant) {
        int n2 = this.getColumnIndex(string);
        if (n2 == -1) {
            return false;
        }
        if (n2 >= this.columnInfoList.size()) {
            return this.setConstColumn(string, variant);
        }
        ColumnInfo columnInfo = this.getColumnInfo(n2);
        if (columnInfo == null) {
            return false;
        }
        switch (columnInfo.getType()) {
            case 1: 
            case 11: 
            case 12: 
            case 13: {
                if (variant.getType() == 8) break;
                variant.convertToType((short)8);
                break;
            }
            case 2: {
                if (variant.getType() == 3) break;
                variant.convertToType((short)3);
                break;
            }
            case 4: {
                if (variant.getType() == 5) break;
                variant.convertToType((short)5);
                break;
            }
            case 5: {
                if (variant.getType() == 6) break;
                variant.convertToType((short)6);
                break;
            }
            case 8: {
                if (variant.getType() == 7) break;
                variant.convertToType((short)7);
                break;
            }
            case 9: {
                if (variant.getType() == 13) break;
                variant.convertToType((short)13);
                break;
            }
        }
        Record record = (Record)this.recordList.get(n);
        if (record == null) {
            return false;
        }
        if (!this.isUpdating || record.getRowType() == 2) {
            record.setColumn(n2, variant);
            return true;
        }
        if (record.getRowType() != 4) {
            Variant variant2 = record.getColumn(n2);
            if (variant2 != null && variant2.equals(variant)) {
                return true;
            }
            record.setRowType((short)4);
            Record record2 = new Record(this);
            record2.copyRecord(record);
            this.originalRecordList.add(record2);
            record.setOriginalIndex((short)(this.originalRecordList.size() - 1));
        } else {
            Record record3 = (Record)this.originalRecordList.get(record.getOriginalIndex());
            Variant variant3 = record3.getColumn(n2);
            if (variant3 != null && variant3.equals(variant) && record3.equals(record)) {
                this.originalRecordList.set(record.getOriginalIndex(), null);
                record.setRowType((short)1);
                record.setOriginalIndex((short)-1);
            }
        }
        record.setColumn(n2, variant);
        return true;
    }

    public boolean setColumn(int n, String string, String string2) {
        return this.setColumn(n, string, new Variant(string2));
    }

    public boolean setColumn(int n, String string, int n2) {
        return this.setColumn(n, string, new Variant(n2));
    }

    public boolean setColumn(int n, String string, Integer n2) {
        return this.setColumn(n, string, new Variant(n2));
    }

    public boolean setColumn(int n, String string, double d) {
        return this.setColumn(n, string, new Variant(d));
    }

    public boolean setColumn(int n, String string, Double d) {
        return this.setColumn(n, string, new Variant(d));
    }

    public boolean setColumn(int n, String string, Currency currency) {
        return this.setColumn(n, string, new Variant(currency));
    }

    public boolean setColumn(int n, String string, Date date) {
        return this.setColumn(n, string, new Variant(date));
    }

    public boolean setColumn(int n, String string, byte[] byArray) {
        return this.setColumn(n, string, new Variant(byArray));
    }

    public boolean setColumn(int n, int n2, String string) {
        return this.setColumn(n, n2, new Variant(string));
    }

    public boolean setColumn(int n, int n2, int n3) {
        return this.setColumn(n, n2, new Variant(n3));
    }

    public boolean setColumn(int n, int n2, Integer n3) {
        return this.setColumn(n, n2, new Variant(n3));
    }

    public boolean setColumn(int n, int n2, double d) {
        return this.setColumn(n, n2, new Variant(d));
    }

    public boolean setColumn(int n, int n2, Double d) {
        return this.setColumn(n, n2, new Variant(d));
    }

    public boolean setColumn(int n, int n2, Currency currency) {
        return this.setColumn(n, n2, new Variant(currency));
    }

    public boolean setColumn(int n, int n2, Date date) {
        return this.setColumn(n, n2, new Variant(date));
    }

    public boolean setColumn(int n, int n2, byte[] byArray) {
        return this.setColumn(n, n2, new Variant(byArray));
    }

    public boolean setConstColumn(String string, Variant variant) {
        Variant variant2 = this.constColumnList.getVar(string);
        if (variant2 == null) {
            this.constColumnList.addVar(string, variant);
        } else {
            variant2.copy(variant);
        }
        return true;
    }

    public boolean setConstColumn(String string, String string2) {
        return this.setConstColumn(string, new Variant(string2));
    }

    public boolean setConstColumn(String string, int n) {
        return this.setConstColumn(string, new Variant(n));
    }

    public boolean setConstColumn(String string, Integer n) {
        return this.setConstColumn(string, new Variant(n));
    }

    public boolean setConstColumn(String string, double d) {
        return this.setConstColumn(string, new Variant(d));
    }

    public boolean setConstColumn(String string, Double d) {
        return this.setConstColumn(string, new Variant(d));
    }

    public boolean setConstColumn(String string, Currency currency) {
        return this.setConstColumn(string, new Variant(currency));
    }

    public boolean setConstColumn(String string, Date date) {
        return this.setConstColumn(string, new Variant(date));
    }

    public boolean setConstColumn(String string, byte[] byArray) {
        return this.setConstColumn(string, new Variant(byArray));
    }

    public int getColumnCount() {
        return this.columnInfoList.size() + this.constColumnList.size();
    }

    public int getConstColumnCount() {
        return this.constColumnList.size();
    }

    public int getRowCount() {
        return this.recordList.size();
    }

    public int getUpdateRowCount() {
        int n = 0;
        Iterator iterator = this.recordList.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getRowType() != 4 && record.getRowType() != 2) continue;
            ++n;
        }
        return n;
    }

    public int getDeleteRowCount() {
        int n = 0;
        Iterator iterator = this.originalRecordList.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record == null || record.getRowType() != 8) continue;
            ++n;
        }
        return n;
    }

    public short getSummaryType(String string) {
        return this.getSummaryType(this.getColumnIndex(string));
    }

    public short getSummaryType(int n) {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        if (columnInfo == null) {
            return 0;
        }
        return columnInfo.getSummaryType();
    }

    public void setSummaryType(String string, short s) {
        this.setSummaryType(this.getColumnIndex(string), s);
    }

    public void setSummaryType(int n, short s) {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        if (columnInfo != null) {
            columnInfo.setSummaryType(s);
        }
    }

    public String getSummaryText(String string) {
        return this.getSummaryText(this.getColumnIndex(string));
    }

    public String getSummaryText(int n) {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        if (columnInfo == null) {
            return null;
        }
        if (columnInfo.getSummaryType() != 96) {
            return null;
        }
        return columnInfo.getSummaryText();
    }

    public boolean isSummaryColumn(String string) {
        return this.isSummaryColumn(this.getColumnIndex(string));
    }

    public boolean isSummaryColumn(int n) {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        if (columnInfo == null) {
            return false;
        }
        return columnInfo.isSummary();
    }

    public boolean IsSummaryColumn(String string) {
        return this.isSummaryColumn(string);
    }

    public boolean IsSummaryColumn(int n) {
        return this.isSummaryColumn(n);
    }

    public void deleteAll() {
        if (!this.isUpdating) {
            this.recordList.clear();
            this.originalRecordList.clear();
        } else {
            for (int i = this.recordList.size() - 1; i >= 0; --i) {
                this.deleteRow(i);
            }
        }
    }

    public void clearAll() {
        this.deleteAll();
        this.columnInfoList.clear();
        this.constColumnList.clear();
    }

    public boolean isUpdated() {
        if (this.insertedCount > 0) {
            return true;
        }
        return this.originalRecordList.size() > 0;
    }

    public boolean isIgnoreColumnCase() {
        return this.ignoreColumnCase;
    }

    public void setUpdating(boolean bl) {
        this.isUpdating = bl;
    }

    public void setUpdate(boolean bl) {
        this.setUpdating(bl);
    }

    public void setIgnoreColumnCase(boolean bl) {
        this.ignoreColumnCase = bl;
    }

    public short getRowType(int n) {
        if (n < 0 || n >= this.recordList.size()) {
            return 0;
        }
        Record record = (Record)this.recordList.get(n);
        if (record != null) {
            return record.getRowType();
        }
        return 0;
    }

    public void setRowType(int n, short s) {
        short s2;
        Record record;
        if (this.isUpdating && (s == 1 || s == 2 || s == 4 || s == 8) && (record = (Record)this.recordList.get(n)) != null && s != (s2 = record.getRowType())) {
            if (s2 == 1) {
                if (s == 2) {
                    record.setRowType(s);
                    ++this.insertedCount;
                } else if (s == 4) {
                    record.setRowType(s);
                } else if (s == 8) {
                    this.deleteRow(n);
                }
            } else if (s2 == 2) {
                if (s == 1) {
                    record.setRowType(s);
                    --this.insertedCount;
                } else if (s == 4) {
                    record.setRowType(s);
                    --this.insertedCount;
                } else if (s == 8) {
                    this.deleteRow(n);
                }
            } else if (s2 == 4) {
                if (s == 1) {
                    record.setRowType(s);
                    this.originalRecordList.set(record.getOriginalIndex(), null);
                } else if (s == 2) {
                    record.setRowType(s);
                    ++this.insertedCount;
                    this.originalRecordList.set(record.getOriginalIndex(), null);
                } else if (s == 8) {
                    this.deleteRow(n);
                }
            }
        }
    }

    public String getRowStatus(int n) {
        short s = this.getRowType(n);
        if (s == 1) {
            return "normal";
        }
        if (s == 2) {
            return "insert";
        }
        if (s == 4) {
            return "update";
        }
        if (s == 8) {
            return "delete";
        }
        return "unknown";
    }

    public short getOriginalRowType(int n) {
        if (n < 0 || n >= this.originalRecordList.size()) {
            return 0;
        }
        Record record = (Record)this.originalRecordList.get(n);
        if (record != null) {
            return record.getRowType();
        }
        return 0;
    }

    public short getOrgRowType(int n) {
        return this.getOriginalRowType(n);
    }

    public String getColumnId(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            return null;
        }
        if (n < this.columnInfoList.size()) {
            ColumnInfo columnInfo = this.columnInfoList.get(n);
            if (columnInfo != null) {
                return columnInfo.getId();
            }
            return null;
        }
        Variable variable = this.constColumnList.get(n - this.columnInfoList.size());
        if (variable != null) {
            return variable.getId();
        }
        return null;
    }

    public String getColumnID(int n) {
        return this.getColumnId(n);
    }

    public int getColumnIndex(String string) {
        int n = this.columnInfoList.indexOf(string);
        if (n == -1 && this.isIgnoreColumnCase()) {
            n = this.columnInfoList.indexOfIgnoreCase(string);
        }
        if (n == -1) {
            n = this.constColumnList.indexOf(string);
            if (n == -1 && this.isIgnoreColumnCase()) {
                n = this.constColumnList.indexOfIgnoreCase(string);
            }
            if (n == -1) {
                return -1;
            }
            return n + this.columnInfoList.size();
        }
        return n;
    }

    public int getColumnOrder(String string) {
        ColumnInfo columnInfo = this.columnInfoList.get(this.columnInfoList.indexOf(string));
        if (columnInfo == null) {
            int n = this.constColumnList.indexOf(string);
            if (n >= 0) {
                return this.columnInfoList.size() + this.constColumnList.indexOf(string);
            }
            return -1;
        }
        return columnInfo.getOrder();
    }

    public String getColumnIdByOrder(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.columnInfoList.size()) {
            Variable variable = this.constColumnList.get(n - this.columnInfoList.size());
            if (variable == null) {
                return null;
            }
            return variable.getId();
        }
        ColumnInfo columnInfo = this.getColumnInfoByOrder(n);
        if (columnInfo == null) {
            return null;
        }
        return columnInfo.getId();
    }

    public int getColumnIndexByOrder(int n) {
        if (n < 0) {
            return -1;
        }
        if (n >= this.columnInfoList.size()) {
            return n;
        }
        for (int i = 0; i < this.columnInfoList.size(); ++i) {
            if (this.columnInfoList.get(i).getOrder() != n) continue;
            return i;
        }
        return -1;
    }

    public ColumnInfo getColumnInfo(int n) {
        return this.columnInfoList.get(n);
    }

    public int getSortedColumnIndex(int n) {
        return this.columnInfoList.getSortedIndex(n);
    }

    public ColumnInfo getColumnInfoByOrder(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = this.columnInfoList.size();
        if (n >= n2) {
            return null;
        }
        for (int i = 0; i < n2; ++i) {
            ColumnInfo columnInfo = this.columnInfoList.get(i);
            if (columnInfo.getOrder() != n) continue;
            return columnInfo;
        }
        return null;
    }

    public Variant getDeleteColumn(int n, String string) {
        if (n < 0 || n >= this.originalRecordList.size()) {
            return null;
        }
        int n2 = this.getDeleteRowIndex(n);
        if (n2 < 0) {
            return null;
        }
        return this.getColumnFromOriginalRecord(n2, string);
    }

    public boolean setDeleteColumn(int n, int n2, Variant variant) {
        return this.setDeleteColumn(n, this.getColumnId(n2), variant);
    }

    public boolean setDeleteColumn(int n, String string, Variant variant) {
        if (n < 0 || n >= this.originalRecordList.size()) {
            return false;
        }
        int n2 = this.getDeleteRowIndex(n);
        if (n2 < 0) {
            return false;
        }
        int n3 = this.getColumnIndex(string);
        if (n3 == -1) {
            return false;
        }
        if (n3 >= this.columnInfoList.size()) {
            return this.setConstColumn(string, variant);
        }
        ColumnInfo columnInfo = this.getColumnInfo(n3);
        if (columnInfo == null) {
            return false;
        }
        switch (columnInfo.getType()) {
            case 1: 
            case 11: 
            case 12: 
            case 13: {
                if (variant.getType() == 8) break;
                variant.convertToType((short)8);
                break;
            }
            case 2: {
                if (variant.getType() == 3) break;
                variant.convertToType((short)3);
                break;
            }
            case 4: {
                if (variant.getType() == 5) break;
                variant.convertToType((short)5);
                break;
            }
            case 5: {
                if (variant.getType() == 6) break;
                variant.convertToType((short)6);
                break;
            }
            case 8: {
                if (variant.getType() == 7) break;
                variant.convertToType((short)7);
                break;
            }
            case 9: {
                if (variant.getType() == 13) break;
                variant.convertToType((short)13);
                break;
            }
        }
        Record record = (Record)this.originalRecordList.get(n2);
        if (record == null) {
            return false;
        }
        record.setColumn(n3, variant);
        return true;
    }

    public void setDeleteRowType(int n, short s) {
        if (this.isUpdating) {
            Record record;
            if (n < 0 || n >= this.originalRecordList.size()) {
                return;
            }
            int n2 = this.getDeleteRowIndex(n);
            if (n2 < 0) {
                return;
            }
            if ((s == 1 || s == 2 || s == 4 || s == 8) && (record = (Record)this.originalRecordList.get(n2)) != null) {
                if (s == 1) {
                    record.setRowType(s);
                    record.setOriginalIndex((short)-1);
                    this.recordList.add(record);
                    this.originalRecordList.set(n2, null);
                } else if (s == 2) {
                    record.setRowType(s);
                    record.setOriginalIndex((short)-1);
                    ++this.insertedCount;
                    this.recordList.add(record);
                    this.originalRecordList.set(n2, null);
                } else if (s == 4) {
                    record.setRowType(s);
                    record.setOriginalIndex((short)-1);
                    this.recordList.add(record);
                    this.originalRecordList.set(n2, null);
                } else if (s == 8) {
                    // empty if block
                }
            }
        }
    }

    public Variant getOriginalColumn(int n, String string) {
        int n2 = this.getOriginalRowIndex(n);
        if (n2 == -1) {
            return this.getColumn(n, string);
        }
        Record record = (Record)this.originalRecordList.get(n2);
        if (record != null) {
            return record.getColumn(this.getColumnIndex(string));
        }
        return this.getColumn(n, string);
    }

    public Variant getOrgColumn(int n, String string) {
        return this.getOriginalColumn(n, string);
    }

    public Variant getColumnFromOriginalRecord(int n, String string) {
        if (n < 0 || n >= this.originalRecordList.size()) {
            return null;
        }
        int n2 = this.getColumnIndex(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 >= this.columnInfoList.size()) {
            Variable variable = this.constColumnList.get(n2 - this.columnInfoList.size());
            return variable.getValue();
        }
        Record record = (Record)this.originalRecordList.get(n);
        return record == null ? null : record.getColumn(n2);
    }

    public Variant getOrgBuffColumn(int n, String string) {
        return this.getColumnFromOriginalRecord(n, string);
    }

    public int getDeleteRowIndex(int n) {
        int n2 = this.originalRecordList.size();
        for (int i = 0; i < n2; ++i) {
            Record record = (Record)this.originalRecordList.get(i);
            if (record == null || record.getRowType() != 8) continue;
            if (n == 0) {
                return i;
            }
            --n;
        }
        return -1;
    }

    public int getDeleteRowIdx(int n) {
        return this.getDeleteRowIndex(n);
    }

    public int getOriginalRowIndex(int n) {
        Record record = (Record)this.recordList.get(n);
        if (record == null) {
            return -1;
        }
        return record.getOriginalIndex();
    }

    public int getOrgIndex(int n) {
        return this.getOriginalRowIndex(n);
    }

    ColumnInfoList getColumnInfoList() {
        return this.columnInfoList;
    }

    ConstColumnList getConstColumnList() {
        return this.constColumnList;
    }

    FileNameFactory getFileNameFactory() {
        return this.fileNameFactory == null ? new TempFileNameFactory() : this.fileNameFactory;
    }

    void setFileNameFactory(FileNameFactory fileNameFactory) {
        this.fileNameFactory = fileNameFactory;
    }

    List getTargetColumnInfoList() {
        return this.targetColumnInfoList;
    }

    void setTargetColumnInfoList(List list) {
        this.targetColumnInfoList = list;
    }

    private void changeColumnInfo(ColumnInfo columnInfo) {
        Object[] objectArray = this.getTargetColumnInfo(columnInfo.getId());
        if (objectArray != null) {
            columnInfo.setType((Short)objectArray[2]);
        }
    }

    private void changeColumnInfoList(ColumnInfoList columnInfoList) {
        int n = columnInfoList.size();
        for (int i = 0; i < n; ++i) {
            this.changeColumnInfo(columnInfoList.get(i));
        }
    }

    private Object[] getTargetColumnInfo(String string) {
        if (this.targetColumnInfoList == null || this.targetColumnInfoList.isEmpty()) {
            return null;
        }
        String string2 = this.getId();
        int n = this.targetColumnInfoList.size();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])this.targetColumnInfoList.get(i);
            if (!string2.equals(objectArray[0]) || !string.equals(objectArray[1])) continue;
            return objectArray;
        }
        return null;
    }

    public void readFrom(Reader reader) throws IOException {
        BufferedReader bufferedReader = (BufferedReader)reader;
        char[] cArray = new char[10];
        while (true) {
            String string;
            String string2;
            int n;
            Object object;
            int n2;
            int n3 = -1;
            while ((n3 = bufferedReader.read()) != -1 && n3 != 60) {
            }
            bufferedReader.mark(10);
            int n4 = 0;
            for (n2 = 0; n2 < 10 && (n4 = bufferedReader.read(cArray, n2, 10 - n2)) > 0; n2 += n4) {
            }
            String string3 = new String(cArray, 0, n2).trim();
            bufferedReader.reset();
            char[] cArray2 = string3.toCharArray();
            if (!(cArray2[0] != 'c' && cArray2[0] != 'C' || cArray2[1] != 'o' && cArray2[1] != 'O' || cArray2[2] != 'l' && cArray2[2] != 'L' || cArray2[3] != 'u' && cArray2[3] != 'U' || cArray2[4] != 'm' && cArray2[4] != 'M' || cArray2[5] != 'n' && cArray2[5] != 'N')) {
                object = bufferedReader.readLine().trim();
                if (((String)object).indexOf("</column>") < 0) continue;
                int n5 = ((String)object).indexOf("id=");
                if (n5 < 0) {
                    return;
                }
                n5 = ((String)object).indexOf(34, n5) + 1;
                n = ((String)object).indexOf(34, n5);
                string2 = ((String)object).substring(n5, n);
                n5 = ((String)object).indexOf("type=");
                if (n5 < 0) {
                    return;
                }
                n5 = ((String)object).indexOf(34, n5) + 1;
                n = ((String)object).indexOf(34, n5);
                String string4 = ((String)object).substring(n5, n);
                n5 = ((String)object).indexOf(62, n) + 1;
                n = ((String)object).indexOf(60, n5);
                string = ((String)object).substring(n5, n);
                String string5 = XmlString.decode(string);
                Variant variant = null;
                switch (Variant.toType(string4)) {
                    case 3: {
                        variant = new Variant(Integer.parseInt(string5));
                        break;
                    }
                    case 5: {
                        variant = new Variant(Double.parseDouble(string5));
                        break;
                    }
                    case 8: {
                        variant = new Variant(string5);
                        break;
                    }
                    case 13: {
                        variant = new Variant(Base64Converter.decode(string5));
                        break;
                    }
                    case 7: {
                        try {
                            if (string5.length() == 8) {
                                if (this.defaultShortDateFormat == null) {
                                    this.defaultShortDateFormat = new SimpleDateFormat("yyyyMMdd");
                                }
                                variant = new Variant(this.defaultShortDateFormat.parse(string5));
                                break;
                            }
                            if (this.defaultDateFormat == null) {
                                this.defaultDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                            }
                            variant = new Variant(this.defaultDateFormat.parse(string5));
                        }
                        catch (ParseException parseException) {
                            variant = new Variant(string5);
                        }
                        break;
                    }
                    default: {
                        variant = new Variant(string5);
                    }
                }
                this.constColumnList.add(new Variable(string2, variant));
                continue;
            }
            if (!(cArray2[0] != 'r' && cArray2[0] != 'R' || cArray2[1] != 'e' && cArray2[1] != 'E' || cArray2[2] != 'c' && cArray2[2] != 'C' || cArray2[3] != 'o' && cArray2[3] != 'O' || cArray2[4] != 'r' && cArray2[4] != 'R' || cArray2[5] != 'd' && cArray2[5] != 'D')) {
                object = bufferedReader.readLine().trim();
                Record record = new Record(this);
                n = ((String)object).indexOf("type=");
                if (n > 0) {
                    int n6;
                    int n7 = ((String)object).indexOf(34, n) + 1;
                    string = ((String)object).substring(n7, n6 = ((String)object).indexOf(34, n7));
                    if (string.equalsIgnoreCase("update")) {
                        record.setRowType((short)4);
                    } else if (string.equalsIgnoreCase("delete")) {
                        record.setRowType((short)8);
                    } else if (string.equalsIgnoreCase("insert")) {
                        record.setRowType((short)2);
                    }
                }
                record.readFrom(bufferedReader, this.columnInfoList);
                if (record.getRowType() == 8) {
                    this.originalRecordList.add(record);
                } else {
                    this.recordList.add(record);
                }
                object = record.getLastLine();
                if (object == null) {
                    object = bufferedReader.readLine().trim();
                }
                if (!((String)object).equalsIgnoreCase("<org_record>")) continue;
                Record record2 = new Record(this);
                record2.readFrom(bufferedReader, this.columnInfoList);
                this.originalRecordList.add(record2);
                record.setOriginalIndex((short)(this.originalRecordList.size() - 1));
                object = record.getLastLine();
                if (object != null) continue;
                object = bufferedReader.readLine().trim();
                continue;
            }
            if (!(cArray2[0] != 'c' && cArray2[0] != 'C' || cArray2[1] != 'o' && cArray2[1] != 'O' || cArray2[2] != 'l' && cArray2[2] != 'L' || cArray2[3] != 'i' && cArray2[3] != 'I' || cArray2[4] != 'n' && cArray2[4] != 'N' || cArray2[5] != 'f' && cArray2[5] != 'F' || cArray2[6] != 'o' && cArray2[6] != 'O')) {
                object = new ColumnInfo();
                ((ColumnInfo)object).readFrom(bufferedReader);
                this.changeColumnInfo((ColumnInfo)object);
                this.columnInfoList.add((ColumnInfo)object);
                continue;
            }
            if (!(cArray2[0] != 'd' && cArray2[0] != 'D' || cArray2[1] != 'a' && cArray2[1] != 'A' || cArray2[2] != 't' && cArray2[2] != 'T' || cArray2[3] != 'a' && cArray2[3] != 'A' || cArray2[4] != 's' && cArray2[4] != 'S' || cArray2[5] != 'e' && cArray2[5] != 'E' || cArray2[6] != 't' && cArray2[6] != 'T')) {
                object = bufferedReader.readLine().trim();
                int n8 = ((String)object).indexOf("id=");
                if (n8 < 0) {
                    return;
                }
                n8 = ((String)object).indexOf(34, n8) + 1;
                n = ((String)object).indexOf(34, n8);
                this.id = string2 = ((String)object).substring(n8, n);
                continue;
            }
            if (!(cArray2[0] != '/' && cArray2[0] != '/' || cArray2[1] != 'd' && cArray2[1] != 'D' || cArray2[2] != 'a' && cArray2[2] != 'A' || cArray2[3] != 't' && cArray2[3] != 'T' || cArray2[4] != 'a' && cArray2[4] != 'A' || cArray2[5] != 's' && cArray2[5] != 'S' || cArray2[6] != 'e' && cArray2[6] != 'E' || cArray2[7] != 't' && cArray2[7] != 'T')) break;
        }
        bufferedReader.readLine();
    }

    public void readFrom(InputStream inputStream) throws IOException {
        this.readFrom(new DataInputStream(inputStream));
    }

    public void readFrom(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        if (s2 >= 4000) {
            if (s != -511) {
                throw new IOException("Dataset\uc758 \ud45c\uc2dc \uc624\ub958, mark=0x" + Integer.toHexString(s));
            }
            n2 = dataInputStream.readByte();
            if ((n2 & 0x80) != 0) {
                int n3 = n2 << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                n3 &= Integer.MAX_VALUE;
            } else {
                dataInputStream.readByte();
            }
        } else if (s2 >= 3100) {
            if (s != -255) {
                throw new IOException("Dataset\uc758 \ud45c\uc2dc \uc624\ub958, mark=0x" + Integer.toHexString(s));
            }
            n2 = dataInputStream.readInt();
            String string = Codepage.codepageToCharset(n2);
            if (Codepage.isSupportedCharset(string)) {
                this.charset = string;
            }
        }
        n2 = dataInputStream.readShort();
        byte[] byArray = new byte[n2];
        for (int i = 0; i < byArray.length && (n = dataInputStream.read(byArray, i, byArray.length - i)) > 0; i += n) {
        }
        this.id = s2 >= 4000 ? new String(byArray, "utf-8") : (this.charset == null ? new String(byArray) : new String(byArray, this.charset));
        this.constColumnList.readFrom(dataInputStream, this.charset);
        if (s2 >= 4000) {
            this.columnInfoList.readFrom(dataInputStream, this.charset, s2);
            this.changeColumnInfoList(this.columnInfoList);
            this.readRecordFromStream400(dataInputStream);
        } else {
            this.columnInfoList.readFrom(dataInputStream, this.charset);
            this.changeColumnInfoList(this.columnInfoList);
            this.readRecordFromStream310(dataInputStream);
        }
    }

    void readRecordFromStream400(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        while (true) {
            int n2 = 0;
            byte by = dataInputStream.readByte();
            if ((by & 0x80) != 0) {
                n2 = by << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                n2 &= Integer.MAX_VALUE;
            } else {
                n2 = by << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
            }
            short s = dataInputStream.readShort();
            if (n2 == 0 && s == 0) break;
            short s2 = dataInputStream.readShort();
            Record record = new Record(this);
            record.readFromStream400(dataInputStream, this.charset, s2, s, n, this);
            if (record.getRowType() == 8) {
                this.originalRecordList.add(record);
            } else {
                this.recordList.add(record);
                if (record.getRowType() == 4) {
                    short s3 = dataInputStream.readShort();
                    record.setOriginalIndex(s3);
                    if (record.getOriginalIndex() != -1) {
                        Record record2 = new Record(this);
                        record2.readFromStream400(dataInputStream, this.charset, s2, s, n, this);
                        this.originalRecordList.add(record2);
                        record.setOriginalIndex((short)(this.originalRecordList.size() - 1));
                    }
                }
            }
            ++n;
        }
    }

    void readRecordFromStream310(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = dataInputStream.readInt();
        if (n5 == 0) {
            return;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            Record record = new Record(this);
            record.readFrom(dataInputStream, this.charset, n4, this);
            if (record.getRowType() == 8) {
                this.originalRecordList.add(record);
                continue;
            }
            this.recordList.add(record);
            if (record.getRowType() != 4 || record.getOriginalIndex() == -1) continue;
            Record record2 = new Record(this);
            record2.readFrom(dataInputStream, this.charset, n4, this);
            this.originalRecordList.add(record2);
        }
        if (dataInputStream.available() == 0) {
            return;
        }
        n4 = dataInputStream.read();
        if ((n4 | (n3 = dataInputStream.read()) | (n2 = dataInputStream.read()) | (n = dataInputStream.read())) < 0) {
            return;
        }
        int n6 = (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
        if (n6 != 0) {
            int n7;
            for (n7 = 0; n7 < n6; ++n7) {
                Record record = new Record(this);
                record.readFrom(dataInputStream, this.charset, n7, this);
                this.originalRecordList.add(record);
            }
            n7 = dataInputStream.readInt();
            if (n7 != 0) {
                throw new IOException("\uc0ad\uc81c Record\uc758 \ub05d \uc624\ub958, n=0x" + Integer.toHexString(n7));
            }
        }
    }

    public void readFrom2(InputStream inputStream, short s) throws IOException {
        this.readFrom2(new DataInputStream(inputStream), s);
    }

    public void readFrom2(DataInputStream dataInputStream) throws IOException {
        this.readFrom2(dataInputStream, dataInputStream.readShort());
    }

    public void readFrom2(DataInputStream dataInputStream, short s) throws IOException {
        int n;
        int n2;
        if (s != -511) {
            throw new IOException("Dataset\uc758 \ud45c\uc2dc \uc624\ub958, mark=0x" + Integer.toHexString(s));
        }
        dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        byte[] byArray = new byte[s2];
        for (n = 0; n < byArray.length && (n2 = dataInputStream.read(byArray, n, byArray.length - n)) > 0; n += n2) {
        }
        this.id = new String(byArray, "utf-8");
        this.constColumnList.readFrom(dataInputStream, "utf-8");
        this.columnInfoList.readFrom2(dataInputStream);
        this.changeColumnInfoList(this.columnInfoList);
        n = dataInputStream.readInt();
        if (n == 0) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            Record record = new Record(this);
            record.readFrom2(dataInputStream, n2, this);
            if (record.getRowType() == 8) {
                this.originalRecordList.add(record);
                continue;
            }
            this.recordList.add(record);
            if (record.getRowType() != 4 || record.getOriginalIndex() == -1) continue;
            Record record2 = new Record(this);
            record2.readFrom2(dataInputStream, n2, this);
            this.originalRecordList.add(record2);
            record.setOriginalIndex((short)(this.originalRecordList.size() - 1));
        }
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, (short)5);
    }

    public void writeTo(Writer writer, short s) throws IOException {
        this.writeTo(writer, s, true);
    }

    public void writeTo(Writer writer, short s, boolean bl) throws IOException {
        Record record;
        PrintWriter printWriter = (PrintWriter)writer;
        printWriter.print("\t");
        printWriter.println("<dataset id=\"" + this.id + "\">");
        this.constColumnList.writeTo(printWriter, bl);
        this.columnInfoList.setWriteOrder(this.getColumnWriteOrder());
        this.columnInfoList.writeTo(printWriter);
        Iterator iterator = this.recordList.iterator();
        Format[] formatArray = new Format[]{new DecimalFormat(this.DECIMAL_FORMATS[this.getDecimalPlace()]), new SimpleDateFormat("yyyyMMddHHmmss")};
        int n = 0;
        while (iterator.hasNext()) {
            record = (Record)iterator.next();
            if (record != null) {
                short s2 = record.getRowType();
                if (s != 4 || s2 == 2 || s2 == 4) {
                    if (s != 5) {
                        if (s2 == 4) {
                            printWriter.print("\t");
                            printWriter.print("\t");
                            printWriter.print("<record ");
                            printWriter.println("type=\"update\">");
                        } else if (s2 == 2) {
                            printWriter.print("<record ");
                            printWriter.println("type=\"insert\">");
                        } else {
                            printWriter.print("\t");
                            printWriter.print("\t");
                            printWriter.println("<record>");
                        }
                    } else {
                        printWriter.print("\t");
                        printWriter.print("\t");
                        printWriter.println("<record>");
                    }
                    record.writeTo(printWriter, this.columnInfoList, bl, formatArray);
                    if (s != 5 && s2 == 4 && record.getOriginalIndex() >= 0 && record.getOriginalIndex() < this.originalRecordList.size()) {
                        printWriter.print("\t");
                        printWriter.print("\t");
                        printWriter.print("\t");
                        printWriter.println("<org_record>");
                        Record record2 = (Record)this.originalRecordList.get(record.getOriginalIndex());
                        record2.writeTo(printWriter, this.columnInfoList, bl, formatArray);
                        printWriter.print("\t");
                        printWriter.print("\t");
                        printWriter.print("\t");
                        printWriter.println("</org_record>");
                    }
                    printWriter.print("\t");
                    printWriter.print("\t");
                    printWriter.println("</record>");
                }
            }
            ++n;
        }
        if ((s == 6 || s == 7) && (n = this.getDeleteRowCount()) > 0) {
            iterator = this.originalRecordList.iterator();
            while (iterator.hasNext()) {
                record = (Record)iterator.next();
                if (record == null || record.getRowType() != 8) continue;
                printWriter.print("\t");
                printWriter.print("\t");
                printWriter.print("<record ");
                printWriter.println("type=\"delete\">");
                record.writeTo(printWriter, this.columnInfoList, bl, formatArray);
                printWriter.print("\t");
                printWriter.print("\t");
                printWriter.println("</record>");
            }
        }
        printWriter.print("\t");
        printWriter.println("</dataset>");
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        this.writeTo(dataOutputStream, (short)3000, (short)5);
    }

    public void writeTo(DataOutputStream dataOutputStream, short s) throws IOException {
        this.writeTo(dataOutputStream, s, (short)5);
    }

    public void writeTo(DataOutputStream dataOutputStream, short s, short s2) throws IOException {
        this.writeTo(dataOutputStream, s, s2, true);
    }

    public void writeTo(DataOutputStream dataOutputStream, short s, short s2, boolean bl) throws IOException {
        int n;
        Object object;
        if (s >= 4000) {
            dataOutputStream.writeShort(-511);
        } else {
            dataOutputStream.writeShort(-255);
        }
        dataOutputStream.writeShort(s);
        if (s < 4000) {
            dataOutputStream.writeInt(Codepage.charsetToCodepage(this.charset));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        if (s >= 4000) {
            byArray = this.id.getBytes("utf-8");
            if (Platform.isDebug() && log.isTraceEnabled()) {
                log.trace((Object)("Dataset id=" + this.id + ", length=" + byArray.length + ", charset=" + "utf-8" + ", v4000"));
            }
        } else {
            byte[] byArray2 = byArray = this.charset == null ? this.id.getBytes() : this.id.getBytes(this.charset);
            if (Platform.isDebug() && log.isTraceEnabled()) {
                log.trace((Object)("Dataset id=" + this.id + ", length=" + byArray.length + ", charset=" + "utf-8" + ", v3100"));
            }
        }
        dataOutputStream2.writeShort(byArray.length);
        dataOutputStream2.write(byArray);
        this.constColumnList.writeTo(dataOutputStream2, this.charset, s);
        this.columnInfoList.writeTo(dataOutputStream2, this.charset, s);
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        if (s >= 4000) {
            if (byArray3.length < 32768) {
                dataOutputStream.writeShort(byArray3.length);
            } else {
                dataOutputStream.writeInt(byArray3.length | Integer.MIN_VALUE);
            }
        }
        dataOutputStream.write(byArray3);
        int n2 = 0;
        n2 = s2 == 7 ? this.getUpdateRowCount() : this.recordList.size();
        if (n2 > 0) {
            if (s < 4000) {
                dataOutputStream.writeInt(n2);
            }
            Iterator iterator = this.recordList.iterator();
            while (iterator.hasNext()) {
                object = (Record)iterator.next();
                if (s2 == 5) {
                    ((Record)object).setRowType((short)1);
                    ((Record)object).writeTo(dataOutputStream, this.charset, s, this);
                    continue;
                }
                short s3 = ((Record)object).getRowType();
                if (s2 == 7 && s3 != 2 && s3 != 4) continue;
                ((Record)object).writeTo(dataOutputStream, this.charset, s, this);
                if (s3 != 4) continue;
                short s4 = ((Record)object).getOriginalIndex();
                if (s >= 4000) {
                    dataOutputStream.writeShort(s4);
                }
                Record record = (Record)this.originalRecordList.get(s4);
                record.writeTo(dataOutputStream, this.charset, s, this);
            }
        }
        if (s < 4000 && (s2 == 6 || s2 == 7) && (n = this.getDeleteRowCount()) > 0) {
            dataOutputStream.writeInt(n);
            object = this.originalRecordList.iterator();
            while (object.hasNext()) {
                Record record = (Record)object.next();
                if (record == null || record.getRowType() != 8) continue;
                record.writeTo(dataOutputStream, this.charset, s, this);
            }
        }
        if (bl) {
            dataOutputStream.writeInt(0);
        }
    }

    public void writeTo(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        int n3 = this.recordList.size();
        if (n >= n3 || n2 == 0) {
            return;
        }
        if (n2 > 0 && n + n2 < n3) {
            n3 = n + n2;
        }
        dataOutputStream.writeInt(n3 - n);
        Iterator iterator = this.recordList.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            record.writeTo(dataOutputStream, this.charset, this);
        }
    }

    public void writeTo(DataOutputStream dataOutputStream, int n, int n2, short s) throws IOException {
        int n3;
        Object object;
        if (s < 4000) {
            this.writeTo(dataOutputStream, n, n2);
            return;
        }
        int n4 = 5;
        int n5 = 0;
        n5 = n4 == 7 ? this.getUpdateRowCount() : this.recordList.size();
        if (n5 > 0) {
            if (s < 4000) {
                dataOutputStream.writeInt(n5);
            }
            Iterator iterator = this.recordList.iterator();
            while (iterator.hasNext()) {
                object = (Record)iterator.next();
                if (n4 == 5) {
                    ((Record)object).setRowType((short)1);
                    ((Record)object).writeTo(dataOutputStream, this.charset, s, this);
                    continue;
                }
                short s2 = ((Record)object).getRowType();
                if (n4 == 7 && s2 != 2 && s2 != 4) continue;
                ((Record)object).writeTo(dataOutputStream, this.charset, s, this);
                if (s2 != 4) continue;
                short s3 = ((Record)object).getOriginalIndex();
                if (s >= 4000) {
                    dataOutputStream.writeShort(s3);
                }
                Record record = (Record)this.originalRecordList.get(s3);
                record.writeTo(dataOutputStream, this.charset, s, this);
            }
        }
        if (s < 4000 && (n4 == 6 || n4 == 7) && (n3 = this.getDeleteRowCount()) > 0) {
            dataOutputStream.writeInt(n3);
            object = this.originalRecordList.iterator();
            while (object.hasNext()) {
                Record record = (Record)object.next();
                if (record == null || record.getRowType() != 8) continue;
                record.writeTo(dataOutputStream, this.charset, s, this);
            }
        }
    }

    public void writeTo2(DataOutputStream dataOutputStream) throws IOException {
        this.writeTo2(dataOutputStream, (short)3000, (short)5);
    }

    public void writeTo2(DataOutputStream dataOutputStream, short s) throws IOException {
        this.writeTo2(dataOutputStream, s, (short)5);
    }

    public void writeTo2(DataOutputStream dataOutputStream, short s, short s2) throws IOException {
        int n;
        Object object;
        dataOutputStream.writeShort(-511);
        dataOutputStream.writeShort(s);
        byte[] byArray = this.id.getBytes("utf-8");
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
        this.constColumnList.writeTo(dataOutputStream, "utf-8", s);
        this.columnInfoList.writeTo2(dataOutputStream, s);
        int n2 = 0;
        n2 = s2 == 7 ? this.getUpdateRowCount() : this.recordList.size();
        if (n2 > 0) {
            dataOutputStream.writeInt(n2);
            ListIterator listIterator = this.recordList.listIterator();
            while (listIterator.hasNext()) {
                object = (Record)listIterator.next();
                if (s2 == 5) {
                    ((Record)object).setRowType((short)1);
                    ((Record)object).writeTo2(dataOutputStream, this);
                    continue;
                }
                short s3 = ((Record)object).getRowType();
                if (s2 == 7 && s3 != 2 && s3 != 4) continue;
                ((Record)object).writeTo2(dataOutputStream, this);
                if (s3 != 4) continue;
                ((Record)this.originalRecordList.get(((Record)object).getOriginalIndex())).writeTo2(dataOutputStream, this);
            }
        }
        if ((s2 == 6 || s2 == 7) && (n = this.getDeleteRowCount()) > 0) {
            object = this.originalRecordList.iterator();
            while (object.hasNext()) {
                Record record = (Record)object.next();
                if (record == null || record.getRowType() != 8) continue;
                record.writeTo2(dataOutputStream, this);
            }
        }
    }

    public String toString() {
        return this.toString(true, true);
    }

    String toString(boolean bl, boolean bl2) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Dataset");
        stringBuffer.append('[');
        stringBuffer.append(string);
        stringBuffer.append("    ").append("id=").append(this.getId());
        if (bl) {
            stringBuffer.append(string);
            stringBuffer.append("    ").append("const column=").append(this.getConstColumnList());
            stringBuffer.append(string);
            stringBuffer.append("    ").append("column=").append(this.getColumnInfoList());
        }
        if (bl2) {
            int n;
            stringBuffer.append(string);
            int n2 = this.recordList == null ? 0 : this.recordList.size();
            for (n = 0; n < n2; ++n) {
                Record record = (Record)this.recordList.get(n);
                if (n > 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("    ").append("record[").append(n).append("]=").append(record);
            }
            n = this.originalRecordList == null ? 0 : this.originalRecordList.size();
            for (int i = 0; i < n; ++i) {
                Record record = (Record)this.originalRecordList.get(i);
                if (i > 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("    ").append("original record[").append(i).append("]=").append(record);
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void dump() {
        this.dumpSimpleType(0);
        System.out.print("\n");
        this.dumpComplexType(0, false);
    }

    public void dumpSimpleType(int n) {
        this.printIndent(n);
        System.out.println("> DATASET_ID \t\t= " + this.id);
        this.printIndent(n);
        System.out.println("> CHARSET \t\t= " + this.charset);
        this.printIndent(n);
        System.out.println("> INSERTED RECORD COUNT = " + this.insertedCount);
        if (this.isUpdating) {
            this.printIndent(n);
            System.out.println("> UPDATE STATUS \t= UPDATE");
        } else {
            this.printIndent(n);
            System.out.println("> UPDATE STATUS \t= NORMAL");
        }
        this.printIndent(n);
        System.out.println("> FILTER STATUS \t= ");
    }

    public void dumpComplexType(int n, boolean bl) {
        this.printIndent(n);
        System.out.println("{COLUMN_INFO LIST}");
        this.dumpColumnList(n + 4, bl);
        System.out.print("\n");
        this.printIndent(n);
        System.out.println("{RECORD LIST}");
        this.dumpRecList(n + 4, this.recordList, bl);
        System.out.print("\n");
        this.printIndent(n);
        System.out.println("{ORG_RECORD LIST}");
        this.dumpRecList(n + 4, this.originalRecordList, bl);
    }

    public void dumpColumnList(int n, boolean bl) {
        int n2 = this.columnInfoList.size();
        for (int i = 0; i < n2; ++i) {
            ColumnInfo columnInfo = this.columnInfoList.getColumnInfo(i);
            if (columnInfo == null) {
                this.printIndent(n);
                if (bl) {
                    System.out.println("[" + i + "|NULL]");
                    continue;
                }
                System.out.println("[" + i + "]");
                continue;
            }
            String string = columnInfo.getColumnTypeStr();
            this.printIndent(n);
            if (bl) {
                System.out.println("[" + i + ":addr] --> [" + columnInfo.getColumnID() + " | " + string + " | orgidx]");
                continue;
            }
            System.out.println("[" + i + "] --> [" + columnInfo.getColumnID() + " | " + string + " | orgidx]");
        }
    }

    public void dumpRecList(int n, List list, boolean bl) {
        if (list == null || list.size() <= 0) {
            this.printIndent(n);
            System.out.print("NULL");
            return;
        }
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Record record = (Record)list.get(i);
            if (record == null) {
                this.printIndent(n);
                if (bl) {
                    System.out.println("[" + i + ":NULL]");
                    continue;
                }
                System.out.println("[" + i + "]");
                continue;
            }
            this.printIndent(n);
            if (bl) {
                System.out.println("[" + i + ":addr] --> ");
            } else {
                System.out.println("[" + i + "] -->");
            }
            this.dumpRecord(n + 4, record, bl);
        }
    }

    public void dumpRecord(int n, Object object, boolean bl) {
        if (object == null) {
            return;
        }
        Record record = (Record)object;
        String string = null;
        string = record.getRowType() == 0 ? new String("EMPTY") : (record.getRowType() == 1 ? new String("NORMAL") : (record.getRowType() == 2 ? new String("INSERT") : (record.getRowType() == 4 ? new String("UPDATE") : (record.getRowType() == 8 ? new String("DELETE") : (record.getRowType() == 16 ? new String("LOGICAL") : (record.getRowType() == 256 ? new String("FILTER") : (record.getRowType() == 4096 ? new String("SELECT") : new String("UNKNOWN"))))))));
        this.printIndent(n);
        System.out.println("> TYPE = " + string);
        this.printIndent(n);
        System.out.println("> ORGIDX = " + record.getOrgIdx());
        for (int i = 0; i < record.getColumnCount(); ++i) {
            Variant variant = record.getColumn(i);
            if (variant == null) {
                this.printIndent(n);
                if (bl) {
                    System.out.println("[" + i + ":NULL]");
                    continue;
                }
                System.out.println("[" + i + "]");
                continue;
            }
            String string2 = null;
            string2 = variant.getType() == 8 || variant.getType() == 3 || variant.getType() == 5 || variant.getType() == 7 || variant.getType() == 6 || variant.getType() == 13 ? new String(variant.toString()) : new String("OTHER TYPE");
            this.printIndent(n);
            if (bl) {
                System.out.println("[" + i + ":adr] --> [" + string2 + "]");
                continue;
            }
            System.out.println("[" + i + "] --> [" + string2 + "]");
        }
    }

    private void printIndent(int n) {
        char c = ' ';
        for (int i = 0; i < n; ++i) {
            System.out.print(c);
        }
    }

    public void printDataset() throws IOException {
        this.printDataset(true, true, true);
    }

    public void printDataset(boolean bl, boolean bl2, boolean bl3) throws IOException {
        Dataset.printDataset(this, bl, bl2, bl3);
    }

    public static void printDataset(Dataset dataset, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Dataset.printDataset(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, dataset.getCharset())), dataset, bl, bl2, bl3, 0);
    }

    public static void printDataset(OutputStream outputStream, Dataset dataset, boolean bl, boolean bl2, boolean bl3, int n) throws IOException {
        Dataset.printDataset(new BufferedWriter(new OutputStreamWriter(outputStream, dataset.getCharset())), dataset, bl, bl2, bl3, n);
    }

    public static void printDataset(Writer writer, Dataset dataset, boolean bl, boolean bl2, boolean bl3, int n) throws IOException {
        int n2;
        String string = "";
        if (n > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                string = string + "\t";
            }
        }
        if (dataset == null) {
            writer.write(string + "@@@ Dataset : null\n");
            writer.flush();
            return;
        }
        writer.write(string + "@@@ Dataset : ID = \"" + dataset.getId() + "\", Column size = " + dataset.getColumnCount() + ", Constant column size = " + dataset.getConstColumnCount() + ", Record size = " + dataset.getRowCount() + "\n");
        if (bl) {
            writer.write(string + "\t>>> Column list\n");
            for (n2 = 0; n2 < dataset.getColumnCount(); ++n2) {
                if (n2 < dataset.getColumnCount() - dataset.getConstColumnCount()) {
                    ColumnInfo columnInfo = null;
                    columnInfo = bl3 ? dataset.getColumnInfo(n2) : dataset.getColumnInfoByOrder(n2);
                    if (columnInfo == null) {
                        writer.write(string + "\t--- ERROR : Column info is null\n");
                        writer.flush();
                        return;
                    }
                    if (columnInfo.IsSummary()) {
                        writer.write(string + "\t\t[" + n2 + "]<NORMAL> : ID = \"" + columnInfo.getColumnID() + "\", Type = <" + columnInfo.getColumnTypeStr() + ">, SIZE = [" + columnInfo.getColumnSize() + "], SUMMARY = <" + columnInfo.getSummaryTypeStr() + ">");
                        if (columnInfo.getSummaryType() == 96) {
                            writer.write(", SUMMARY TEXT = {" + columnInfo.getSummaryText() + "}\n");
                            continue;
                        }
                        writer.write("\n");
                        continue;
                    }
                    writer.write(string + "\t\t[" + n2 + "]<NORMAL> : ID = \"" + columnInfo.getColumnID() + "\", Type = <" + columnInfo.getColumnTypeStr() + ">, SIZE = [" + columnInfo.getColumnSize() + "]\n");
                    continue;
                }
                writer.write(string + "\t\t[" + n2 + "]<CONSTANT> : ID = \"" + dataset.getColumnID(n2) + "\", Type = <" + dataset.getColumn(1, dataset.getColumnID(n2)).getTypeName() + ">\n");
            }
        }
        if (bl2) {
            writer.write(string + "\t>>> Record list\n");
            for (n2 = 0; n2 < dataset.getRowCount(); ++n2) {
                writer.write(string + "\t\t=== Record[" + n2 + "]\n");
                for (int i = 0; i < dataset.getColumnCount(); ++i) {
                    if (i < dataset.getColumnCount() - dataset.getConstColumnCount()) {
                        ColumnInfo columnInfo = null;
                        columnInfo = bl3 ? dataset.getColumnInfo(i) : dataset.getColumnInfoByOrder(i);
                        if (columnInfo == null) {
                            writer.write(string + "\t--- ERROR : Column info is null\n");
                            writer.flush();
                            return;
                        }
                        if (bl3) {
                            writer.write(string + "\t\t\t[" + i + "]<NORMAL> : ID = \"" + columnInfo.getColumnID() + "\", Type = <" + columnInfo.getColumnTypeStr() + ">, Value = {" + dataset.getColumn(n2, i) + "}\n");
                            continue;
                        }
                        writer.write(string + "\t\t\t[" + i + "]<NORMAL> : ID = \"" + columnInfo.getColumnID() + "\", Type = <" + columnInfo.getColumnTypeStr() + ">, Value = {" + dataset.getColumnByOrder(n2, i) + "}\n");
                        continue;
                    }
                    writer.write(string + "\t\t\t[" + i + "]<CONSTANT> : ID = \"" + dataset.getColumnID(i) + "\", Type = <" + dataset.getColumn(n2, i).getTypeName() + ">, Value = {" + dataset.getColumn(n2, i) + "}\n");
                }
            }
        }
        writer.flush();
    }

    private void init(String string, String string2, boolean bl, boolean bl2) {
        this.columnWriteOrder = 1;
        this.isUpdating = false;
        this.insertedCount = 0;
        this.charset = Codepage.isSupportedCharset(string2) ? string2 : Codepage.getDefaultCharset();
        this.id = string;
        this.columnInfoList = new ColumnInfoList(bl2);
        this.constColumnList = new ConstColumnList(bl);
        this.recordList = new ArrayList();
        this.originalRecordList = new ArrayList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

