/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import java.math.BigDecimal;

public class Currency
extends BigDecimal {
    public Currency() {
        super(0.0);
    }

    public Currency(BigDecimal bigDecimal) {
        super(bigDecimal == null ? 0.0 : bigDecimal.doubleValue());
    }

    public Currency(double d) {
        super(d);
    }

    public Currency(float f) {
        super(f);
    }

    public Currency(String string) {
        super(string);
    }

    public boolean equals(float f) {
        return this.compareTo(new Currency(f)) == 0;
    }

    public boolean equals(double d) {
        return this.compareTo(new Currency(d)) == 0;
    }

    public Currency add(Currency currency) {
        return new Currency(super.add(currency));
    }

    public Currency subtract(Currency currency) {
        return new Currency(super.subtract(currency));
    }

    public Currency multiply(Currency currency) {
        return new Currency(super.multiply(currency));
    }

    public Currency multiply(int n) {
        return this.multiply(new Currency((float)n));
    }

    public Currency divide(Currency currency) throws ArithmeticException, IllegalArgumentException {
        return new Currency(super.divide((BigDecimal)currency, 4, 4));
    }

    public Currency divide(int n) throws ArithmeticException, IllegalArgumentException {
        return this.divide(new Currency((double)n));
    }

    public Currency absCurrency() {
        return this.signum() < 0 ? this.negateCurrency() : this;
    }

    public Currency negateCurrency() {
        return new Currency(this.negate());
    }

    public String toString() {
        return this.scale() == 4 ? super.toString() : this.setScale(4, 4).toString();
    }

    public static Currency fromInt64(int n, int n2) {
        long l = 0xFFFFFFFFL & (long)n;
        long l2 = 0xFFFFFFFFL & (long)n2;
        long l3 = l << 32 | l2;
        String string = Long.toString(l3);
        int n3 = string.length();
        if (n3 < 4) {
            return new Currency(0.0f);
        }
        string = n3 == 4 ? "0." + string : string.substring(0, n3 - 4) + "." + string.substring(n3 - 4);
        return new Currency(string);
    }

    public static int[] toInt64(Currency currency) {
        int[] nArray = new int[2];
        String string = currency.toString();
        int n = string.indexOf(46);
        if (n >= 0) {
            string = string.substring(0, n) + string.substring(n + 1, string.length());
        }
        long l = Long.parseLong(string);
        nArray[0] = (int)(l >> 32);
        nArray[1] = (int)(0xFFFFFFFFL & l);
        return nArray;
    }
}

