/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.data.Variable;
import com.tobesoft.platform.data.Variant;
import com.tobesoft.platform.util.Base64Converter;
import com.tobesoft.platform.util.Codepage;
import com.tobesoft.platform.util.XmlString;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class ConstColumnList
implements Serializable {
    private List columnList = new ArrayList();
    private boolean isSorting;
    private Locale locale;

    public ConstColumnList() {
        this(true);
    }

    public ConstColumnList(boolean bl) {
        this.isSorting = bl;
    }

    public Variable get(int n) {
        return (Variable)this.columnList.get(n);
    }

    public int add(Variable variable) {
        if (this.isSorting) {
            return this.addBySort(variable);
        }
        this.columnList.add(variable);
        return this.columnList.size() - 1;
    }

    public int indexOf(String string) {
        int n = this.columnList.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)this.columnList.get(i);
            if (variable == null || !variable.getId().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIgnoreCase(String string) {
        int n = this.columnList.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)this.columnList.get(i);
            if (variable == null || !variable.getId().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public int get(String string) {
        return this.indexOf(string);
    }

    public int getIndex(String string) {
        return this.indexOf(string);
    }

    public void clear() {
        this.columnList.clear();
    }

    public int size() {
        return this.columnList.size();
    }

    public Variant getVar(String string) {
        int n = this.columnList.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)this.columnList.get(i);
            if (variable == null || !variable.getId().equalsIgnoreCase(string)) continue;
            return variable.getValue();
        }
        return null;
    }

    public Variant getVar(int n) {
        Variable variable = this.get(n);
        return variable == null ? null : variable.getValue();
    }

    public int addVar(String string, Variant variant) {
        return this.add(new Variable(string, variant));
    }

    public int add(String string, Variant variant) {
        return this.addVar(string, variant);
    }

    public Iterator iterator() {
        return this.columnList.iterator();
    }

    public ListIterator getIterator() {
        return this.columnList.listIterator();
    }

    public void readFrom(InputStream inputStream, String string) throws IOException {
        this.readFrom(new DataInputStream(inputStream), string);
    }

    public void readFrom(DataInputStream dataInputStream, String string) throws IOException {
        int n;
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        if (s2 >= 4000) {
            if (s != -496) {
                throw new IOException("VariableList\uc758 \ud45c\uc2dc \uc624\ub958, mark=0x" + Integer.toHexString(s));
            }
            n = dataInputStream.readByte();
            if ((n & 0x80) != 0) {
                int n2 = n << 24 & 0xFF000000 | dataInputStream.readByte() << 16 & 0xFF0000 | dataInputStream.readByte() << 8 & 0xFF00 | dataInputStream.readByte() & 0xFF;
                n2 &= Integer.MAX_VALUE;
            } else {
                dataInputStream.readByte();
            }
        } else if (s2 >= 3100) {
            if (s != -240) {
                throw new IOException("VariableList\uc758 \ud45c\uc2dc \uc624\ub958, mark=0x" + Integer.toHexString(s));
            }
            n = dataInputStream.readUnsignedShort();
            String string2 = Codepage.codepageToCharset(n);
            if (Codepage.isSupportedCharset(string2)) {
                string = string2;
            }
        }
        n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5 = dataInputStream.readShort();
            byte[] byArray = new byte[n5];
            for (n3 = 0; n3 < n5 && (n4 = dataInputStream.read(byArray, n3, byArray.length - n3)) > 0; n3 += n4) {
            }
            if (n3 != n5) {
                throw new IOException("\uc0c1\uc218 \uc5f4\uc758 \uc2dd\ubcc4\uc790 \uc77d\uae30 \uc624\ub958, length=" + n5 + ", count=" + n3);
            }
            String string3 = new String(byArray);
            Variant variant = new Variant();
            variant.readFrom(dataInputStream, string, s2);
            this.add(new Variable(string3, variant));
        }
    }

    public void writeTo(Writer writer) {
        this.writeTo(writer, true);
    }

    public void writeTo(Writer writer, boolean bl) {
        PrintWriter printWriter = (PrintWriter)writer;
        int n = this.columnList.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = this.get(i);
            if (variable == null) continue;
            String string = variable.getValue().getTypeName();
            printWriter.print("\t");
            printWriter.print("\t");
            printWriter.print("<column");
            printWriter.print(" id=\"" + variable.getId() + "\" type=\"" + string + "\">");
            String string2 = string.equalsIgnoreCase("BINARY") ? Base64Converter.encode(variable.getValue().getBinary(), bl) : variable.getValue().asString();
            printWriter.print(XmlString.encode(string2));
            printWriter.println("</column>");
        }
    }

    public void writeTo(DataOutputStream dataOutputStream, String string) throws IOException {
        this.writeTo(dataOutputStream, string, (short)2000);
    }

    public void writeTo(DataOutputStream dataOutputStream, String string, short s) throws IOException {
        Object object;
        if (s >= 4000) {
            dataOutputStream.writeShort(-496);
            dataOutputStream.writeShort(s);
        } else if (s >= 3100) {
            dataOutputStream.writeShort(-240);
            dataOutputStream.writeShort(s);
            dataOutputStream.writeShort(Codepage.charsetToCodepage(string));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeShort(this.columnList.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            object = (Variable)iterator.next();
            String string2 = ((Variable)object).getId();
            dataOutputStream2.writeShort(string2.length());
            dataOutputStream2.write(string2.getBytes());
            ((Variable)object).getValue().writeTo(dataOutputStream2, string, s);
        }
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        object = byteArrayOutputStream.toByteArray();
        if (s >= 4000) {
            if (((Object)object).length < 32768) {
                dataOutputStream.writeShort(((Object)object).length);
            } else {
                dataOutputStream.writeInt(((Object)object).length | Integer.MIN_VALUE);
            }
        }
        dataOutputStream.write((byte[])object);
    }

    public String toString() {
        return "ConstColumnList[isSorting=" + this.isSorting + ", columnList=" + this.columnList + "]";
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    Locale getLocale() {
        return this.locale;
    }

    private int addBySort(Variable variable) {
        Collator collator;
        ListIterator listIterator = this.columnList.listIterator();
        Collator collator2 = collator = this.locale == null ? null : Collator.getInstance(this.locale);
        while (listIterator.hasNext()) {
            Variable variable2 = (Variable)listIterator.next();
            if (collator == null) {
                if (variable2.getId().compareToIgnoreCase(variable.getId()) <= 0) continue;
                int n = listIterator.previousIndex();
                this.columnList.add(n, variable);
                return n;
            }
            if (collator.compare(variable2.getId(), variable.getId()) <= 0) continue;
            int n = listIterator.previousIndex();
            this.columnList.add(n, variable);
            return n;
        }
        this.columnList.add(variable);
        return this.columnList.size() - 1;
    }
}

