/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.data.ColumnInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ColumnInfoList
implements Serializable {
    static final short CY_COLINFO_MARK = -248;
    static final short COLINFO_MARK = -248;
    static final short CY_COLINFO_VERSION = 2000;
    static final short COLINFO_VERSION = 2000;
    private List infoList = new ArrayList();
    private List sortedList = new ArrayList();
    private Map idMap;
    private Map ignoreCaseIdMap = new HashMap();
    private boolean isSorting;
    private int writeOrder;
    private boolean emptyColumn = true;
    private Locale locale;

    public ColumnInfoList() {
        this(false);
    }

    public ColumnInfoList(boolean bl) {
        this.idMap = new HashMap();
        this.isSorting = bl;
    }

    public ColumnInfo get(int n) {
        if (n < 0 || n >= this.infoList.size()) {
            return null;
        }
        return (ColumnInfo)this.infoList.get(n);
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    Locale getLocale() {
        return this.locale;
    }

    int getSortedIndex(int n) {
        if (this.isSorting) {
            return n;
        }
        if (n < 0 || n >= this.infoList.size()) {
            return -1;
        }
        this.checkSortedList();
        return (Integer)this.sortedList.get(n);
    }

    private void checkSortedList() {
        if (this.sortedList.isEmpty()) {
            int n = this.infoList.size();
            for (int i = 0; i < n; ++i) {
                ColumnInfo columnInfo = (ColumnInfo)this.infoList.get(i);
                String string = columnInfo.getId();
                boolean bl = false;
                for (int j = 0; j < i; ++j) {
                    int n2 = (Integer)this.sortedList.get(j);
                    ColumnInfo columnInfo2 = (ColumnInfo)this.infoList.get(n2);
                    if (string.compareToIgnoreCase(columnInfo2.getId()) >= 0) continue;
                    this.sortedList.add(j, new Integer(i));
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.sortedList.add(new Integer(i));
            }
        }
    }

    public ColumnInfo getColumnInfo(int n) {
        return this.get(n);
    }

    public int add(ColumnInfo columnInfo) {
        this.ignoreCaseIdMap.clear();
        this.idMap.clear();
        this.sortedList.clear();
        int n = this.infoList.size();
        columnInfo.setOrder(n);
        if (this.isSorting) {
            Collator collator = this.locale == null ? null : Collator.getInstance(this.locale);
            for (int i = 0; i < n; ++i) {
                String string = ((ColumnInfo)this.infoList.get(i)).getId();
                if (collator == null) {
                    if (columnInfo.getId().compareToIgnoreCase(string) >= 0) continue;
                    this.infoList.add(i, columnInfo);
                    return i;
                }
                if (collator.compare(columnInfo.getId(), string) >= 0) continue;
                this.infoList.add(i, columnInfo);
                return i;
            }
        }
        this.infoList.add(columnInfo);
        return n;
    }

    public int addColumnInfo(ColumnInfo columnInfo) {
        this.setFalseToEmptyColumnFlag();
        return this.add(columnInfo);
    }

    public int indexOf(String string) {
        Integer n;
        if (this.idMap.isEmpty()) {
            this.makeHash();
        }
        return (n = (Integer)this.idMap.get(string)) == null ? -1 : n;
    }

    public int indexOfIgnoreCase(String string) {
        if (this.idMap.isEmpty()) {
            this.makeHash();
        }
        String string2 = null;
        Set set = this.idMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !(string2 = (String)iterator.next()).equalsIgnoreCase(string)) {
        }
        return this.indexOf(string2);
    }

    public int getColumnIdx(String string) {
        return this.indexOf(string);
    }

    public boolean contains(String string) {
        if (this.idMap.isEmpty()) {
            this.makeHash();
        }
        return this.idMap.containsKey(string);
    }

    public boolean containsByIgnoreCase(String string) {
        if (this.ignoreCaseIdMap.isEmpty()) {
            this.makeHashByIgnoreCase();
        }
        return this.ignoreCaseIdMap.containsKey(string.toUpperCase());
    }

    public boolean containColumnId(String string) {
        return this.contains(string);
    }

    public boolean containColumnIdByIgnoreCase(String string) {
        return this.containsByIgnoreCase(string);
    }

    public int size() {
        return this.infoList.size();
    }

    public void clear() {
        this.infoList.clear();
        this.ignoreCaseIdMap.clear();
        this.idMap.clear();
        this.sortedList.clear();
        this.emptyColumn = true;
    }

    public void readFrom(InputStream inputStream, String string) throws IOException {
        this.readFrom(new DataInputStream(inputStream), string);
    }

    public void readFrom(DataInputStream dataInputStream, String string) throws IOException {
        short s = dataInputStream.readShort();
        if (s != -248) {
            throw new IOException("ColumnInfo\uc758 \ud45c\uc2dc \uc624\ub958, mark=0x" + Integer.toHexString(s));
        }
        this.readFrom(dataInputStream, string, dataInputStream.readShort());
    }

    void readFrom(DataInputStream dataInputStream, String string, short s) throws IOException {
        int n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.readFrom(dataInputStream, string, s);
            this.add(columnInfo);
        }
    }

    public void readFrom2(InputStream inputStream) throws IOException {
        this.readFrom2(new DataInputStream(inputStream));
    }

    public void readFrom2(DataInputStream dataInputStream) throws IOException {
        short s = dataInputStream.readShort();
        if (s != -248) {
            throw new IOException("ColumnInfo\uc758 \ud45c\uc2dc \uc624\ub958, mark=0x" + Integer.toHexString(s));
        }
        short s2 = dataInputStream.readShort();
        int n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.readFrom2(dataInputStream, s2);
            this.add(columnInfo);
        }
    }

    public void writeTo(Writer writer) throws IOException {
        PrintWriter printWriter = (PrintWriter)writer;
        int n = this.infoList.size();
        if (this.getWriteOrder() == 0) {
            int[] nArray = this.getIndexesByOrder();
            for (int i = 0; i < n; ++i) {
                ((ColumnInfo)this.infoList.get(nArray[i])).writeTo(printWriter);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ((ColumnInfo)this.infoList.get(i)).writeTo(printWriter);
            }
        }
    }

    public void writeTo(DataOutputStream dataOutputStream, String string) throws IOException {
        this.writeTo(dataOutputStream, string, (short)2000);
    }

    public void writeTo(DataOutputStream dataOutputStream, String string, short s) throws IOException {
        if (s < 4000) {
            dataOutputStream.writeShort(-248);
            dataOutputStream.writeShort(s);
        }
        int n = this.infoList.size();
        dataOutputStream.writeShort(n);
        if (this.getWriteOrder() == 0) {
            int[] nArray = this.getIndexesByOrder();
            for (int i = 0; i < n; ++i) {
                ((ColumnInfo)this.infoList.get(nArray[i])).writeTo(dataOutputStream, string, s);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ((ColumnInfo)this.infoList.get(i)).writeTo(dataOutputStream, string, s);
            }
        }
    }

    public void writeTo2(DataOutputStream dataOutputStream) throws IOException {
        this.writeTo2(dataOutputStream, (short)2000);
    }

    public void writeTo2(DataOutputStream dataOutputStream, short s) throws IOException {
        dataOutputStream.writeShort(-248);
        dataOutputStream.writeShort(s);
        int n = this.infoList.size();
        dataOutputStream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            ((ColumnInfo)this.infoList.get(i)).writeTo2(dataOutputStream, s);
        }
    }

    public String toString() {
        return "ColumnInfoList[isSorting=" + this.isSorting + ", writeOrder=" + this.getWriteOrder() + ", infoList=" + this.infoList + "]";
    }

    int getWriteOrder() {
        return this.writeOrder;
    }

    void setWriteOrder(int n) {
        this.writeOrder = n;
    }

    int[] getIndexesByOrder() {
        int n = this.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[this.get((int)i).getOrder()] = i;
        }
        return nArray;
    }

    private void makeHash() {
        int n = this.infoList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ColumnInfo columnInfo = (ColumnInfo)this.infoList.get(i);
                this.idMap.put(columnInfo.getId(), new Integer(i));
            }
        }
    }

    private void makeHashByIgnoreCase() {
        int n = this.infoList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ColumnInfo columnInfo = (ColumnInfo)this.infoList.get(i);
                this.ignoreCaseIdMap.put(columnInfo.getId().toUpperCase(), new Integer(i));
            }
        }
    }

    private void setFalseToEmptyColumnFlag() {
        this.emptyColumn = false;
    }

    public boolean isEmptyColumn() {
        return this.infoList.size() == 0;
    }
}

