/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform.data;

import com.tobesoft.platform.util.XmlString;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.StringTokenizer;

public class ColumnInfo
implements Serializable {
    public static final short COLUMN_TYPE_UNKNOWN = 0;
    public static final short COLUMN_TYPE_STRING = 1;
    public static final short COLUMN_TYPE_INT = 2;
    public static final short COLUMN_TYPE_DECIMAL = 4;
    public static final short COLUMN_TYPE_CURRENCY = 5;
    public static final short COLUMN_TYPE_DATE = 8;
    public static final short COLUMN_TYPE_BLOB = 9;
    public static final short COLUMN_TYPE_URL = 10;
    public static final short COLUMN_TYPE_LONG = 11;
    public static final short COLUMN_TYPE_CHAR = 12;
    public static final short COLUMN_TYPE_FILE = 13;
    public static final short COLUMN_PROPERTY_NORMAL = 1;
    public static final short COLUMN_PROPERTY_NOT_NULL = 2;
    public static final short COLUMN_PROPERTY_KEY = 3;
    public static final short COLUMN_PROPERTY_SEQUENCE = 4;
    public static final short COLUMN_PROPERTY_CONSTANT = 5;
    public static final short COLUMN_SUMMARY_DEFAULT = 0;
    public static final short COLUMN_SUMMARY_COUNT = 16;
    public static final short COLUMN_SUMMARY_SUM = 32;
    public static final short COLUMN_SUMMARY_MAX = 48;
    public static final short COLUMN_SUMMARY_MIN = 64;
    public static final short COLUMN_SUMMARY_AVG = 80;
    public static final short COLUMN_SUMMARY_TEXT = 96;
    static final short MARK_COLUMN_INFO = -248;
    static final short VERSION_COLUMN_INFO = 2000;
    static final int DEFAULT_TYPE_SIZE_STRING = 256;
    static final int DEFAULT_TYPE_SIZE_INT = 256;
    static final int DEFAULT_TYPE_SIZE_DECIMAL = 256;
    static final int DEFAULT_TYPE_SIZE_CURRENCY = 256;
    static final int DEFAULT_TYPE_SIZE_DATE = 256;
    static final int DEFAULT_TYPE_SIZE_BLOB = 256;
    static final int DEFAULT_TYPE_SIZE_FILE = 256;
    private String id;
    private short type;
    private int size;
    private int order;
    private short property;
    private String summaryText;
    public static final short COLTYPE_UNKNOWN = 0;
    public static final short COLTYPE_STRING = 1;
    public static final short COLTYPE_INT = 2;
    public static final short COLTYPE_DECIMAL = 4;
    public static final short COLTYPE_CURRENCY = 5;
    public static final short COLTYPE_DATE = 8;
    public static final short COLTYPE_BLOB = 9;
    public static final short COLTYPE_URL = 10;
    public static final short COLTYPE_LONG = 11;
    public static final short COLTYPE_CHAR = 12;
    public static final short COLTYPE_FILE = 13;
    public static final short CY_COLINFO_UNKNOWN = 0;
    public static final short CY_COLINFO_STRING = 1;
    public static final short CY_COLINFO_INT = 2;
    public static final short CY_COLINFO_DECIMAL = 4;
    public static final short CY_COLINFO_CURRENCY = 5;
    public static final short CY_COLINFO_DATE = 8;
    public static final short CY_COLINFO_BLOB = 9;
    public static final short CY_COLINFO_URL = 10;
    public static final short CY_COLINFO_LONG = 11;
    public static final short CY_COLINFO_CHAR = 12;
    public static final short COLPROP_NORMAL_COL = 1;
    public static final short COLPROP_NOTNULL_COL = 2;
    public static final short COLPROP_KEY_COL = 3;
    public static final short COLPROP_SEQUENCE_COL = 4;
    public static final short COLPROP_CONST_COL = 5;
    public static final short CY_COLPROP_NORMAL_COL = 1;
    public static final short CY_COLPROP_NOTNULL_COL = 2;
    public static final short CY_COLPROP_KEY_COL = 3;
    public static final short CY_COLPROP_SEQUENCE_COL = 4;
    public static final short CY_COLPROP_CONST_COL = 5;
    public static final short COLSUM_DEFAULT = 0;
    public static final short COLSUM_COUNT = 16;
    public static final short COLSUM_SUM = 32;
    public static final short COLSUM_MAX = 48;
    public static final short COLSUM_MIN = 64;
    public static final short COLSUM_AVG = 80;
    public static final short COLSUM_TEXT = 96;
    public static final short CY_COLSUM_DEFAULT = 0;
    public static final short CY_COLSUM_COUNT = 16;
    public static final short CY_COLSUM_SUM = 32;
    public static final short CY_COLSUM_MAX = 48;
    public static final short CY_COLSUM_MIN = 64;
    public static final short CY_COLSUM_AVG = 80;
    public static final short CY_COLSUM_TEXT = 96;

    public ColumnInfo() {
        this.setProperty((short)1);
    }

    public ColumnInfo(String string, short s, int n) {
        this(string, s, n, 1);
    }

    public ColumnInfo(String string, short s, int n, short s2) {
        this(string, s, n, s2, 0);
    }

    public ColumnInfo(String string, short s, int n, short s2, short s3) {
        this.id = string == null ? string : string.trim();
        this.type = s;
        this.size = n;
        this.setProperty((short)(s2 | s3));
        this.checkId(string);
    }

    public ColumnInfo(String string, short s, int n, String string2) {
        this.id = string == null ? string : string.trim();
        this.type = s;
        this.size = n;
        this.setProperty((short)97);
        this.setSummaryText(string2);
        this.checkId(string);
    }

    public ColumnInfo(String string, short s, int n, short s2, String string2) {
        this.id = string == null ? string : string.trim();
        this.type = s;
        this.size = n;
        this.setProperty((short)(s2 | 0x60));
        this.setSummaryText(string2);
        this.checkId(string);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
        this.checkId(string);
    }

    public String getColumnID() {
        return this.getId();
    }

    public void setColumnID(String string) {
        this.setId(string);
    }

    public short getType() {
        return this.type;
    }

    public void setType(short s) {
        this.type = s;
    }

    public short getColumnType() {
        return this.getType();
    }

    public void setColumnType(short s) {
        this.setType(s);
    }

    public String getTypeText() {
        switch (this.type) {
            case 1: {
                return "STRING";
            }
            case 2: {
                return "INT";
            }
            case 4: {
                return "DECIMAL";
            }
            case 5: {
                return "CURRENCY";
            }
            case 8: {
                return "DATE";
            }
            case 9: {
                return "BLOB";
            }
            case 10: {
                return "URL";
            }
            case 11: {
                return "LONG";
            }
            case 12: {
                return "CHAR";
            }
            case 13: {
                return "FILE";
            }
        }
        return "UNKNOWN";
    }

    public String getColumnTypeStr() {
        return this.getTypeText();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getColumnSize() {
        return this.getSize();
    }

    public void setColumnSize(int n) {
        this.setSize(n);
    }

    public String getColumnSizeStr() {
        return String.valueOf(this.size);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public int getColumnOrder() {
        return this.getOrder();
    }

    public void setColumnOrder(int n) {
        this.setOrder(n);
    }

    public short getProperty() {
        return this.property;
    }

    public void setProperty(short s) {
        switch (s & 0xF) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                s = (short)(s & 0xF0 | 1);
            }
        }
        switch (s & 0xF0) {
            case 0: 
            case 16: 
            case 32: 
            case 48: 
            case 64: 
            case 80: 
            case 96: {
                break;
            }
            default: {
                s = (short)(s & 0xF | 0);
            }
        }
        this.property = s;
    }

    public short getSummaryType() {
        return (short)(this.property & 0xF0);
    }

    public void setSummaryType(short s) {
        switch (s) {
            case 0: 
            case 16: 
            case 32: 
            case 48: 
            case 64: 
            case 80: 
            case 96: {
                break;
            }
            default: {
                s = 0;
            }
        }
        this.setProperty((short)(this.property & 0xF | s));
    }

    public String getSummaryTypeText() {
        switch (this.getSummaryType()) {
            case 16: {
                return "count";
            }
            case 32: {
                return "sum";
            }
            case 48: {
                return "max";
            }
            case 64: {
                return "min";
            }
            case 80: {
                return "avg";
            }
            case 96: {
                return "text";
            }
        }
        return "unknown";
    }

    public String getSummaryTypeStr() {
        return this.getSummaryTypeText();
    }

    public String getSummaryText() {
        return this.getSummaryType() == 96 ? this.summaryText : null;
    }

    public void setSummaryText(String string) {
        this.setSummaryType((short)96);
        this.summaryText = string;
    }

    public boolean isSummary() {
        return (this.property & 0xF0) > 0;
    }

    public boolean IsSummary() {
        return (this.property & 0xF0) > 0;
    }

    public void readFrom(Reader reader) throws IOException {
        BufferedReader bufferedReader = (BufferedReader)reader;
        String string = bufferedReader.readLine().trim();
        String string2 = string.substring(string.indexOf("id="));
        int n = string2.indexOf(34) + 1;
        int n2 = string2.indexOf(34, n);
        String string3 = string2.substring(n, n2);
        this.setId(string3);
        string2 = string.substring(string.indexOf("size="));
        n = string2.indexOf(34) + 1;
        n2 = string2.indexOf(34, n);
        String string4 = string2.substring(n, n2);
        this.setSize(Integer.parseInt(string4));
        string2 = string.substring(string.indexOf("type="));
        n = string2.indexOf(34) + 1;
        n2 = string2.indexOf(34, n);
        String string5 = string2.substring(n, n2);
        if (string5.equalsIgnoreCase("STRING")) {
            this.setType((short)1);
        } else if (string5.equalsIgnoreCase("INT")) {
            this.setType((short)2);
        } else if (string5.equalsIgnoreCase("DECIMAL")) {
            this.setType((short)4);
        } else if (string5.equalsIgnoreCase("CURRENCY")) {
            this.setType((short)5);
        } else if (string5.equalsIgnoreCase("DATE")) {
            this.setType((short)8);
        } else if (string5.equalsIgnoreCase("BLOB")) {
            this.setType((short)9);
        }
        int n3 = string.indexOf("summ=");
        if (n3 > 0) {
            string2 = string.substring(n3);
            String string6 = string2.substring(n = string2.indexOf(34) + 1, n2 = string2.indexOf(34, n));
            if (string6.equalsIgnoreCase("count")) {
                this.setSummaryType((short)16);
            } else if (string6.equalsIgnoreCase("sum")) {
                this.setSummaryType((short)32);
            } else if (string6.equalsIgnoreCase("max")) {
                this.setSummaryType((short)48);
            } else if (string6.equalsIgnoreCase("min")) {
                this.setSummaryType((short)64);
            } else if (string6.equalsIgnoreCase("avg")) {
                this.setSummaryType((short)80);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ":");
                String string7 = null;
                String string8 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string7 = stringTokenizer.nextToken();
                }
                if (string7.equalsIgnoreCase("text")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        string8 = stringTokenizer.nextToken();
                    }
                    if (string8 == null) {
                        this.setSummaryType((short)96);
                    } else {
                        this.setSummaryText(XmlString.decode(string8));
                    }
                }
            }
        }
    }

    public void readFrom(InputStream inputStream, String string) throws IOException {
        this.readFrom(new DataInputStream(inputStream), string, (short)2000);
    }

    public void readFrom(DataInputStream dataInputStream, String string, short s) throws IOException {
        int n;
        byte[] byArray = new byte[dataInputStream.readShort()];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = dataInputStream.read(byArray, n, byArray.length - n)) > 0; n += n2) {
        }
        this.id = string == null ? new String(byArray) : new String(byArray, string);
        this.type = dataInputStream.readShort();
        this.size = dataInputStream.readShort();
        this.property = dataInputStream.readShort();
        if ((this.property & 0xF0) == 96) {
            byte[] byArray2 = new byte[dataInputStream.readShort()];
            n = 0;
            for (int i = 0; i < byArray2.length && (n = dataInputStream.read(byArray2, i, byArray2.length - i)) > 0; i += n) {
            }
            this.summaryText = string == null ? new String(byArray2) : new String(byArray2, string);
        }
    }

    public void readFrom2(InputStream inputStream) throws IOException {
        this.readFrom2(new DataInputStream(inputStream), (short)2000);
    }

    public void readFrom2(DataInputStream dataInputStream, short s) throws IOException {
        int n;
        byte[] byArray = new byte[dataInputStream.readShort()];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = dataInputStream.read(byArray, n, byArray.length - n)) > 0; n += n2) {
        }
        this.id = new String(byArray, "utf-8");
        this.type = dataInputStream.readShort();
        this.size = dataInputStream.readShort();
        this.property = dataInputStream.readShort();
        if ((this.property & 0xF0) == 96) {
            byte[] byArray2 = new byte[dataInputStream.readShort()];
            n = 0;
            for (int i = 0; i < byArray2.length && (n = dataInputStream.read(byArray2, i, byArray2.length - i)) > 0; i += n) {
            }
            this.summaryText = new String(byArray2, "utf-8");
        }
    }

    public void writeTo(Writer writer) throws IOException {
        PrintWriter printWriter = (PrintWriter)writer;
        printWriter.print("\t\t");
        printWriter.print("<colinfo");
        printWriter.print(" id=\"" + this.id + '\"');
        printWriter.print(" size=\"" + this.size + '\"');
        if (this.type == 9 || this.type == 13) {
            printWriter.print(" type=\"BLOB\"");
            printWriter.print(" encrypt=\"base64\"");
        } else {
            printWriter.print(" type=\"" + this.getTypeText() + '\"');
        }
        switch (this.getSummaryType()) {
            case 16: {
                printWriter.print(" summ=\"count\"");
                break;
            }
            case 32: {
                printWriter.print(" summ=\"sum\"");
                break;
            }
            case 48: {
                printWriter.print(" summ=\"max\"");
                break;
            }
            case 64: {
                printWriter.print(" summ=\"min\"");
                break;
            }
            case 80: {
                printWriter.print(" summ=\"avg\"");
                break;
            }
            case 96: {
                printWriter.print(" summ=\"text:" + XmlString.encode(this.getSummaryText()) + '\"');
                break;
            }
        }
        printWriter.println("/>");
    }

    public void writeTo(DataOutputStream dataOutputStream, String string) throws IOException {
        this.writeTo(dataOutputStream, string, (short)2000);
    }

    public void writeTo(DataOutputStream dataOutputStream, String string, short s) throws IOException {
        byte[] byArray = string == null ? this.id.getBytes() : this.id.getBytes(string);
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
        if (this.type == 13) {
            dataOutputStream.writeShort(9);
        } else {
            dataOutputStream.writeShort(this.type);
        }
        dataOutputStream.writeShort(this.size);
        dataOutputStream.writeShort(this.property);
        if ((this.property & 0xF0) == 96) {
            if (this.summaryText == null) {
                dataOutputStream.writeShort(0);
            } else {
                byte[] byArray2 = string == null ? this.summaryText.getBytes() : this.summaryText.getBytes(string);
                dataOutputStream.writeShort(byArray2.length);
                dataOutputStream.write(byArray2);
            }
        }
    }

    public void writeTo2(DataOutputStream dataOutputStream) throws IOException {
        this.writeTo2(dataOutputStream, (short)2000);
    }

    public void writeTo2(DataOutputStream dataOutputStream, short s) throws IOException {
        byte[] byArray = this.id.getBytes("utf-8");
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
        if (this.type == 13) {
            dataOutputStream.writeShort(9);
        } else {
            dataOutputStream.writeShort(this.type);
        }
        dataOutputStream.writeShort(this.size);
        if (s < 4000 && s >= 3100) {
            dataOutputStream.writeShort(this.property);
            if ((this.property & 0xF0) == 96) {
                if (this.summaryText == null) {
                    dataOutputStream.writeShort(0);
                } else {
                    byte[] byArray2 = this.summaryText.getBytes("utf-8");
                    dataOutputStream.writeShort(byArray2.length);
                    dataOutputStream.write(byArray2);
                }
            }
        }
    }

    public String toString() {
        return "ColumnInfo[id=" + this.getId() + ", type=" + this.getTypeText() + ", size=" + this.getSize() + ", order=" + this.getOrder() + "]";
    }

    public void dump() {
        System.out.println("ID[" + this.id + "], type[" + this.getTypeText() + "], size[" + this.size + "]");
    }

    private void checkId(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid id: " + string);
        }
        if ("".equals(string)) {
            throw new IllegalArgumentException("Invalid id: \"" + string + "\"");
        }
        if (!this.isValid(string)) {
            throw new IllegalArgumentException("Invalid id: \"" + string + "\"");
        }
    }

    private boolean isValid(String string) {
        boolean bl = false;
        if (bl) {
            int n = string == null ? 0 : string.length();
            for (int i = 0; i < n; ++i) {
                if (this.isValid(string.charAt(i), i > 0)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValid(char c, boolean bl) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || bl && c >= '0' && c <= '9' || c == '_' || c == '-' || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.HANGUL_SYLLABLES || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO;
    }
}

