/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

class StreamLogInputStream
extends InputStream {
    private static final int KILO = 1024;
    private static final int MEGA = 1024000;
    private static final int IO_BUFFER_SIZE = 4096;
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static final String DEFAULT_LOG_DIR = ".";
    private static final int DEFAULT_LOG_MAX_SIZE = 4096000;
    private static final String DEFAULT_LOG_PREFIX = "mi";
    private static final String DEFAULT_LOG_SUFFIX = "req";
    private static DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
    private InputStream in;
    private ByteArrayOutputStream buffer;
    private boolean isExceededSize;
    private boolean isMarked;
    private String logDir;
    private int logMaxSize;
    private String logPrefix;
    private String logSuffix;

    public StreamLogInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public String getLogDir() {
        if (this.isEmpty(this.logDir)) {
            return DEFAULT_LOG_DIR;
        }
        int n = this.logDir.length();
        char c = this.logDir.charAt(n - 1);
        return c == '/' || c == '\\' ? this.logDir.substring(0, n - 1) : this.logDir;
    }

    public void setLogDir(String string) {
        this.logDir = string;
    }

    public int getLogMaxSize() {
        return this.logMaxSize <= 0 ? 4096000 : this.logMaxSize;
    }

    public void setLogMaxSize(int n) {
        this.logMaxSize = n;
    }

    public String getLogPrefix() {
        return this.isEmpty(this.logPrefix) ? DEFAULT_LOG_PREFIX : this.logPrefix;
    }

    public void setLogPrefix(String string) {
        this.logPrefix = string;
    }

    public String getLogSuffix() {
        return this.isEmpty(this.logSuffix) ? DEFAULT_LOG_SUFFIX : this.logSuffix;
    }

    public void setLogSuffix(String string) {
        this.logSuffix = string;
    }

    private String getLogPath() {
        String string = this.getLogDir();
        String string2 = this.getLogPrefix();
        String string3 = this.getLogSuffix();
        String string4 = string2 + "_" + this.getCurrentDateString() + DEFAULT_LOG_DIR + string3;
        return string + File.separator + string4;
    }

    private String getCurrentDateString() {
        return this.getDateString(System.currentTimeMillis());
    }

    private String getDateString(long l) {
        return dateFormat.format(new Date(l));
    }

    private boolean isExceededSize() {
        return this.isExceededSize;
    }

    private void setExceededSize(boolean bl) {
        this.isExceededSize = bl;
    }

    private boolean isMarked() {
        return this.isMarked;
    }

    private void setMarked(boolean bl) {
        this.isMarked = bl;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1 && this.checkBuffer(1)) {
            this.buffer.write(n);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0 && this.checkBuffer(n3)) {
            this.buffer.write(byArray, n, n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2;
        int n;
        if (l <= 0L) {
            return 0L;
        }
        byte[] byArray = new byte[2048];
        for (l2 = l; l2 > 0L && (n = this.in.read(byArray, 0, (int)Math.min(2048L, l2))) >= 0; l2 -= (long)n) {
            if (n <= 0 || !this.checkBuffer(n)) continue;
            this.buffer.write(byArray, 0, n);
        }
        return l - l2;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int n) {
        if (this.markSupported()) {
            this.in.mark(n);
            this.setMarked(true);
        }
    }

    public synchronized void reset() throws IOException {
        if (this.markSupported()) {
            this.in.reset();
            this.setMarked(false);
        }
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStreamLog() throws IOException {
        File file;
        String string = this.getLogPath();
        File file2 = new File(string);
        if (file2.exists()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            string = this.getLogPath();
            file2 = new File(string);
        }
        if (!(file = file2.getParentFile()).exists()) {
            file.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            if (this.buffer == null) {
                if (this.in.available() > 0) {
                    this.copy(this.in, fileOutputStream);
                } else {
                    fileOutputStream.write("\ubc84\ud37c \ubbf8\uc0dd\uc131, in.available()=0".getBytes());
                }
            } else {
                fileOutputStream.write(this.buffer.toByteArray());
                if (this.isExceededSize()) {
                    fileOutputStream.write(System.getProperty("line.separator").getBytes());
                    fileOutputStream.write(("\ubc84\ud37c \ucd08\uacfc, maxSize=" + this.getLogMaxSize()).getBytes());
                } else if (this.in.available() > 0) {
                    this.copy(this.in, fileOutputStream);
                }
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    private long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        long l = 0L;
        int n = 0;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    private boolean checkBuffer(int n) {
        if (this.isMarked() || this.isExceededSize()) {
            return false;
        }
        if (this.buffer == null) {
            this.buffer = new ByteArrayOutputStream();
        }
        if (this.buffer.size() + n > this.getLogMaxSize()) {
            this.setExceededSize(true);
            return false;
        }
        return true;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }
}

