/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform;

import com.tobesoft.platform.Platform;
import com.tobesoft.platform.PlatformConstants;
import com.tobesoft.platform.PlatformRequest;
import com.tobesoft.platform.data.DatasetList;
import com.tobesoft.platform.data.PlatformData;
import com.tobesoft.platform.data.VariableList;
import com.tobesoft.platform.util.Codepage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformResponse
implements PlatformConstants {
    static Log log = LogFactory.getLog((Class)(class$com$tobesoft$platform$PlatformResponse == null ? (class$com$tobesoft$platform$PlatformResponse = PlatformResponse.class$("com.tobesoft.platform.PlatformResponse")) : class$com$tobesoft$platform$PlatformResponse));
    private HttpServletResponse httpResponse;
    private OutputStream outputStream;
    private Writer writer;
    private int contentType;
    private int compressionType;
    private short saveType;
    private short version;
    private String charset;
    private int compressionLevel = 1;
    private int compressionBufferSize = 1024;
    private boolean isBase64Chunked = true;
    static /* synthetic */ Class class$com$tobesoft$platform$PlatformResponse;

    public PlatformResponse(HttpServletResponse httpServletResponse) throws IOException {
        this(httpServletResponse, Platform.getCharset());
    }

    public PlatformResponse(HttpServletResponse httpServletResponse, short s) throws IOException {
        this(httpServletResponse, s, Platform.getCharset());
    }

    public PlatformResponse(HttpServletResponse httpServletResponse, String string) throws IOException {
        this(httpServletResponse, Platform.getStreamVersion(), string);
    }

    public PlatformResponse(HttpServletResponse httpServletResponse, short s, String string) throws IOException {
        this.httpResponse = httpServletResponse;
        this.contentType = Platform.getContentType();
        this.compressionType = Platform.getCompressionType();
        this.saveType = (short)5;
        this.version = s;
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
    }

    public PlatformResponse(HttpServletResponse httpServletResponse, PlatformRequest platformRequest) throws IOException {
        this(httpServletResponse, platformRequest, 5);
    }

    public PlatformResponse(HttpServletResponse httpServletResponse, PlatformRequest platformRequest, short s) throws IOException {
        this.httpResponse = httpServletResponse;
        this.contentType = platformRequest.getContentType();
        this.compressionType = platformRequest.getCompressionType();
        this.saveType = s;
        this.version = platformRequest.getStreamVersion();
        this.charset = platformRequest.getCharset();
    }

    public PlatformResponse(HttpServletResponse httpServletResponse, int n) throws IOException {
        this(httpServletResponse, n, Platform.getCharset());
    }

    public PlatformResponse(HttpServletResponse httpServletResponse, int n, short s) throws IOException {
        this(httpServletResponse, n, s, Platform.getCharset());
    }

    public PlatformResponse(HttpServletResponse httpServletResponse, int n, String string) throws IOException {
        this(httpServletResponse, n, 4000, string);
    }

    public PlatformResponse(HttpServletResponse httpServletResponse, int n, short s, String string) throws IOException {
        this.httpResponse = httpServletResponse;
        this.setCompressMethod(n);
        this.saveType = (short)5;
        this.version = s;
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
    }

    public PlatformResponse(OutputStream outputStream) throws IOException {
        this(outputStream, Platform.getCharset());
    }

    public PlatformResponse(OutputStream outputStream, short s) throws IOException {
        this(outputStream, s, Platform.getCharset());
    }

    public PlatformResponse(OutputStream outputStream, String string) throws IOException {
        this(outputStream, Platform.getStreamVersion(), string);
    }

    public PlatformResponse(OutputStream outputStream, short s, String string) throws IOException {
        this.outputStream = outputStream;
        this.contentType = Platform.getContentType();
        this.compressionType = Platform.getCompressionType();
        this.saveType = (short)5;
        this.version = s;
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
    }

    public PlatformResponse(OutputStream outputStream, int n) throws IOException {
        this(outputStream, n, Platform.getCharset());
    }

    public PlatformResponse(OutputStream outputStream, int n, short s) throws IOException {
        this(outputStream, n, s, Platform.getCharset());
    }

    public PlatformResponse(OutputStream outputStream, int n, String string) throws IOException {
        this(outputStream, n, 4000, string);
    }

    public PlatformResponse(OutputStream outputStream, int n, short s, String string) throws IOException {
        this.outputStream = outputStream;
        this.setCompressMethod(n);
        this.saveType = (short)5;
        this.version = s;
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
    }

    public PlatformResponse(Writer writer) throws IOException {
        this(writer, Platform.getCharset());
    }

    public PlatformResponse(Writer writer, String string) throws IOException {
        this(writer, 5, string);
    }

    public PlatformResponse(Writer writer, short s) throws IOException {
        this(writer, s, Platform.getCharset());
    }

    public PlatformResponse(Writer writer, short s, String string) throws IOException {
        this.writer = writer;
        this.contentType = Platform.getContentType();
        this.compressionType = Platform.getCompressionType();
        this.saveType = s;
        this.version = Platform.getStreamVersion();
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
    }

    public int getContentType() {
        return this.contentType;
    }

    public void setContentType(int n) {
        this.contentType = n;
    }

    public int getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(int n) {
        this.compressionType = n;
    }

    public void disableCompress() {
        this.setCompressionType(0);
    }

    public int getCompressMethod() {
        if (this.getContentType() == 1) {
            return this.writer == null ? 3 : 4;
        }
        if (this.getCompressionType() == 3) {
            return 1;
        }
        if (this.getCompressionType() == 1) {
            return 2;
        }
        return 5;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        if (Codepage.isSupportedCharset(string)) {
            this.charset = string;
        }
    }

    public short getDatasetSaveType() {
        return this.saveType;
    }

    public void setDatasetSaveType(short s) {
        this.saveType = s;
    }

    public void setWriteMethod(short s) {
        this.setDatasetSaveType(s);
    }

    public short getStreamVersion() {
        return this.version;
    }

    public void setStreamVersion(short s) {
        this.version = s;
    }

    public short getPlatformVersion() {
        return this.getStreamVersion();
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("\uc801\ud569\ud558\uc9c0 \uc54a\uc740 \uc555\ucd95 \ub808\ubca8, compressionLevel=" + n);
        }
        this.compressionLevel = n;
    }

    public int getCompressionBufferSize() {
        return this.compressionBufferSize;
    }

    public void setCompressionBufferSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("\uc801\ud569\ud558\uc9c0 \uc54a\uc740 \uc555\ucd95 \ubc84\ud37c \ud06c\uae30, compressionBufferSize=" + n);
        }
        this.compressionBufferSize = n;
    }

    public void setCompLevel(int n) throws IOException {
        this.setCompressionLevel(n);
    }

    public void setCompBuffer(int n) throws IOException {
        this.setCompressionBufferSize(n);
    }

    public void setCompress(int n, int n2) throws IOException {
        this.setCompressionLevel(n);
        this.setCompressionBufferSize(n2);
    }

    public boolean isBase64Chunked() {
        return this.isBase64Chunked;
    }

    public void setBase64Chunked(boolean bl) {
        this.isBase64Chunked = bl;
    }

    public void sendData(PlatformData platformData) throws IOException {
        this.sendData(platformData.getVariableList(), platformData.getDatasetList());
    }

    public void sendData(VariableList variableList, DatasetList datasetList) throws IOException {
        if (Platform.isDebug() && log.isDebugEnabled()) {
            log.debug((Object)("target=" + (this.httpResponse == null ? "stream" : "http") + ", charset=" + this.charset + ", contentType=" + this.contentType + ", compressionType=" + this.compressionType + ", saveType=" + this.saveType + ", version=" + this.version));
        }
        if (this.version == 0) {
            this.version = (short)4000;
        }
        if (this.contentType == 1) {
            if (this.compressionType != 0 && this.compressionType != 2) {
                throw new IllegalArgumentException("\uc801\ud569\ud558\uc9c0 \uc54a\uc740 \uc555\ucd95 \ubc29\uc2dd, compressionType=" + this.compressionType);
            }
            PrintWriter printWriter = new PrintWriter(this.getXmlWriter());
            this.writeXml(printWriter, variableList, datasetList);
        } else if (this.compressionType == 0) {
            OutputStream outputStream = this.getBinOutputStream();
            this.writeBin(outputStream, variableList, datasetList);
        } else if (this.compressionType == 3) {
            OutputStream outputStream = this.getBinOutputStream();
            this.writeZlib(outputStream, variableList, datasetList);
        } else if (this.compressionType == 1) {
            OutputStream outputStream = this.getBinOutputStream();
            this.writeZlib(outputStream, variableList, datasetList);
        } else {
            throw new IllegalArgumentException("\uc801\ud569\ud558\uc9c0 \uc54a\uc740 \uc555\ucd95 \ubc29\uc2dd, compressionType=" + this.compressionType);
        }
    }

    public void sendXML(PrintWriter printWriter, VariableList variableList, DatasetList datasetList) throws IOException {
        this.writeXml(printWriter, variableList, datasetList);
    }

    private void writeXml(PrintWriter printWriter, VariableList variableList, DatasetList datasetList) throws IOException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + this.charset + "\"?>");
        printWriter.println("<root>");
        variableList.writeTo(printWriter, this.isBase64Chunked);
        datasetList.writeTo(printWriter, this.charset, this.saveType, this.isBase64Chunked);
        printWriter.println("</root>");
        printWriter.flush();
    }

    private void writeBin(OutputStream outputStream, VariableList variableList, DatasetList datasetList) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        int n = datasetList.size();
        dataOutputStream.writeShort(n + 1);
        if (this.version >= 4000) {
            variableList.writeTo(dataOutputStream, this.charset, this.version);
            datasetList.writeTo(dataOutputStream, this.charset, this.version, this.saveType);
        } else if (this.version >= 3100) {
            variableList.writeTo(dataOutputStream, this.charset, this.version);
            datasetList.writeTo(dataOutputStream, this.charset, this.version, this.saveType);
        } else {
            variableList.writeTo(dataOutputStream, this.charset);
            datasetList.writeTo(dataOutputStream, this.charset, this.saveType);
        }
        dataOutputStream.flush();
    }

    private void writeZlib(OutputStream outputStream, VariableList variableList, DatasetList datasetList) throws IOException {
        outputStream.write(255);
        outputStream.write(173);
        Deflater deflater = new Deflater(this.compressionLevel);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(outputStream, deflater, this.compressionBufferSize);
        DataOutputStream dataOutputStream = new DataOutputStream(deflaterOutputStream);
        int n = datasetList.size();
        dataOutputStream.writeShort(n + 1);
        if (this.version >= 4000) {
            variableList.writeTo(dataOutputStream, this.charset, this.version);
            datasetList.writeTo(dataOutputStream, this.charset, this.version, this.saveType);
        } else if (this.version >= 3100) {
            variableList.writeTo(dataOutputStream, this.charset, this.version);
            datasetList.writeTo(dataOutputStream, this.charset, this.version, this.saveType);
        } else {
            variableList.writeTo(dataOutputStream, this.charset);
            datasetList.writeTo(dataOutputStream, this.charset, this.saveType);
        }
        dataOutputStream.flush();
        deflaterOutputStream.close();
        deflater.end();
    }

    private void setCompressMethod(int n) {
        if (n == 1) {
            this.contentType = 2;
            this.compressionType = 3;
        } else if (n == 2) {
            this.contentType = 2;
            this.compressionType = 1;
        } else if (n == 3) {
            this.contentType = 1;
            this.compressionType = 0;
        } else if (n == 4) {
            this.contentType = 1;
            this.compressionType = 0;
        } else {
            this.contentType = 2;
            this.compressionType = 0;
        }
    }

    private Writer getXmlWriter() throws IOException {
        if (this.httpResponse != null) {
            this.httpResponse.setContentType("text/xml;charset=" + this.charset);
            return this.httpResponse.getWriter();
        }
        if (this.outputStream != null) {
            return new OutputStreamWriter(this.outputStream, this.charset);
        }
        return this.writer;
    }

    private OutputStream getBinOutputStream() throws IOException {
        if (this.httpResponse != null) {
            this.httpResponse.setContentType("application/octet-stream");
            return this.httpResponse.getOutputStream();
        }
        return this.outputStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

