/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform;

import com.tobesoft.platform.Platform;
import com.tobesoft.platform.PlatformConstants;
import com.tobesoft.platform.PlatformInputStream;
import com.tobesoft.platform.StreamLogInputStream;
import com.tobesoft.platform.data.DatasetList;
import com.tobesoft.platform.data.PlatformData;
import com.tobesoft.platform.data.VariableList;
import com.tobesoft.platform.util.Codepage;
import com.tobesoft.platform.util.PushbackLineReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformRequest
implements PlatformConstants {
    static Log log = LogFactory.getLog((Class)(class$com$tobesoft$platform$PlatformRequest == null ? (class$com$tobesoft$platform$PlatformRequest = PlatformRequest.class$("com.tobesoft.platform.PlatformRequest")) : class$com$tobesoft$platform$PlatformRequest));
    private HttpServletRequest httpRequest;
    private InputStream inputStream;
    private Reader reader;
    private String charset;
    private int contentType;
    private int compressionType;
    private PlatformData data;
    private StreamLogInputStream logStream;
    private boolean isStreamLog;
    private String logDir;
    private int logMaxSize;
    private String logPrefix;
    private String logSuffix;
    static final int[] codes = new int[]{1042, 1033, 1041, 1028, 2052, 1036, 3084, 2060, 4108, 1029, 1030, 1043, 2067, 3081, 4105, 5129, 2057, 1035, 1031, 3079, 2055, 1032, 1038, 1039, 1040, 2064, 1045, 1046, 2070, 1049, 1051, 2058, 1034, 4106, 5130, 6154, 7178, 8202, 9226, 10250, 11274, 12298, 13322, 14346, 15370, 16394, 17418, 18442, 19466, 20490, 1053, 2077, 1055, 1066, 1054};
    static final String[][] languages = new String[][]{{"ko", "KR"}, {"en", "US"}, {"ja", "JP"}, {"zh", "TW"}, {"zh", "CN"}, {"fr", "FR"}, {"fr", "CA"}, {"fr", "BE"}, {"fr", "CH"}, {"cs", "CZ"}, {"da", "DK"}, {"nl", "NL"}, {"nl", "BE"}, {"en", "AU"}, {"en", "CA"}, {"en", "NZ"}, {"en", "GB"}, {"fi", "FI"}, {"de", "DE"}, {"de", "AT"}, {"de", "CH"}, {"el", "GR"}, {"hu", "HU"}, {"is", "IS"}, {"it", "IT"}, {"it", "CH"}, {"pl", "PL"}, {"pt", "BR"}, {"pt", "PT"}, {"ru", "RU"}, {"sk", "SK"}, {"es", "MX"}, {"es", "ES"}, {"es", "GT"}, {"es", "CR"}, {"es", "PA"}, {"es", "DO"}, {"es", "VE"}, {"es", "CO"}, {"es", "PE"}, {"es", "AR"}, {"es", "EC"}, {"es", "CL"}, {"es", "UY"}, {"es", "PY"}, {"es", "BO"}, {"es", "SV"}, {"es", "HN"}, {"es", "NI"}, {"es", "PR"}, {"sv", "SE"}, {"sv", "FI"}, {"tr", "TR"}, {"vi", "VN"}, {"th", "TH"}};
    static /* synthetic */ Class class$com$tobesoft$platform$PlatformRequest;

    public PlatformRequest(HttpServletRequest httpServletRequest) throws IOException {
        this(httpServletRequest, Platform.getCharset());
    }

    public PlatformRequest(HttpServletRequest httpServletRequest, String string) throws IOException {
        this.httpRequest = httpServletRequest;
        this.contentType = Platform.getContentType();
        this.compressionType = Platform.getCompressionType();
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
        this.data = this.createEmptyPlatformData();
    }

    public PlatformRequest(InputStream inputStream) {
        this(inputStream, Platform.getCharset());
    }

    public PlatformRequest(InputStream inputStream, String string) {
        this.inputStream = inputStream;
        this.contentType = Platform.getContentType();
        this.compressionType = Platform.getCompressionType();
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
        this.data = this.createEmptyPlatformData();
    }

    public PlatformRequest(Reader reader) {
        this(reader, Platform.getCharset());
    }

    public PlatformRequest(Reader reader, String string) {
        this.reader = reader;
        this.contentType = 1;
        this.compressionType = 0;
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
        this.data = this.createEmptyPlatformData();
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpServletRequest httpServletRequest) {
        this.httpRequest = httpServletRequest;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        if (Codepage.isSupportedCharset(string)) {
            this.charset = string;
        }
    }

    public int getContentType() {
        return this.contentType;
    }

    public void setContentType(int n) {
        this.contentType = n;
    }

    public int getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(int n) {
        this.compressionType = n;
    }

    public int getCompressMethod() {
        if (this.getContentType() == 1) {
            return 3;
        }
        if (this.getCompressionType() == 3) {
            return 1;
        }
        if (this.getCompressionType() == 1) {
            return 2;
        }
        return 5;
    }

    public short getStreamVersion() {
        return this.data == null ? (short)0 : this.data.getVariableList().getStreamVersion();
    }

    public short getPlatformVersion() {
        return this.getStreamVersion();
    }

    public PlatformData getPlatformData() {
        return this.data;
    }

    public VariableList getVariableList() {
        return this.data == null ? null : this.data.getVariableList();
    }

    public DatasetList getDatasetList() {
        return this.data == null ? null : this.data.getDatasetList();
    }

    public void receiveData() throws IOException {
        if (Platform.isDebug() && log.isDebugEnabled()) {
            log.debug((Object)("source=" + (this.httpRequest == null ? "stream" : "http") + ", charset=" + this.charset + ", contentType=" + this.contentType + ", compressionType=" + this.compressionType));
        }
        if (this.httpRequest != null) {
            this.parseHttpRequest();
        } else if (this.inputStream != null) {
            this.parseInputStream();
        } else {
            this.parseReader();
        }
    }

    public void readData(boolean bl) throws IOException {
        if (bl) {
            this.setContentType(1);
            this.setCompressionType(0);
        } else {
            this.setContentType(2);
            this.setCompressionType(0);
        }
        if (this.inputStream != null) {
            this.parseInputStream();
        } else {
            this.parseReader();
        }
    }

    private void parseHttpRequest() throws IOException {
        int n;
        int n2 = n = this.httpRequest == null ? 0 : this.httpRequest.getContentLength();
        if (Platform.isDebug() && log.isDebugEnabled()) {
            log.debug((Object)("contentLength=" + n));
        }
        if (n > 0) {
            BufferedInputStream bufferedInputStream = null;
            if (this.isStreamLog()) {
                this.logStream = this.createStreamLogInputStream((InputStream)this.httpRequest.getInputStream());
                bufferedInputStream = new BufferedInputStream(this.logStream);
            } else {
                bufferedInputStream = new BufferedInputStream((InputStream)this.httpRequest.getInputStream());
            }
            String string = this.httpRequest.getContentType();
            String string2 = this.httpRequest.getHeader("content-encoding");
            if (Platform.isDebug() && log.isDebugEnabled()) {
                log.debug((Object)("contentType=" + string));
                log.debug((Object)("contentEncoding=" + string2));
            }
            try {
                if (this.isXmlContentType(string) || this.isHtmlContentType(string)) {
                    this.setCharset(this.findCharsetFromContentType(string));
                    if (this.isGzipCompressionType(string2)) {
                        this.contentType = 1;
                        this.compressionType = 2;
                        this.parseGzipXmlInputStream(bufferedInputStream);
                    }
                    this.contentType = 1;
                    this.compressionType = 0;
                    this.parseXmlInputStream(bufferedInputStream);
                }
                short s = this.readShort(bufferedInputStream);
                if (this.isLzssCompressionType(s)) {
                    this.contentType = 2;
                    this.compressionType = 3;
                    this.parseLzssBinInputStream(bufferedInputStream, n);
                }
                if (this.isZlibCompressionType(s)) {
                    this.contentType = 2;
                    this.compressionType = 1;
                    this.parseZlibBinInputStream(bufferedInputStream);
                }
                this.contentType = 2;
                this.compressionType = 0;
                this.parseBinInputStream(bufferedInputStream, s);
            }
            catch (IOException iOException) {
                if (this.logStream != null) {
                    this.logStream.storeStreamLog();
                }
                throw iOException;
            }
        } else {
            this.contentType = 0;
            this.compressionType = 0;
        }
        this.parseHttpParameters();
    }

    private void parseInputStream() throws IOException {
        InputStream inputStream = null;
        if (this.isStreamLog()) {
            this.logStream = this.createStreamLogInputStream(this.inputStream);
            inputStream = this.logStream;
        } else {
            inputStream = this.inputStream;
        }
        if (inputStream == null || inputStream.available() == 0) {
            this.contentType = 0;
            this.compressionType = 0;
        } else {
            try {
                if (this.getContentType() == 1) {
                    if (this.getCompressionType() == 2) {
                        this.contentType = 1;
                        this.compressionType = 2;
                        this.parseGzipXmlInputStream(inputStream);
                    } else {
                        this.contentType = 1;
                        this.compressionType = 0;
                        this.parseXmlInputStream(inputStream);
                    }
                } else {
                    short s = this.readShort(inputStream);
                    if (this.isLzssCompressionType(s)) {
                        this.contentType = 2;
                        this.compressionType = 3;
                        this.parseLzssBinInputStream(inputStream, inputStream.available());
                    } else if (this.isZlibCompressionType(s)) {
                        this.contentType = 2;
                        this.compressionType = 1;
                        this.parseZlibBinInputStream(inputStream);
                    } else {
                        this.contentType = 2;
                        this.compressionType = 0;
                        this.parseBinInputStream(inputStream, s);
                    }
                }
            }
            catch (IOException iOException) {
                if (this.logStream != null) {
                    this.logStream.storeStreamLog();
                }
                throw iOException;
            }
        }
    }

    private void parseReader() throws IOException {
        if (this.reader == null || !this.reader.ready()) {
            this.contentType = 0;
            this.compressionType = 0;
        } else {
            this.contentType = 1;
            this.compressionType = 0;
            this.parseXmlReader(this.reader);
        }
    }

    private void parseHttpParameters() {
        VariableList variableList = this.getVariableList();
        Enumeration enumeration = this.httpRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.httpRequest.getParameter(string);
            variableList.add(string, string2);
        }
    }

    private void parseXmlInputStream(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = this.charset == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.charset);
        this.parseXmlReader(inputStreamReader);
    }

    private void parseXmlReader(Reader reader) throws IOException {
        String string;
        PushbackLineReader pushbackLineReader = new PushbackLineReader(reader);
        String string2 = pushbackLineReader.readLine().trim();
        if (string2.length() == 0) {
            while (string2.length() == 0) {
                string2 = pushbackLineReader.readLine();
                if (string2 == null) {
                    return;
                }
                string2 = string2.trim();
            }
        }
        if (!string2.substring(0, (string = "<?xml").length()).equalsIgnoreCase(string)) {
            return;
        }
        if (Platform.isDebug() && log.isTraceEnabled()) {
            log.trace((Object)("xml=" + string2));
        }
        this.charset = this.findCharsetFromXmlHeader(string2);
        if (this.data != null) {
            this.data.setCharset(this.charset);
        }
        if ("<root></root>".equals(string2 = pushbackLineReader.readLine().trim())) {
            return;
        }
        if (!"<root>".equalsIgnoreCase(string2)) {
            return;
        }
        pushbackLineReader.mark(64);
        string2 = pushbackLineReader.readLine().trim();
        VariableList variableList = this.getVariableList();
        DatasetList datasetList = this.getDatasetList();
        if ("<params>".equalsIgnoreCase(string2)) {
            variableList.readFrom(pushbackLineReader);
        } else if (!"<params/>".equalsIgnoreCase(string2)) {
            pushbackLineReader.reset();
        }
        datasetList.readFrom(pushbackLineReader, this.charset);
    }

    private void parseGzipXmlInputStream(InputStream inputStream) throws IOException {
        this.parseXmlInputStream(new GZIPInputStream(inputStream));
    }

    private void parseBinInputStream(InputStream inputStream, short s) throws IOException {
        this.parseBinInputStream(new DataInputStream(inputStream), s - 1);
    }

    private void parseLzssBinInputStream(InputStream inputStream, int n) throws IOException {
        PlatformInputStream platformInputStream = new PlatformInputStream(inputStream);
        platformInputStream.receive(n);
        short s = platformInputStream.readShort();
        this.parseBinInputStream(platformInputStream, s - 1);
    }

    private void parseZlibBinInputStream(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new InflaterInputStream(inputStream));
        short s = dataInputStream.readShort();
        this.parseBinInputStream(dataInputStream, s - 1);
    }

    private void parseBinInputStream(DataInputStream dataInputStream, int n) throws IOException {
        Integer n2;
        VariableList variableList = this.getVariableList();
        variableList.readFrom(dataInputStream, this.charset);
        this.charset = variableList.getCharset();
        if (this.data != null) {
            this.data.setCharset(this.charset);
        }
        int n3 = (n2 = variableList.getValueAsInteger("_mp_sys_sort_language_")) == null ? -1 : n2;
        Locale locale = PlatformRequest.getLocale(n3);
        DatasetList datasetList = this.getDatasetList();
        datasetList.readFrom(dataInputStream, this.charset, n, locale);
    }

    private boolean isXmlContentType(String string) {
        if (string == null) {
            return false;
        }
        String string2 = "text/xml";
        int n = string2.length();
        if (string.length() < n) {
            return false;
        }
        return string.substring(0, n).equalsIgnoreCase(string2);
    }

    private boolean isHtmlContentType(String string) {
        if (string == null) {
            return false;
        }
        String string2 = "text/html";
        int n = string2.length();
        if (string.length() < n) {
            return false;
        }
        return string.substring(0, n).equalsIgnoreCase(string2);
    }

    private boolean isGzipCompressionType(String string) {
        if (string == null) {
            return false;
        }
        return "gzip".equalsIgnoreCase(string);
    }

    private boolean isLzssCompressionType(short s) {
        return s == -84;
    }

    private boolean isZlibCompressionType(short s) {
        return s == -83;
    }

    private PlatformData createEmptyPlatformData() {
        VariableList variableList = new VariableList();
        DatasetList datasetList = new DatasetList();
        return new PlatformData(variableList, datasetList, this.charset);
    }

    private String findCharsetFromXmlHeader(String string) {
        int n = string.indexOf("encoding=\"");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf("\"?>", n + 10);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n + 10, n2).trim();
        return Codepage.isSupportedCharset(string2) ? string2 : null;
    }

    private String findCharsetFromContentType(String string) {
        String string2;
        String string3 = "charset=";
        int n = string.indexOf(string3);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(59, n += string3.length());
        if (n2 == -1) {
            n2 = string.length();
        }
        return Codepage.isSupportedCharset(string2 = string.substring(n, n2).trim()) ? string2 : null;
    }

    private short readShort(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public boolean isStreamLog() {
        return this.isStreamLog;
    }

    public void setStreamLog(boolean bl) {
        this.isStreamLog = bl;
    }

    public void storeStreamLog() throws IOException {
        if (this.logStream != null) {
            this.logStream.storeStreamLog();
        }
    }

    public String getLogDir() {
        return this.logDir;
    }

    public void setLogDir(String string) {
        this.logDir = string;
    }

    public int getLogMaxSize() {
        return this.logMaxSize;
    }

    public void setLogMaxSize(int n) {
        this.logMaxSize = n;
    }

    public String getLogPrefix() {
        return this.logPrefix;
    }

    public void setLogPrefix(String string) {
        this.logPrefix = string;
    }

    public String getLogSuffix() {
        return this.logSuffix;
    }

    public void setLogSuffix(String string) {
        this.logSuffix = string;
    }

    private StreamLogInputStream createStreamLogInputStream(InputStream inputStream) {
        StreamLogInputStream streamLogInputStream = new StreamLogInputStream(inputStream);
        streamLogInputStream.setLogDir(this.getLogDir());
        streamLogInputStream.setLogMaxSize(this.getLogMaxSize());
        streamLogInputStream.setLogPrefix(this.getLogPrefix());
        streamLogInputStream.setLogSuffix(this.getLogSuffix());
        return streamLogInputStream;
    }

    private static Locale getLocale(int n) {
        if (n < 0) {
            return null;
        }
        int[] nArray = codes;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return new Locale(languages[i][0], languages[i][1]);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

