/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform;

import com.tobesoft.platform.LZSSOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class PlatformOutputStream
extends DataOutputStream {
    public static final int BUF_SIZE = 8192;
    private LZSSOutputStream lzssStream;
    private ByteArrayOutputStream compressedStream;
    private DataOutputStream compressedHeaderStream;
    private ByteArrayOutputStream dataStream;
    private OutputStream stream;
    private boolean compress;
    private CRC32 checksum = new CRC32();

    public PlatformOutputStream(OutputStream outputStream) {
        super(new ByteArrayOutputStream());
        this.dataStream = (ByteArrayOutputStream)this.out;
        this.compressedStream = new ByteArrayOutputStream(8192);
        this.lzssStream = new LZSSOutputStream(this.compressedStream);
        this.stream = outputStream;
        this.compressedHeaderStream = new DataOutputStream(this.stream);
        this.compress = true;
    }

    public void send() throws IOException {
        if (this.compress) {
            this.lzssStream.write(this.dataStream.toByteArray(), 0, this.dataStream.size());
            this.lzssStream.flush();
            this.checksum.reset();
            this.checksum.update(this.compressedStream.toByteArray(), 0, this.compressedStream.size());
            this.compressedHeaderStream.writeShort(-84);
            this.compressedHeaderStream.writeInt((int)this.checksum.getValue());
            this.compressedStream.writeTo(this.stream);
            this.stream.flush();
            this.compressedStream.reset();
            this.dataStream.reset();
        }
    }

    public void disableCompress() {
        this.compress = false;
        this.out = this.stream;
    }

    public void close() throws IOException {
        super.close();
        this.compressedHeaderStream.close();
        this.lzssStream.close();
    }
}

