/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform;

import com.tobesoft.platform.LZSSInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class PlatformInputStream
extends DataInputStream {
    public static final short TOBE_COMPRESS_MARK = -84;
    public static final short TOBE_COMPRESS_OLDMARK = -21249;
    public static final int BUF_SIZE = 4096;
    public static final int HEADER_SIZE = 6;
    private DataInputStream stream;
    private CRC32 checksum;

    public PlatformInputStream(InputStream inputStream) {
        super(new ByteArrayInputStream(new byte[0]));
        this.stream = new DataInputStream(inputStream);
        this.checksum = new CRC32();
    }

    public void receive(int n) throws IOException {
        int n2;
        int n3;
        long l = (long)this.stream.readInt() & 0xFFFFFFFFL;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n - 6);
        this.checksum.reset();
        byte[] byArray = new byte[4096];
        for (int i = 0; (this.stream.available() > 0 || i < n) && (n3 = this.stream.read(byArray)) != -1; i += n3) {
            byteArrayOutputStream.write(byArray, 0, n3);
            this.checksum.update(byArray, 0, n3);
        }
        if (l != this.checksum.getValue()) {
            throw new IOException("CRC \uc624\ub958");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        LZSSInputStream lZSSInputStream = new LZSSInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[4096];
        while ((n2 = lZSSInputStream.read(byArray2, 0, byArray2.length)) != -1) {
            byteArrayOutputStream2.write(byArray2, 0, n2);
        }
        lZSSInputStream.close();
        byteArrayOutputStream2.close();
        this.in = new ByteArrayInputStream(byteArrayOutputStream2.toByteArray());
    }

    public void close() throws IOException {
        super.close();
        this.stream.close();
    }
}

