/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform;

import com.tobesoft.platform.Platform;
import com.tobesoft.platform.PlatformConstants;
import com.tobesoft.platform.data.Dataset;
import com.tobesoft.platform.data.DatasetList;
import com.tobesoft.platform.data.PlatformData;
import com.tobesoft.platform.data.VariableList;
import com.tobesoft.platform.util.Codepage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformFRResponse
implements PlatformConstants {
    static Log log = LogFactory.getLog((Class)(class$com$tobesoft$platform$PlatformFRResponse == null ? (class$com$tobesoft$platform$PlatformFRResponse = PlatformFRResponse.class$("com.tobesoft.platform.PlatformFRResponse")) : class$com$tobesoft$platform$PlatformFRResponse));
    static final short FIRST_ROW_START_MARK = -96;
    static final short FIRST_ROW_CONTINUE_MARK = -95;
    static final short FIRST_ROW_LAST_MARK = -94;
    private DataOutputStream dataStream;
    private OutputStream outputStream;
    private ByteArrayOutputStream bufferStream;
    private short version;
    private String charset;
    static /* synthetic */ Class class$com$tobesoft$platform$PlatformFRResponse;

    public PlatformFRResponse(HttpServletResponse httpServletResponse) throws IOException {
        this(httpServletResponse, Codepage.getDefaultCharset());
    }

    public PlatformFRResponse(HttpServletResponse httpServletResponse, short s) throws IOException {
        this(httpServletResponse, s, Codepage.getDefaultCharset());
    }

    public PlatformFRResponse(HttpServletResponse httpServletResponse, String string) throws IOException {
        this(httpServletResponse, 4000, string);
    }

    public PlatformFRResponse(HttpServletResponse httpServletResponse, short s, String string) throws IOException {
        this.outputStream = httpServletResponse.getOutputStream();
        this.bufferStream = new ByteArrayOutputStream();
        this.dataStream = new DataOutputStream(this.bufferStream);
        this.version = s;
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
    }

    public PlatformFRResponse(OutputStream outputStream) {
        this(outputStream, Codepage.getDefaultCharset());
    }

    public PlatformFRResponse(OutputStream outputStream, short s) {
        this(outputStream, s, Codepage.getDefaultCharset());
    }

    public PlatformFRResponse(OutputStream outputStream, String string) {
        this(outputStream, 3100, string);
    }

    public PlatformFRResponse(OutputStream outputStream, short s, String string) {
        this.outputStream = outputStream;
        this.bufferStream = new ByteArrayOutputStream();
        this.dataStream = new DataOutputStream(this.bufferStream);
        this.version = s;
        this.charset = Codepage.isSupportedCharset(string) ? string : Codepage.getDefaultCharset();
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        if (Codepage.isSupportedCharset(string)) {
            this.charset = string;
        }
    }

    public void disableCompress() {
    }

    public void sendFirstData(PlatformData platformData) throws IOException {
        this.sendFirstData(platformData.getVariableList(), platformData.getDatasetList());
    }

    public void sendFirstData(VariableList variableList, DatasetList datasetList) throws IOException {
        int n = datasetList.size();
        this.dataStream.writeShort(n + 1);
        if (this.version == 0 || this.version >= 4000) {
            this.sendFirstDataStream400(variableList, datasetList);
            return;
        }
        if (this.version >= 3100) {
            variableList.writeTo(this.dataStream, this.charset, this.version);
            datasetList.writeTo(this.dataStream, this.charset, this.version, (short)5);
        } else {
            variableList.writeTo(this.dataStream, this.charset);
            datasetList.writeTo(this.dataStream, this.charset, (short)5);
        }
        this.dataStream.flush();
        DataOutputStream dataOutputStream = new DataOutputStream(this.outputStream);
        dataOutputStream.writeShort(-96);
        dataOutputStream.writeInt(this.bufferStream.size());
        dataOutputStream.write(this.bufferStream.toByteArray(), 0, this.bufferStream.size());
        this.bufferStream.reset();
    }

    private void sendFirstDataStream400(VariableList variableList, DatasetList datasetList) throws IOException {
        Object object;
        variableList.writeTo(this.dataStream, this.charset, this.version);
        int n = datasetList.size();
        for (int i = 0; i < n - 1; ++i) {
            object = datasetList.getByOrder(i);
            ((Dataset)object).setCharset(this.charset);
            ((Dataset)object).writeTo(this.dataStream, this.version, (short)5);
            if (!Platform.isDebug() || !log.isDebugEnabled()) continue;
            log.debug((Object)("ds id=" + ((Dataset)object).getId() + ", i=" + i + ", order=" + ((Dataset)object).getOrder()));
        }
        Dataset dataset = datasetList.getByOrder(n - 1);
        dataset.writeTo(this.dataStream, this.version, (short)5, false);
        this.dataStream.flush();
        object = new DataOutputStream(this.outputStream);
        ((DataOutputStream)object).write(this.bufferStream.toByteArray(), 0, this.bufferStream.size());
        this.bufferStream.reset();
    }

    public void sendNextData(Dataset dataset, int n, int n2, boolean bl) throws IOException {
        if (this.version == 0 || this.version >= 4000) {
            this.sendNextDataStream400(dataset, n, n2, bl);
            return;
        }
        dataset.writeTo(this.dataStream, n, n2);
        this.dataStream.flush();
        DataOutputStream dataOutputStream = new DataOutputStream(this.outputStream);
        if (bl) {
            dataOutputStream.writeShort(-95);
        } else {
            dataOutputStream.writeShort(-94);
        }
        dataOutputStream.writeInt(this.bufferStream.size());
        dataOutputStream.write(this.bufferStream.toByteArray(), 0, this.bufferStream.size());
        if (bl) {
            this.bufferStream.reset();
        } else {
            dataOutputStream.close();
        }
    }

    private void sendNextDataStream400(Dataset dataset, int n, int n2, boolean bl) throws IOException {
        dataset.writeTo(this.dataStream, n, n2, this.version);
        this.dataStream.flush();
        DataOutputStream dataOutputStream = new DataOutputStream(this.outputStream);
        dataOutputStream.write(this.bufferStream.toByteArray(), 0, this.bufferStream.size());
        if (bl) {
            this.bufferStream.reset();
        } else {
            dataOutputStream.writeInt(0);
            dataOutputStream.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

