/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform;

import com.tobesoft.platform.PlatformConstants;
import com.tobesoft.platform.util.HangulProperties;
import com.tobesoft.platform.util.NullOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Platform
implements PlatformConstants {
    static Log log;
    static final String PLATFORM_PROPERTIES = "platform.properties";
    static final String PLATFORM_PREFIX = "platform";
    static final String PROPERTY_CHARSET = "platform.charset";
    static final String PROPERTY_CONTENT_TYPE = "platform.contentType";
    static final int DEFAULT_CONTENT_TYPE = 1;
    static final String PROPERTY_COMPRESSION_TYPE = "platform.compressionType";
    static final int DEFAULT_COMPRESSION_TYPE = 0;
    static final String PROPERTY_STREAM_VERSION = "platform.streamVersion";
    static final short DEFAULT_STREAM_VERSION = 3100;
    static final String PROPERTY_DEBUG = "platform.debug";
    static final boolean DEFAULT_DEBUG = false;
    static final String PROPERTY_DUPLICATED_COLUMN_ID = "platform.duplicatedColumnId";
    static final boolean DEFAULT_DUPLICATED_COLUMN_ID = false;
    private static Properties env;
    private static String charset;
    private static int contentType;
    private static int compressionType;
    private static short streamVersion;
    private static boolean isDebug;
    private static boolean checkDuplicatedColumnId;
    static /* synthetic */ Class class$com$tobesoft$platform$Platform;

    private Platform() {
    }

    public static String getCharset() {
        return charset;
    }

    public static int getContentType() {
        return contentType;
    }

    public static int getCompressionType() {
        return compressionType;
    }

    public static short getStreamVersion() {
        return streamVersion;
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static boolean checkDuplicatedColumnId() {
        return checkDuplicatedColumnId;
    }

    public static String getString(String string) {
        return Platform.getString(string, null);
    }

    public static String getString(String string, String string2) {
        String string3 = env.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    public static int getInt(String string) {
        return Platform.getInt(string, 0);
    }

    public static int getInt(String string, int n) {
        block3: {
            String string2 = Platform.getString(string);
            if (!Platform.isEmpty(string2)) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"\ud658\uacbd\ubcc0\uc218 \uc815\uc218 \ubcc0\ud658 \uc624\ub958", (Throwable)numberFormatException);
                }
            }
        }
        return n;
    }

    public static short getShort(String string) {
        return Platform.getShort(string, (short)0);
    }

    public static short getShort(String string, short s) {
        block3: {
            String string2 = Platform.getString(string);
            if (!Platform.isEmpty(string2)) {
                try {
                    return Short.parseShort(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"\ud658\uacbd\ubcc0\uc218 \uc815\uc218 \ubcc0\ud658 \uc624\ub958", (Throwable)numberFormatException);
                }
            }
        }
        return s;
    }

    public static boolean getBoolean(String string) {
        return Platform.getBoolean(string, false);
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = Platform.getString(string);
        return Platform.isEmpty(string2) ? bl : "true".equalsIgnoreCase(string2) || "yes".equalsIgnoreCase(string2);
    }

    public static String getPath(String string) {
        return Platform.getPath(string, null);
    }

    public static String getPath(String string, String string2) {
        String string3 = Platform.getString(string, string2);
        return Platform.isEmpty(string3) ? string3 : Platform.normalizePath(string3);
    }

    private static void init() {
        charset = Platform.findCharset();
        contentType = Platform.findContentType();
        compressionType = Platform.findCompressionType();
        streamVersion = Platform.findStreamVersion();
        checkDuplicatedColumnId = !Platform.findDuplicatedColumnId();
        isDebug = Platform.findDebug();
    }

    private static String findCharset() {
        String string = Platform.getString(PROPERTY_CHARSET);
        return Platform.isEmpty(string) ? Platform.getSystemCharset() : string;
    }

    private static int findContentType() {
        String string = Platform.getString(PROPERTY_CONTENT_TYPE);
        if (Platform.isEmpty(string)) {
            return 1;
        }
        if ("xml".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("bin".equalsIgnoreCase(string)) {
            return 2;
        }
        return 1;
    }

    private static int findCompressionType() {
        String string = Platform.getString(PROPERTY_COMPRESSION_TYPE);
        if (Platform.isEmpty(string)) {
            return 0;
        }
        if ("none".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("zlib".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("gzip".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("lzss".equalsIgnoreCase(string)) {
            return 3;
        }
        return 0;
    }

    private static short findStreamVersion() {
        short s = Platform.getShort(PROPERTY_STREAM_VERSION, (short)3100);
        return s < 0 ? (short)3100 : (short)s;
    }

    private static boolean findDuplicatedColumnId() {
        return Platform.getBoolean(PROPERTY_DUPLICATED_COLUMN_ID, false);
    }

    private static boolean findDebug() {
        return Platform.getBoolean(PROPERTY_DEBUG, false);
    }

    private static String getSystemCharset() {
        String string;
        block2: {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new NullOutputStream());
            string = outputStreamWriter.getEncoding();
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)"\uc2dc\uc2a4\ud15c \ubb38\uc790\uc14b \ud655\uc778 \uc624\ub958", (Throwable)iOException);
            }
        }
        return string;
    }

    private static String normalizePath(String string) {
        int n;
        if (Platform.isEmpty(string)) {
            return string;
        }
        String string2 = string;
        char c = File.separatorChar;
        char c2 = c == '/' ? (char)'\\' : '/';
        if (string2.indexOf(c2) != -1) {
            string2 = string.replace(c2, File.separatorChar);
        }
        if (string2.charAt((n = string2.length()) - 1) == c) {
            string2 = string2.substring(0, n - 1);
        }
        return string2;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        block2: {
            log = LogFactory.getLog((Class)(class$com$tobesoft$platform$Platform == null ? (class$com$tobesoft$platform$Platform = Platform.class$("com.tobesoft.platform.Platform")) : class$com$tobesoft$platform$Platform));
            env = new HangulProperties();
            InputStream inputStream = (class$com$tobesoft$platform$Platform == null ? (class$com$tobesoft$platform$Platform = Platform.class$("com.tobesoft.platform.Platform")) : class$com$tobesoft$platform$Platform).getResourceAsStream(PLATFORM_PROPERTIES);
            try {
                env.load(inputStream);
            }
            catch (IOException iOException) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("\ud658\uacbd\ud30c\uc77c \uc801\uc7ac \uc624\ub958, in=" + inputStream), (Throwable)iOException);
            }
        }
        Platform.init();
    }
}

