/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class LZSSOutputStream
extends FilterOutputStream {
    private static final int N = 4096;
    private static final int F = 18;
    private static final int THRESHOLD = 2;
    private CompressBuffer compressBuffer;
    private CRC32 crc = new CRC32();

    public LZSSOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.crc.reset();
        this.compressBuffer = new CompressBuffer();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.write(n2, byArray, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
            Object var2_1 = null;
            this.compressBuffer.lson = null;
            this.compressBuffer.rson = null;
            this.compressBuffer.dad = null;
            this.compressBuffer.textBuffer = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.compressBuffer.lson = null;
            this.compressBuffer.rson = null;
            this.compressBuffer.dad = null;
            this.compressBuffer.textBuffer = null;
            throw throwable;
        }
    }

    public Checksum getChecksum() {
        return this.crc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            this.flush();
        }
        finally {
            super.finalize();
        }
    }

    private final void initTree() {
        int n;
        for (n = 4097; n <= 4352; ++n) {
            this.compressBuffer.rson[n] = 4096;
        }
        for (n = 0; n < 4096; ++n) {
            this.compressBuffer.dad[n] = 4096;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void insertNode(int n) {
        int n2 = 1;
        int n3 = 4097 + (this.compressBuffer.textBuffer[n] & 0xFF);
        this.compressBuffer.rson[n] = 4096;
        this.compressBuffer.lson[n] = 4096;
        this.compressBuffer.matchLength = 0;
        while (true) {
            if (n2 >= 0) {
                if (this.compressBuffer.rson[n3] == 4096) {
                    this.compressBuffer.rson[n3] = n;
                    this.compressBuffer.dad[n] = n3;
                    return;
                }
                n3 = this.compressBuffer.rson[n3];
            } else {
                if (this.compressBuffer.lson[n3] == 4096) {
                    this.compressBuffer.lson[n3] = n;
                    this.compressBuffer.dad[n] = n3;
                    return;
                }
                n3 = this.compressBuffer.lson[n3];
            }
            int n4 = 0;
            for (n4 = 1; n4 < 18 && (n2 = (this.compressBuffer.textBuffer[n + n4] & 0xFF) - (this.compressBuffer.textBuffer[n3 + n4] & 0xFF)) == 0; ++n4) {
            }
            if (n4 <= this.compressBuffer.matchLength) continue;
            this.compressBuffer.matchPosition = n3;
            this.compressBuffer.matchLength = n4;
            if (this.compressBuffer.matchLength >= 18) break;
        }
        this.compressBuffer.dad[n] = this.compressBuffer.dad[n3];
        this.compressBuffer.lson[n] = this.compressBuffer.lson[n3];
        this.compressBuffer.rson[n] = this.compressBuffer.rson[n3];
        this.compressBuffer.dad[this.compressBuffer.lson[n3]] = n;
        this.compressBuffer.dad[this.compressBuffer.rson[n3]] = n;
        if (this.compressBuffer.rson[this.compressBuffer.dad[n3]] == n3) {
            this.compressBuffer.rson[this.compressBuffer.dad[n3]] = n;
        } else {
            this.compressBuffer.lson[this.compressBuffer.dad[n3]] = n;
        }
        this.compressBuffer.dad[n3] = 4096;
    }

    private final void deleteNode(int n) {
        int n2;
        if (this.compressBuffer.dad[n] == 4096) {
            return;
        }
        if (this.compressBuffer.rson[n] == 4096) {
            n2 = this.compressBuffer.lson[n];
        } else if (this.compressBuffer.lson[n] == 4096) {
            n2 = this.compressBuffer.rson[n];
        } else {
            n2 = this.compressBuffer.lson[n];
            if (this.compressBuffer.rson[n2] != 4096) {
                while (this.compressBuffer.rson[n2 = this.compressBuffer.rson[n2]] != 4096) {
                }
                this.compressBuffer.rson[this.compressBuffer.dad[n2]] = this.compressBuffer.lson[n2];
                this.compressBuffer.dad[this.compressBuffer.lson[n2]] = this.compressBuffer.dad[n2];
                this.compressBuffer.lson[n2] = this.compressBuffer.lson[n];
                this.compressBuffer.dad[this.compressBuffer.lson[n]] = n2;
            }
            this.compressBuffer.rson[n2] = this.compressBuffer.rson[n];
            this.compressBuffer.dad[this.compressBuffer.rson[n]] = n2;
        }
        this.compressBuffer.dad[n2] = this.compressBuffer.dad[n];
        if (this.compressBuffer.rson[this.compressBuffer.dad[n]] == n) {
            this.compressBuffer.rson[this.compressBuffer.dad[n]] = n2;
        } else {
            this.compressBuffer.lson[this.compressBuffer.dad[n]] = n2;
        }
        this.compressBuffer.dad[n] = 4096;
    }

    private final void write(int n, byte[] byArray, int n2, boolean bl) throws IOException {
        int n3;
        this.initTree();
        int n4 = 0;
        int n5 = 4078;
        for (n3 = n4; n3 < n5; ++n3) {
            this.compressBuffer.textBuffer[n3] = 32;
        }
        n3 = 0;
        for (n3 = 0; n3 < 18 && n3 < n; ++n3) {
            this.compressBuffer.textBuffer[n5 + n3] = byArray[n3];
        }
        if (n3 == 0) {
            return;
        }
        int n6 = n3;
        for (int i = 1; i <= 18; ++i) {
            this.insertNode(n5 - i);
        }
        this.insertNode(n5);
        byte[] byArray2 = new byte[17];
        byArray2[0] = 0;
        int n7 = 1;
        byte by = 1;
        do {
            if (this.compressBuffer.matchLength > n3) {
                this.compressBuffer.matchLength = n3;
            }
            if (this.compressBuffer.matchLength <= 2) {
                this.compressBuffer.matchLength = 1;
                byArray2[0] = (byte)(byArray2[0] | by);
                byArray2[n7++] = this.compressBuffer.textBuffer[n5];
            } else {
                byArray2[n7++] = (byte)this.compressBuffer.matchPosition;
                byArray2[n7++] = (byte)(this.compressBuffer.matchPosition >> 4 & 0xF0 | this.compressBuffer.matchLength - 3);
            }
            by = (byte)(by << 1);
            if (by == 0) {
                this.out.write(byArray2, 0, n7);
                this.crc.update(byArray2, 0, n7);
                byArray2[0] = 0;
                n7 = 1;
                by = 1;
            }
            int n8 = this.compressBuffer.matchLength;
            int n9 = 0;
            for (n9 = 0; n9 < n8 && n6 < n; ++n9) {
                byte by2 = byArray[n6++];
                this.deleteNode(n4);
                this.compressBuffer.textBuffer[n4] = by2;
                if (n4 < 17) {
                    this.compressBuffer.textBuffer[n4 + 4096] = by2;
                }
                n4 = n4 + 1 & 0xFFF;
                n5 = n5 + 1 & 0xFFF;
                this.insertNode(n5);
            }
            while (n9++ < n8) {
                this.deleteNode(n4);
                n4 = n4 + 1 & 0xFFF;
                n5 = n5 + 1 & 0xFFF;
                if (--n3 == 0) continue;
                this.insertNode(n5);
            }
        } while (n3 > 0);
        if (n7 > 1) {
            this.out.write(byArray2, 0, n7);
            this.crc.update(byArray2, 0, n7);
        }
    }

    private class CompressBuffer {
        byte[] textBuffer = new byte[4113];
        int matchPosition = 0;
        int matchLength = 0;
        int[] lson = new int[4097];
        int[] rson = new int[4353];
        int[] dad = new int[4097];

        CompressBuffer() {
        }
    }
}

