/*
 * Decompiled with CFR 0.152.
 */
package com.tobesoft.platform;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class LZSSInputStream
extends FilterInputStream {
    private static final int N = 4096;
    private static final int F = 18;
    private static final int THRESHOLD = 2;
    private CRC32 crc = new CRC32();
    private int state;
    private int i;
    private int j;
    private int k;
    private int r;
    private int c;
    private int flags;
    private byte[] textBuffer;

    public LZSSInputStream(InputStream inputStream) {
        super(inputStream);
        this.crc.reset();
        this.textBuffer = new byte[4113];
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, byArray.length);
        return n == -1 ? -1 : byArray[0] & 0xFF;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.state == 0) {
            this.r = 4078;
            this.flags = 0;
        }
        while (n2 > 0) {
            if (this.state == 2 && this.k <= this.j) {
                this.c = this.textBuffer[this.i + this.k & 0xFFF];
                this.textBuffer[this.r++] = (byte)this.c;
                byArray[n++] = (byte)this.c;
                this.r &= 0xFFF;
                ++this.k;
                --n2;
                ++n3;
                continue;
            }
            if (((this.flags >>>= 1) & 0x100) == 0) {
                this.c = this.in.read();
                if (this.c == -1) break;
                this.crc.update(this.c);
                this.flags = this.c | 0xFF00;
            }
            if ((this.flags & 1) == 1) {
                this.c = this.in.read();
                if (this.c == -1) break;
                this.crc.update(this.c);
                this.textBuffer[this.r++] = (byte)this.c;
                this.r &= 0xFFF;
                byArray[n++] = (byte)this.c;
                ++n3;
                --n2;
                this.state = 1;
                continue;
            }
            this.i = this.in.read();
            if (this.i == -1 || (this.j = this.in.read()) == -1) break;
            this.crc.update(this.i);
            this.crc.update(this.j);
            this.i |= (this.j & 0xF0) << 4;
            this.j = (this.j & 0xF) + 2;
            this.k = 0;
            this.state = 2;
        }
        return n3 == 0 ? -1 : n3;
    }

    public long skip(long l) {
        return 0L;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("\ubbf8\uc9c0\uc6d0");
    }

    public boolean markSupported() {
        return false;
    }

    public Checksum getChecksum() {
        return this.crc;
    }
}

